/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.expressionannotations;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.util.FlowExpressionParseUtil;

public class ExpressionAnnotationError {
    private static final String formatString = "[error for expression: %s error: %s]";
    private static final Pattern errorPattern = Pattern.compile("\\[error for expression: (.*) error: (.*)\\]");
    public final String expression;
    public final String error;

    public static boolean isExpressionError(String expression) {
        Matcher matcher = errorPattern.matcher(expression);
        return matcher.matches() && matcher.groupCount() == 2;
    }

    public ExpressionAnnotationError(String expression, String error) {
        this.expression = expression;
        this.error = error;
    }

    public ExpressionAnnotationError(String expression, FlowExpressionParseUtil.FlowExpressionParseException e) {
        StringBuffer buf = new StringBuffer();
        List<Result.DiagMessage> msgs = e.getResult().getDiagMessages();
        for (Result.DiagMessage msg : msgs) {
            buf.append(msg.getArgs()[0]);
        }
        this.error = buf.toString();
        this.expression = expression;
    }

    public ExpressionAnnotationError(String error) {
        Matcher matcher = errorPattern.matcher(error);
        if (matcher.matches() && matcher.groupCount() == 2) {
            this.expression = matcher.group(1);
            this.error = matcher.group(2);
        } else {
            this.error = error;
            this.expression = "";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionAnnotationError that = (ExpressionAnnotationError)o;
        return this.expression.equals(that.expression) && this.error.equals(that.error);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.error.hashCode();
        return result;
    }

    public String toString() {
        return String.format(formatString, this.expression, this.error);
    }
}

