/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.Resolver;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class FlowExpressionParseUtil {
    protected static final String identifierRegex = "[a-zA-Z_$][a-zA-Z_$0-9]*";
    protected static final String parameterRegex = "#([1-9][0-9]*)";
    protected static final Pattern unanchoredParameterPattern = Pattern.compile("#([1-9][0-9]*)");
    protected static final Pattern parameterPattern = FlowExpressionParseUtil.anchored("#([1-9][0-9]*)");
    protected static final Pattern thisPattern = FlowExpressionParseUtil.anchored("this");
    protected static final Pattern superPattern = FlowExpressionParseUtil.anchored("super");
    protected static final Pattern identifierPattern = FlowExpressionParseUtil.anchored("[a-zA-Z_$][a-zA-Z_$0-9]*");
    protected static final Pattern methodPattern = FlowExpressionParseUtil.anchored("([a-zA-Z_$][a-zA-Z_$0-9]*)\\((.*)\\)");
    protected static final Pattern arrayPattern = FlowExpressionParseUtil.anchored("(.*)\\[(.*)\\]");
    protected static final Pattern memberselect = FlowExpressionParseUtil.anchored("([^.]+)\\.(.+)");
    protected static final Pattern intPattern = FlowExpressionParseUtil.anchored("[-+]?[1-9][0-9]*");
    protected static final Pattern longPattern = FlowExpressionParseUtil.anchored("[-+]?[1-9][0-9]*L");
    protected static final Pattern stringPattern = FlowExpressionParseUtil.anchored("\"(?:[^\"\\\\]|\\\\.)*\"");
    protected static final Pattern nullPattern = FlowExpressionParseUtil.anchored("null");
    protected static final Pattern parenthesesPattern = FlowExpressionParseUtil.anchored("\\((.*)\\)");

    private static Pattern anchored(String regex) {
        return Pattern.compile("^" + regex + "$");
    }

    public static FlowExpressions.Receiver parse(String expression, FlowExpressionContext context, TreePath localScope, boolean useLocalScope) throws FlowExpressionParseException {
        context.useLocalScope = useLocalScope;
        FlowExpressions.Receiver result = FlowExpressionParseUtil.parseHelper(expression, context, localScope);
        if (result instanceof FlowExpressions.ClassName && !expression.endsWith("class")) {
            throw FlowExpressionParseUtil.constructParserException(expression, "a class name cannot terminate a flow expression string");
        }
        return result;
    }

    private static FlowExpressions.Receiver parseHelper(String expression, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        expression = expression.trim();
        ProcessingEnvironment env = context.checkerContext.getProcessingEnvironment();
        Types types = env.getTypeUtils();
        if (FlowExpressionParseUtil.isNullLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseNullLiteral(expression, types);
        }
        if (FlowExpressionParseUtil.isIntLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseIntLiteral(expression, types);
        }
        if (FlowExpressionParseUtil.isLongLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseLongLiteral(expression, types);
        }
        if (FlowExpressionParseUtil.isStringLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseStringLiteral(expression, types, env.getElementUtils());
        }
        if (FlowExpressionParseUtil.isThisLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseThis(expression, context);
        }
        if (FlowExpressionParseUtil.isSuperLiteral(expression, context)) {
            return FlowExpressionParseUtil.parseSuper(expression, types, context);
        }
        if (FlowExpressionParseUtil.isIdentifier(expression, context)) {
            return FlowExpressionParseUtil.parseIdentifier(expression, env, path, context);
        }
        if (FlowExpressionParseUtil.isParameter(expression, context)) {
            return FlowExpressionParseUtil.parseParameter(expression, context);
        }
        if (FlowExpressionParseUtil.isArray(expression, context)) {
            return FlowExpressionParseUtil.parseArray(expression, context, path);
        }
        if (FlowExpressionParseUtil.isMethod(expression, context)) {
            return FlowExpressionParseUtil.parseMethod(expression, context, path, env);
        }
        if (FlowExpressionParseUtil.isMemberSelect(expression, context)) {
            return FlowExpressionParseUtil.parseMemberSelect(expression, env, context, path);
        }
        if (FlowExpressionParseUtil.isParentheses(expression, context)) {
            return FlowExpressionParseUtil.parseParentheses(expression, context, path);
        }
        throw FlowExpressionParseUtil.constructParserException(expression, "could not parse string");
    }

    private static boolean isMemberSelect(String s2, FlowExpressionContext context) {
        Matcher dotMatcher = memberselect.matcher(s2);
        return dotMatcher.matches();
    }

    private static FlowExpressions.Receiver parseMemberSelect(String s2, ProcessingEnvironment env, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        String memberSelected;
        FlowExpressions.Receiver receiver;
        Matcher dotMatcher = memberselect.matcher(s2);
        if (!dotMatcher.matches()) assert (false) : "isMemberSelect must be called first";
        Resolver resolver = new Resolver(env);
        Pair<FlowExpressions.ClassName, String> classAndRemainingString = FlowExpressionParseUtil.matchPackageAndClassNameWithinExpression(s2, resolver, path);
        if (classAndRemainingString != null) {
            receiver = (FlowExpressions.Receiver)classAndRemainingString.first;
            memberSelected = (String)classAndRemainingString.second;
            if (memberSelected == null) {
                throw FlowExpressionParseUtil.constructParserException(s2, "a class cannot terminate a flow expression string");
            }
        } else {
            String receiverString = dotMatcher.group(1);
            memberSelected = dotMatcher.group(2);
            receiver = FlowExpressionParseUtil.parseHelper(receiverString, context, path);
        }
        if (memberSelected.equals("class")) {
            if (receiver instanceof FlowExpressions.ClassName && !context.parsingMember) {
                return receiver;
            }
            throw FlowExpressionParseUtil.constructParserException(s2, "class is not a legal identifier");
        }
        FlowExpressionContext newContext = context.copyChangeToParsingMemberOfReceiver(receiver);
        return FlowExpressionParseUtil.parseHelper(memberSelected, newContext, path);
    }

    private static boolean isNullLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher nullMatcher = nullPattern.matcher(s2);
        return nullMatcher.matches();
    }

    private static FlowExpressions.Receiver parseNullLiteral(String expression, Types types) {
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getNullType(), (Object)null);
    }

    private static boolean isIntLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher intMatcher = intPattern.matcher(s2);
        return intMatcher.matches();
    }

    private static FlowExpressions.Receiver parseIntLiteral(String s2, Types types) {
        int val = Integer.parseInt(s2);
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getPrimitiveType(TypeKind.INT), val);
    }

    private static boolean isLongLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher longMatcher = longPattern.matcher(s2);
        return longMatcher.matches();
    }

    private static FlowExpressions.Receiver parseLongLiteral(String s2, Types types) {
        s2 = s2.substring(0, s2.length() - 1);
        long val = Long.parseLong(s2);
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getPrimitiveType(TypeKind.LONG), val);
    }

    private static boolean isStringLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher stringMatcher = stringPattern.matcher(s2);
        return stringMatcher.matches();
    }

    private static FlowExpressions.Receiver parseStringLiteral(String s2, Types types, Elements elements) {
        TypeElement stringTypeElem = elements.getTypeElement("java.lang.String");
        return new FlowExpressions.ValueLiteral((TypeMirror)types.getDeclaredType(stringTypeElem, new TypeMirror[0]), s2.substring(1, s2.length() - 1));
    }

    private static boolean isThisLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher thisMatcher = thisPattern.matcher(s2);
        return thisMatcher.matches();
    }

    private static FlowExpressions.Receiver parseThis(String s2, FlowExpressionContext context) {
        if (context.receiver != null && !context.receiver.containsUnknown()) {
            return context.receiver;
        }
        return new FlowExpressions.ThisReference(context.receiver == null ? null : context.receiver.getType());
    }

    private static boolean isSuperLiteral(String s2, FlowExpressionContext context) {
        if (context.parsingMember) {
            return false;
        }
        Matcher superMatcher = superPattern.matcher(s2);
        return superMatcher.matches();
    }

    private static FlowExpressions.Receiver parseSuper(String s2, Types types, FlowExpressionContext context) throws FlowExpressionParseException {
        List<? extends TypeMirror> superTypes = types.directSupertypes(context.receiver.getType());
        TypeMirror superType = null;
        for (TypeMirror typeMirror : superTypes) {
            Type.ClassType tt;
            if (!(typeMirror instanceof Type.ClassType) || (tt = (Type.ClassType)typeMirror).isInterface()) continue;
            superType = typeMirror;
            break;
        }
        if (superType == null) {
            throw FlowExpressionParseUtil.constructParserException(s2, "super class not found");
        }
        return new FlowExpressions.ThisReference(superType);
    }

    private static boolean isIdentifier(String s2, FlowExpressionContext context) {
        Matcher identifierMatcher = identifierPattern.matcher(s2);
        return identifierMatcher.matches();
    }

    private static FlowExpressions.Receiver parseIdentifier(String s2, ProcessingEnvironment env, TreePath path, FlowExpressionContext context) throws FlowExpressionParseException {
        VariableElement varElem;
        Resolver resolver = new Resolver(env);
        if (!context.parsingMember && context.useLocalScope && (varElem = resolver.findLocalVariableOrParameterOrField(s2, path)) != null) {
            if (varElem.getKind() == ElementKind.FIELD) {
                boolean isOriginalReceiver = context.receiver instanceof FlowExpressions.ThisReference;
                return FlowExpressionParseUtil.getReceiverField(s2, context, isOriginalReceiver, varElem);
            }
            return new FlowExpressions.LocalVariable(varElem);
        }
        TypeMirror receiverType = context.receiver.getType();
        boolean originalReceiver = true;
        Element fieldElem = null;
        while (receiverType.getKind() == TypeKind.DECLARED && (fieldElem = resolver.findField(s2, receiverType, path)) == null) {
            receiverType = FlowExpressionParseUtil.getTypeOfEnclosingClass((DeclaredType)receiverType);
            originalReceiver = false;
        }
        if (fieldElem != null && fieldElem.getKind() == ElementKind.FIELD) {
            return FlowExpressionParseUtil.getReceiverField(s2, context, originalReceiver, (VariableElement)fieldElem);
        }
        Element classElem = resolver.findClass(s2, path);
        TypeMirror classType = ElementUtils.getType(classElem);
        if (classType != null) {
            return new FlowExpressions.ClassName(classType);
        }
        throw FlowExpressionParseUtil.constructParserException(s2, "identifier not found");
    }

    private static FlowExpressions.Receiver getReceiverField(String s2, FlowExpressionContext context, boolean originalReceiver, VariableElement fieldElem) throws FlowExpressionParseException {
        TypeMirror receiverType = context.receiver.getType();
        TypeMirror fieldType = ElementUtils.getType(fieldElem);
        if (ElementUtils.isStatic(fieldElem)) {
            Element classElem = fieldElem.getEnclosingElement();
            FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
            return new FlowExpressions.FieldAccess(staticClassReceiver, fieldType, fieldElem);
        }
        FlowExpressions.Receiver locationOfField = originalReceiver ? context.receiver : FlowExpressions.internalReprOf(context.checkerContext.getAnnotationProvider(), new ImplicitThisLiteralNode(receiverType));
        if (locationOfField instanceof FlowExpressions.ClassName) {
            throw FlowExpressionParseUtil.constructParserException(s2, "a non-static field cannot have a class name as a receiver.");
        }
        return new FlowExpressions.FieldAccess(locationOfField, fieldType, fieldElem);
    }

    private static boolean isParameter(String s2, FlowExpressionContext contex) {
        if (contex.parsingMember) {
            return false;
        }
        Matcher parameterMatcher = parameterPattern.matcher(s2);
        return parameterMatcher.matches();
    }

    private static FlowExpressions.Receiver parseParameter(String s2, FlowExpressionContext context) throws FlowExpressionParseException {
        int idx;
        block5: {
            Matcher parameterMatcher = parameterPattern.matcher(s2);
            if (!parameterMatcher.matches()) {
                return null;
            }
            if (context.arguments == null) {
                throw FlowExpressionParseUtil.constructParserException(s2, "No parameter found.");
            }
            idx = -1;
            try {
                idx = Integer.parseInt(parameterMatcher.group(1));
            }
            catch (NumberFormatException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        if (idx > context.arguments.size()) {
            throw new FlowExpressionParseException(Result.failure("flowexpr.parse.index.too.big", Integer.toString(idx)));
        }
        return context.arguments.get(idx - 1);
    }

    private static boolean isMethod(String s2, FlowExpressionContext contex) {
        Matcher methodMatcher = methodPattern.matcher(s2);
        return methodMatcher.matches();
    }

    private static FlowExpressions.Receiver parseMethod(String s2, FlowExpressionContext context, TreePath path, ProcessingEnvironment env) throws FlowExpressionParseException {
        Matcher methodMatcher = methodPattern.matcher(s2);
        if (!methodMatcher.matches()) {
            return null;
        }
        String methodName = methodMatcher.group(1);
        String parameterList = methodMatcher.group(2);
        List parameters = ParameterListParser.parseParameterList(parameterList, true, context.copyAndUseOuterReceiver(), path);
        ArrayList<TypeMirror> parameterTypes = new ArrayList<TypeMirror>();
        for (FlowExpressions.Receiver p : parameters) {
            parameterTypes.add(p.getType());
        }
        ExecutableElement methodElement = null;
        try {
            Element element = null;
            Resolver resolver = new Resolver(env);
            TypeMirror receiverType = context.receiver.getType();
            while (receiverType.getKind() == TypeKind.DECLARED && (element = resolver.findMethod(methodName, receiverType, path, parameterTypes)).getKind() != ElementKind.METHOD) {
                receiverType = FlowExpressionParseUtil.getTypeOfEnclosingClass((DeclaredType)receiverType);
            }
            if (element == null) {
                throw FlowExpressionParseUtil.constructParserException(s2, "element==null");
            }
            if (element.getKind() != ElementKind.METHOD) {
                throw FlowExpressionParseUtil.constructParserException(s2, "element.getKind()==" + (Object)((Object)element.getKind()));
            }
            methodElement = (ExecutableElement)element;
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement formal = methodElement.getParameters().get(i);
                TypeMirror formalType = formal.asType();
                FlowExpressions.Receiver actual = (FlowExpressions.Receiver)parameters.get(i);
                TypeMirror actualType = actual.getType();
                if (!TypesUtils.isBoxedPrimitive(formalType) || !TypesUtils.isPrimitive(actualType)) continue;
                Symbol.MethodSymbol valueOfMethod = TreeBuilder.getValueOfMethod(env, formalType);
                ArrayList<FlowExpressions.Receiver> p = new ArrayList<FlowExpressions.Receiver>();
                p.add(actual);
                FlowExpressions.MethodCall boxedParam = new FlowExpressions.MethodCall(formalType, valueOfMethod, new FlowExpressions.ClassName(formalType), p);
                parameters.set(i, boxedParam);
            }
        }
        catch (Throwable t) {
            throw FlowExpressionParseUtil.constructParserException(s2, t);
        }
        assert (methodElement != null);
        if (ElementUtils.isStatic(methodElement)) {
            Element classElem = methodElement.getEnclosingElement();
            FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
            return new FlowExpressions.MethodCall(ElementUtils.getType(methodElement), methodElement, staticClassReceiver, parameters);
        }
        if (context.receiver instanceof FlowExpressions.ClassName) {
            throw FlowExpressionParseUtil.constructParserException(s2, "a non-static method call cannot have a class name as a receiver.");
        }
        TypeMirror methodType = InternalUtils.substituteMethodReturnType(ElementUtils.getType(methodElement), context.receiver.getType());
        return new FlowExpressions.MethodCall(methodType, methodElement, context.receiver, parameters);
    }

    private static boolean isArray(String s2, FlowExpressionContext context) {
        Matcher arraymatcher = arrayPattern.matcher(s2);
        return arraymatcher.matches();
    }

    private static FlowExpressions.Receiver parseArray(String s2, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        Matcher arraymatcher = arrayPattern.matcher(s2);
        if (!arraymatcher.matches()) {
            return null;
        }
        String receiverStr = arraymatcher.group(1);
        String indexStr = arraymatcher.group(2);
        FlowExpressions.Receiver receiver = FlowExpressionParseUtil.parseHelper(receiverStr, context, path);
        FlowExpressionContext contextForIndex = context.copyAndUseOuterReceiver();
        FlowExpressions.Receiver index = FlowExpressionParseUtil.parseHelper(indexStr, contextForIndex, path);
        TypeMirror receiverType = receiver.getType();
        if (!(receiverType instanceof Type.ArrayType)) {
            throw FlowExpressionParseUtil.constructParserException(s2, String.format("receiver not an array: %s : %s", receiver, receiverType));
        }
        Type componentType = ((Type.ArrayType)receiverType).getComponentType();
        FlowExpressions.ArrayAccess result = new FlowExpressions.ArrayAccess(componentType, receiver, index);
        return result;
    }

    private static boolean isParentheses(String s2, FlowExpressionContext contex) {
        Matcher parenthesesMatcher = parenthesesPattern.matcher(s2);
        return parenthesesMatcher.matches();
    }

    private static FlowExpressions.Receiver parseParentheses(String s2, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        Matcher parenthesesMatcher = parenthesesPattern.matcher(s2);
        if (!parenthesesMatcher.matches()) {
            return null;
        }
        String expressionString = parenthesesMatcher.group(1);
        return FlowExpressionParseUtil.parseHelper(expressionString, context, path);
    }

    private static Pair<FlowExpressions.ClassName, String> matchPackageAndClassNameWithinExpression(String expression, Resolver resolver, TreePath path) throws FlowExpressionParseException {
        Symbol.ClassSymbol classSymbol;
        String remainingString;
        String classNameString;
        Pair<Symbol.PackageSymbol, String> packageSymbolAndRemainingString = FlowExpressionParseUtil.matchPackageNameWithinExpression(expression, resolver, path);
        if (packageSymbolAndRemainingString == null) {
            return null;
        }
        Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)packageSymbolAndRemainingString.first;
        String packageRemainingString = (String)packageSymbolAndRemainingString.second;
        Matcher dotMatcher = memberselect.matcher(packageRemainingString);
        if (dotMatcher.matches()) {
            classNameString = dotMatcher.group(1);
            remainingString = dotMatcher.group(2);
        } else {
            classNameString = packageRemainingString;
            remainingString = null;
        }
        try {
            classSymbol = resolver.findClassInPackage(classNameString, packageSymbol, path);
        }
        catch (Throwable t) {
            throw FlowExpressionParseUtil.constructParserException(expression, " findClassInPackage threw an exception when looking up class " + classNameString + " in package " + packageSymbol.toString(), t);
        }
        if (classSymbol == null) {
            throw FlowExpressionParseUtil.constructParserException(expression, "classSymbol==null when looking up class " + classNameString + " in package " + packageSymbol.toString());
        }
        TypeMirror classType = ElementUtils.getType(classSymbol);
        if (classType == null) {
            throw FlowExpressionParseUtil.constructParserException(expression, "classType==null when looking for class symbol " + classSymbol);
        }
        return Pair.of(new FlowExpressions.ClassName(classType), remainingString);
    }

    private static Pair<Symbol.PackageSymbol, String> matchPackageNameWithinExpression(String expression, Resolver resolver, TreePath path) throws FlowExpressionParseException {
        Symbol.PackageSymbol result;
        String remainingString;
        block9: {
            Symbol.PackageSymbol wholeExpressionAsPackage;
            Matcher dotMatcher = memberselect.matcher(expression);
            if (!dotMatcher.matches()) {
                return null;
            }
            String packageName = dotMatcher.group(1);
            String remainingStringIfPackageMatched = remainingString = dotMatcher.group(2);
            result = null;
            while (true) {
                Symbol.PackageSymbol longerResult;
                try {
                    longerResult = resolver.findPackage(packageName, path);
                }
                catch (Throwable t) {
                    throw FlowExpressionParseUtil.constructParserException(expression, "findPackage threw an exception when looking up package " + packageName, t);
                }
                if (longerResult == null) break block9;
                result = longerResult;
                remainingString = remainingStringIfPackageMatched;
                dotMatcher = memberselect.matcher(remainingString);
                if (!dotMatcher.matches()) break;
                packageName = packageName + "." + dotMatcher.group(1);
                remainingStringIfPackageMatched = dotMatcher.group(2);
            }
            try {
                wholeExpressionAsPackage = resolver.findPackage(expression, path);
            }
            catch (Throwable t) {
                throw FlowExpressionParseUtil.constructParserException(expression, "findPackage threw an exception when looking up package " + expression, t);
            }
            if (wholeExpressionAsPackage != null) {
                throw FlowExpressionParseUtil.constructParserException(expression, "a flow expression string cannot be just a package name");
            }
        }
        if (result == null) {
            return null;
        }
        assert (remainingString != null);
        return Pair.of(result, remainingString);
    }

    public static List<Integer> parameterIndices(String s2) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = unanchoredParameterPattern.matcher(s2);
        while (matcher.find()) {
            int idx = Integer.parseInt(matcher.group(1));
            result.add(idx);
        }
        return result;
    }

    private static TypeMirror getTypeOfEnclosingClass(DeclaredType type) {
        if (type instanceof Type.ClassType) {
            Symbol sym = ((Type.ClassType)type).tsym.owner;
            if (sym == null) {
                return Type.noType;
            }
            Symbol.ClassSymbol cs = sym.enclClass();
            if (cs == null) {
                return Type.noType;
            }
            return cs.asType();
        }
        return type.getEnclosingType();
    }

    private static FlowExpressionParseException constructParserException(String expr, String explanation) {
        return FlowExpressionParseUtil.constructParserException(expr, explanation, null);
    }

    private static FlowExpressionParseException constructParserException(String expr, Throwable cause) {
        return FlowExpressionParseUtil.constructParserException(expr, null, cause);
    }

    private static FlowExpressionParseException constructParserException(String expr, String explanation, Throwable cause) {
        String message = expr + (explanation == null ? "" : ": " + explanation) + (cause == null ? "" : ": " + cause.getMessage());
        return new FlowExpressionParseException(Result.failure("flowexpr.parse.error", message), cause);
    }

    public static class FlowExpressionParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        protected final Result result;

        public FlowExpressionParseException(Result result) {
            this(result, null);
        }

        public FlowExpressionParseException(Result result, Throwable cause) {
            super(cause);
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }
    }

    public static class FlowExpressionContext {
        public final FlowExpressions.Receiver receiver;
        public final List<FlowExpressions.Receiver> arguments;
        public final FlowExpressions.Receiver outerReceiver;
        public final BaseContext checkerContext;
        public final boolean parsingMember;
        public boolean useLocalScope;

        public FlowExpressionContext(FlowExpressions.Receiver receiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext) {
            this(receiver, receiver, arguments, checkerContext);
        }

        private FlowExpressionContext(FlowExpressions.Receiver receiver, FlowExpressions.Receiver outerReceiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext) {
            this(receiver, outerReceiver, arguments, checkerContext, false, true);
        }

        private FlowExpressionContext(FlowExpressions.Receiver receiver, FlowExpressions.Receiver outerReceiver, List<FlowExpressions.Receiver> arguments, BaseContext checkerContext, boolean parsingMember, boolean useLocalScope) {
            assert (checkerContext != null);
            this.receiver = receiver;
            this.arguments = arguments;
            this.outerReceiver = outerReceiver;
            this.checkerContext = checkerContext;
            this.parsingMember = parsingMember;
            this.useLocalScope = useLocalScope;
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, Tree enclosingTree, BaseContext checkerContext) {
            return FlowExpressionContext.buildContextForMethodDeclaration(methodDeclaration, InternalUtils.typeOf(enclosingTree), checkerContext);
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, TypeMirror enclosingType, BaseContext checkerContext) {
            Node receiver;
            if (methodDeclaration.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                TypeElement classElt = ElementUtils.enclosingClass(TreeUtils.elementFromDeclaration(methodDeclaration));
                receiver = new ClassNameNode(enclosingType, classElt);
            } else {
                receiver = new ImplicitThisLiteralNode(enclosingType);
            }
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (VariableTree variableTree : methodDeclaration.getParameters()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), new LocalVariableNode(variableTree, receiver)));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForLambda(LambdaExpressionTree lambdaTree, TreePath path, BaseContext checkerContext) {
            TypeMirror enclosingType = InternalUtils.typeOf(TreeUtils.enclosingClass(path));
            ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(enclosingType);
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (VariableTree variableTree : lambdaTree.getParameters()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), new LocalVariableNode(variableTree, receiver)));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodDeclaration(MethodTree methodDeclaration, TreePath currentPath, BaseContext checkerContext) {
            ClassTree classTree = TreeUtils.enclosingClass(currentPath);
            return FlowExpressionContext.buildContextForMethodDeclaration(methodDeclaration, classTree, checkerContext);
        }

        public static FlowExpressionContext buildContextForClassDeclaration(ClassTree classTree, BaseContext checkerContext) {
            ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(InternalUtils.typeOf(classTree));
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForMethodUse(MethodInvocationNode methodInvocation, BaseContext checkerContext) {
            Node receiver = methodInvocation.getTarget().getReceiver();
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), receiver);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (Node arg : methodInvocation.getArguments()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), arg));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public static FlowExpressionContext buildContextForNewClassUse(ObjectCreationNode n, BaseContext checkerContext) {
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), n);
            ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
            for (Node arg : n.getArguments()) {
                internalArguments.add(FlowExpressions.internalReprOf(checkerContext.getAnnotationProvider(), arg));
            }
            FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, checkerContext);
            return flowExprContext;
        }

        public FlowExpressionContext copyChangeToParsingMemberOfReceiver(FlowExpressions.Receiver receiver) {
            return new FlowExpressionContext(receiver, this.outerReceiver, this.arguments, this.checkerContext, true, this.useLocalScope);
        }

        public FlowExpressionContext copyAndUseOuterReceiver() {
            return new FlowExpressionContext(this.outerReceiver, this.outerReceiver, this.arguments, this.checkerContext, false, this.useLocalScope);
        }
    }

    private static class ParameterListParser {
        private ParameterListParser() {
        }

        private static List<FlowExpressions.Receiver> parseParameterList(String parameterString, boolean allowEmptyList, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
            ArrayList<FlowExpressions.Receiver> result = new ArrayList<FlowExpressions.Receiver>();
            int idx = 0;
            int callLevel = 0;
            boolean inString = false;
            block6: while (true) {
                if (idx == parameterString.length()) {
                    if (inString) {
                        throw FlowExpressionParseUtil.constructParserException(parameterString, "unterminated string");
                    }
                    if (callLevel > 0) {
                        throw FlowExpressionParseUtil.constructParserException(parameterString, "unterminated method invocation, callLevel==" + callLevel);
                    }
                    ParameterListParser.finishParam(parameterString, allowEmptyList, context, path, result, idx);
                    return result;
                }
                char next = parameterString.charAt(idx);
                ++idx;
                switch (next) {
                    case ',': {
                        if (inString || callLevel != 0) continue block6;
                        ParameterListParser.finishParam(parameterString, allowEmptyList, context, path, result, idx - 1);
                        List<FlowExpressions.Receiver> rest = ParameterListParser.parseParameterList(parameterString.substring(idx), false, context, path);
                        result.addAll(rest);
                        return result;
                    }
                    case '\"': {
                        inString = !inString;
                        break;
                    }
                    case '(': {
                        if (inString) continue block6;
                        ++callLevel;
                        break;
                    }
                    case ')': {
                        if (inString) continue block6;
                        if (callLevel == 0) {
                            throw FlowExpressionParseUtil.constructParserException(parameterString, "callLevel==0");
                        }
                        --callLevel;
                        break;
                    }
                }
            }
        }

        private static void finishParam(String parameterString, boolean allowEmptyList, FlowExpressionContext context, TreePath path, ArrayList<FlowExpressions.Receiver> result, int idx) throws FlowExpressionParseException {
            if (idx == 0) {
                if (allowEmptyList) {
                    return;
                }
                throw FlowExpressionParseUtil.constructParserException(parameterString, "empty parameter list; idx==0");
            }
            result.add(FlowExpressionParseUtil.parseHelper(parameterString.substring(0, idx), context, path));
        }
    }
}

