/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeVisitor;

public class AnnotatedTypeCopier
implements AnnotatedTypeVisitor<AnnotatedTypeMirror, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>> {
    protected boolean visitingExecutableTypeParam = false;
    protected final boolean copyAnnotations;

    public AnnotatedTypeCopier(boolean copyAnnotations) {
        this.copyAnnotations = copyAnnotations;
    }

    public AnnotatedTypeCopier() {
        this(true);
    }

    @Override
    public AnnotatedTypeMirror visit(AnnotatedTypeMirror type) {
        return type.accept(this, new IdentityHashMap());
    }

    @Override
    public AnnotatedTypeMirror visit(AnnotatedTypeMirror type, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        return type.accept(this, originalToCopy);
    }

    @Override
    public AnnotatedTypeMirror visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return originalToCopy.get(original);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType copy = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        this.maybeCopyPrimaryAnnotations(original, copy);
        originalToCopy.put(original, copy);
        if (original.wasRaw()) {
            copy.setWasRaw();
        }
        if (copy.enclosingType != null) {
            copy.enclosingType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.visit((AnnotatedTypeMirror)original.enclosingType, originalToCopy);
        }
        if (original.typeArgs != null) {
            ArrayList<AnnotatedTypeMirror> copyTypeArgs = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror typeArg : original.getTypeArguments()) {
                copyTypeArgs.add(this.visit(typeArg, originalToCopy));
            }
            copy.setTypeArguments(copyTypeArgs);
        }
        if (original.supertypes != null) {
            ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> copySupertypes = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : original.supertypes) {
                copySupertypes.add((AnnotatedTypeMirror.AnnotatedDeclaredType)this.visit((AnnotatedTypeMirror)supertype, originalToCopy));
            }
            copy.supertypes = Collections.unmodifiableList(copySupertypes);
        }
        return copy;
    }

    @Override
    public AnnotatedTypeMirror visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return originalToCopy.get(original);
        }
        AnnotatedTypeMirror.AnnotatedIntersectionType copy = (AnnotatedTypeMirror.AnnotatedIntersectionType)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        this.maybeCopyPrimaryAnnotations(original, copy);
        originalToCopy.put(original, copy);
        if (original.supertypes != null) {
            ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> copySupertypes = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : original.supertypes) {
                copySupertypes.add((AnnotatedTypeMirror.AnnotatedDeclaredType)this.visit((AnnotatedTypeMirror)supertype, originalToCopy));
            }
            copy.supertypes = Collections.unmodifiableList(copySupertypes);
        }
        return copy;
    }

    @Override
    public AnnotatedTypeMirror visitUnion(AnnotatedTypeMirror.AnnotatedUnionType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return originalToCopy.get(original);
        }
        AnnotatedTypeMirror.AnnotatedUnionType copy = (AnnotatedTypeMirror.AnnotatedUnionType)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        this.maybeCopyPrimaryAnnotations(original, copy);
        originalToCopy.put(original, copy);
        if (original.alternatives != null) {
            ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> copyAlternatives = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : original.alternatives) {
                copyAlternatives.add((AnnotatedTypeMirror.AnnotatedDeclaredType)this.visit((AnnotatedTypeMirror)supertype, originalToCopy));
            }
            copy.alternatives = Collections.unmodifiableList(copyAlternatives);
        }
        return copy;
    }

    @Override
    public AnnotatedTypeMirror visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return originalToCopy.get(original);
        }
        AnnotatedTypeMirror.AnnotatedExecutableType copy = (AnnotatedTypeMirror.AnnotatedExecutableType)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        this.maybeCopyPrimaryAnnotations(original, copy);
        originalToCopy.put(original, copy);
        copy.setElement(original.getElement());
        if (original.receiverType != null) {
            copy.receiverType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.visit((AnnotatedTypeMirror)original.receiverType, originalToCopy);
        }
        for (AnnotatedTypeMirror param : original.paramTypes) {
            copy.paramTypes.add(this.visit(param, originalToCopy));
        }
        for (AnnotatedTypeMirror thrown : original.throwsTypes) {
            copy.throwsTypes.add(this.visit(thrown, originalToCopy));
        }
        copy.returnType = this.visit(original.returnType, originalToCopy);
        for (AnnotatedTypeMirror.AnnotatedTypeVariable typeVariable : original.typeVarTypes) {
            this.visitingExecutableTypeParam = true;
            copy.typeVarTypes.add((AnnotatedTypeMirror.AnnotatedTypeVariable)this.visit((AnnotatedTypeMirror)typeVariable, originalToCopy));
        }
        this.visitingExecutableTypeParam = false;
        return copy;
    }

    @Override
    public AnnotatedTypeMirror visitArray(AnnotatedTypeMirror.AnnotatedArrayType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return originalToCopy.get(original);
        }
        AnnotatedTypeMirror.AnnotatedArrayType copy = (AnnotatedTypeMirror.AnnotatedArrayType)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        this.maybeCopyPrimaryAnnotations(original, copy);
        originalToCopy.put(original, copy);
        copy.setComponentType(this.visit(original.getComponentType(), originalToCopy));
        return copy;
    }

    @Override
    public AnnotatedTypeMirror visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return originalToCopy.get(original);
        }
        AnnotatedTypeMirror.AnnotatedTypeVariable copy = (AnnotatedTypeMirror.AnnotatedTypeVariable)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        this.maybeCopyPrimaryAnnotations(original, copy);
        originalToCopy.put(original, copy);
        if (original.getUpperBoundField() != null) {
            copy.setUpperBoundField(this.visit(original.getUpperBoundField(), originalToCopy));
        }
        if (original.getLowerBoundField() != null) {
            copy.setLowerBoundField(this.visit(original.getLowerBoundField(), originalToCopy));
        }
        return copy;
    }

    @Override
    public AnnotatedTypeMirror visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        return this.makeCopy(original);
    }

    @Override
    public AnnotatedTypeMirror visitNoType(AnnotatedTypeMirror.AnnotatedNoType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        return this.makeCopy(original);
    }

    @Override
    public AnnotatedTypeMirror visitNull(AnnotatedTypeMirror.AnnotatedNullType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        return this.makeOrReturnCopy(original, originalToCopy);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return originalToCopy.get(original);
        }
        AnnotatedTypeMirror.AnnotatedWildcardType copy = (AnnotatedTypeMirror.AnnotatedWildcardType)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        if (original.isUninferredTypeArgument()) {
            copy.setUninferredTypeArgument();
        }
        this.maybeCopyPrimaryAnnotations(original, copy);
        originalToCopy.put(original, copy);
        if (original.getExtendsBoundField() != null) {
            copy.setExtendsBound(this.visit(original.getExtendsBoundField(), originalToCopy));
        }
        if (original.getSuperBoundField() != null) {
            copy.setSuperBound(this.visit(original.getSuperBoundField(), originalToCopy));
        }
        return copy;
    }

    protected <T extends AnnotatedTypeMirror> T makeOrReturnCopy(T original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
        if (originalToCopy.containsKey(original)) {
            return (T)originalToCopy.get(original);
        }
        T copy = this.makeCopy(original);
        originalToCopy.put(original, copy);
        return copy;
    }

    protected <T extends AnnotatedTypeMirror> T makeCopy(T original) {
        AnnotatedTypeMirror copy = AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
        this.maybeCopyPrimaryAnnotations(original, copy);
        return (T)copy;
    }

    protected void maybeCopyPrimaryAnnotations(AnnotatedTypeMirror source, AnnotatedTypeMirror dest) {
        if (this.copyAnnotations) {
            dest.addAnnotations(source.getAnnotationsField());
        }
    }
}

