/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.util.PluginUtil;

public class ImmutableTestConfiguration
implements TestConfiguration {
    private final Map<String, String> options;
    private final List<File> diagnosticFiles;
    private final List<File> testSourceFiles;
    private final List<String> processors;
    private final boolean shouldEmitDebugInfo;

    public ImmutableTestConfiguration(List<File> diagnosticFiles, List<File> testSourceFiles, List<String> processors, Map<String, String> options, boolean shouldEmitDebugInfo) {
        this.diagnosticFiles = Collections.unmodifiableList(diagnosticFiles);
        this.testSourceFiles = Collections.unmodifiableList(new ArrayList<File>(testSourceFiles));
        this.processors = Collections.unmodifiableList(new ArrayList<String>(processors));
        this.options = Collections.unmodifiableMap(new LinkedHashMap<String, String>(options));
        this.shouldEmitDebugInfo = shouldEmitDebugInfo;
    }

    @Override
    public List<File> getTestSourceFiles() {
        return this.testSourceFiles;
    }

    @Override
    public List<File> getDiagnosticFiles() {
        return this.diagnosticFiles;
    }

    @Override
    public List<String> getProcessors() {
        return this.processors;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public List<String> getFlatOptions() {
        return TestUtilities.optionMapToList(this.options);
    }

    @Override
    public boolean shouldEmitDebugInfo() {
        return this.shouldEmitDebugInfo;
    }

    public String toString() {
        return "TestConfigurationBuilder:\ntestSourceFiles=" + (this.testSourceFiles == null ? "null" : PluginUtil.join(" ", this.testSourceFiles)) + "\nprocessors=" + (this.processors == null ? "null" : PluginUtil.join(", ", this.processors)) + "\noptions=" + (this.options == null ? "null" : PluginUtil.join(", ", this.getFlatOptions())) + "\nshouldEmitDebugInfo=" + this.shouldEmitDebugInfo;
    }
}

