/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class PurityChecker {
    public static PurityResult checkPurity(Tree statement, AnnotationProvider annoProvider, boolean assumeSideEffectFree) {
        PurityCheckerHelper helper = new PurityCheckerHelper(annoProvider, assumeSideEffectFree);
        PurityResult res = helper.scan(statement, new PurityResult());
        return res;
    }

    protected static class PurityCheckerHelper
    extends SimpleTreeVisitor<PurityResult, PurityResult> {
        protected final AnnotationProvider annoProvider;
        private final boolean assumeSideEffectFree;
        protected @Nullable List<Element> methodParameter;

        public PurityCheckerHelper(AnnotationProvider annoProvider, boolean assumeSideEffectFree) {
            this.annoProvider = annoProvider;
            this.assumeSideEffectFree = assumeSideEffectFree;
        }

        public PurityResult scan(Tree node, PurityResult p) {
            return node == null ? p : node.accept(this, p);
        }

        public PurityResult scan(Iterable<? extends Tree> nodes, PurityResult p) {
            PurityResult r = p;
            if (nodes != null) {
                for (Tree tree : nodes) {
                    r = this.scan(tree, r);
                }
            }
            return r;
        }

        @Override
        protected PurityResult defaultAction(Tree node, PurityResult p) {
            assert (false) : "this type of tree is unexpected here";
            return null;
        }

        @Override
        public PurityResult visitClass(ClassTree node, PurityResult p) {
            return p;
        }

        @Override
        public PurityResult visitVariable(VariableTree node, PurityResult p) {
            return this.scan(node.getInitializer(), p);
        }

        @Override
        public PurityResult visitEmptyStatement(EmptyStatementTree node, PurityResult p) {
            return p;
        }

        @Override
        public PurityResult visitBlock(BlockTree node, PurityResult p) {
            return this.scan(node.getStatements(), p);
        }

        @Override
        public PurityResult visitDoWhileLoop(DoWhileLoopTree node, PurityResult p) {
            PurityResult r = this.scan(node.getStatement(), p);
            r = this.scan(node.getCondition(), r);
            return r;
        }

        @Override
        public PurityResult visitWhileLoop(WhileLoopTree node, PurityResult p) {
            PurityResult r = this.scan(node.getCondition(), p);
            r = this.scan(node.getStatement(), r);
            return r;
        }

        @Override
        public PurityResult visitForLoop(ForLoopTree node, PurityResult p) {
            PurityResult r = this.scan(node.getInitializer(), p);
            r = this.scan(node.getCondition(), r);
            r = this.scan(node.getUpdate(), r);
            r = this.scan(node.getStatement(), r);
            return r;
        }

        @Override
        public PurityResult visitEnhancedForLoop(EnhancedForLoopTree node, PurityResult p) {
            PurityResult r = this.scan(node.getVariable(), p);
            r = this.scan(node.getExpression(), r);
            r = this.scan(node.getStatement(), r);
            return r;
        }

        @Override
        public PurityResult visitLabeledStatement(LabeledStatementTree node, PurityResult p) {
            return this.scan(node.getStatement(), p);
        }

        @Override
        public PurityResult visitSwitch(SwitchTree node, PurityResult p) {
            PurityResult r = this.scan(node.getExpression(), p);
            r = this.scan(node.getCases(), r);
            return r;
        }

        @Override
        public PurityResult visitCase(CaseTree node, PurityResult p) {
            PurityResult r = this.scan(node.getExpression(), p);
            r = this.scan(node.getStatements(), r);
            return r;
        }

        @Override
        public PurityResult visitSynchronized(SynchronizedTree node, PurityResult p) {
            PurityResult r = this.scan(node.getExpression(), p);
            r = this.scan(node.getBlock(), r);
            return r;
        }

        @Override
        public PurityResult visitTry(TryTree node, PurityResult p) {
            PurityResult r = this.scan(node.getResources(), p);
            r = this.scan(node.getBlock(), r);
            r = this.scan(node.getCatches(), r);
            r = this.scan(node.getFinallyBlock(), r);
            return r;
        }

        @Override
        public PurityResult visitCatch(CatchTree node, PurityResult p) {
            p.addNotDetReason(node, "catch");
            PurityResult r = this.scan(node.getParameter(), p);
            r = this.scan(node.getBlock(), r);
            return r;
        }

        @Override
        public PurityResult visitConditionalExpression(ConditionalExpressionTree node, PurityResult p) {
            PurityResult r = this.scan(node.getCondition(), p);
            r = this.scan(node.getTrueExpression(), r);
            r = this.scan(node.getFalseExpression(), r);
            return r;
        }

        @Override
        public PurityResult visitIf(IfTree node, PurityResult p) {
            PurityResult r = this.scan(node.getCondition(), p);
            r = this.scan(node.getThenStatement(), r);
            r = this.scan(node.getElseStatement(), r);
            return r;
        }

        @Override
        public PurityResult visitExpressionStatement(ExpressionStatementTree node, PurityResult p) {
            return this.scan(node.getExpression(), p);
        }

        @Override
        public PurityResult visitBreak(BreakTree node, PurityResult p) {
            return p;
        }

        @Override
        public PurityResult visitContinue(ContinueTree node, PurityResult p) {
            return p;
        }

        @Override
        public PurityResult visitReturn(ReturnTree node, PurityResult p) {
            return this.scan(node.getExpression(), p);
        }

        @Override
        public PurityResult visitThrow(ThrowTree node, PurityResult p) {
            return this.scan(node.getExpression(), p);
        }

        @Override
        public PurityResult visitAssert(AssertTree node, PurityResult p) {
            PurityResult r = this.scan(node.getCondition(), p);
            r = this.scan(node.getDetail(), r);
            return r;
        }

        @Override
        public PurityResult visitMethodInvocation(MethodInvocationTree node, PurityResult p) {
            ExecutableElement elt = TreeUtils.elementFromUse(node);
            String reason = "call";
            if (!PurityUtils.hasPurityAnnotation(this.annoProvider, elt)) {
                p.addNotBothReason(node, reason);
            } else {
                boolean seFree;
                boolean det = PurityUtils.isDeterministic(this.annoProvider, elt);
                boolean bl = seFree = this.assumeSideEffectFree || PurityUtils.isSideEffectFree(this.annoProvider, elt);
                if (!det && !seFree) {
                    p.addNotBothReason(node, reason);
                } else if (!det) {
                    p.addNotDetReason(node, reason);
                } else if (!seFree) {
                    p.addNotSeFreeReason(node, reason);
                }
            }
            PurityResult r = this.scan(node.getMethodSelect(), p);
            r = this.scan(node.getArguments(), r);
            return r;
        }

        @Override
        public PurityResult visitNewClass(NewClassTree node, PurityResult p) {
            boolean sideEffectFree;
            Element methodElement = InternalUtils.symbol(node);
            boolean bl = sideEffectFree = this.assumeSideEffectFree || PurityUtils.isSideEffectFree(this.annoProvider, methodElement);
            if (sideEffectFree) {
                p.addNotDetReason(node, "object.creation");
            } else {
                p.addNotBothReason(node, "object.creation");
            }
            PurityResult r = this.scan(node.getEnclosingExpression(), p);
            r = this.scan(node.getArguments(), r);
            r = this.scan(node.getClassBody(), r);
            return r;
        }

        @Override
        public PurityResult visitNewArray(NewArrayTree node, PurityResult p) {
            PurityResult r = this.scan(node.getDimensions(), p);
            r = this.scan(node.getInitializers(), r);
            return r;
        }

        @Override
        public PurityResult visitLambdaExpression(LambdaExpressionTree node, PurityResult p) {
            PurityResult r = this.scan(node.getParameters(), p);
            r = this.scan(node.getBody(), r);
            return r;
        }

        @Override
        public PurityResult visitParenthesized(ParenthesizedTree node, PurityResult p) {
            return this.scan(node.getExpression(), p);
        }

        @Override
        public PurityResult visitAssignment(AssignmentTree node, PurityResult p) {
            ExpressionTree variable = node.getVariable();
            p = this.assignmentCheck(p, variable);
            PurityResult r = this.scan(variable, p);
            r = this.scan(node.getExpression(), r);
            return r;
        }

        protected PurityResult assignmentCheck(PurityResult p, ExpressionTree variable) {
            if (TreeUtils.isFieldAccess(variable)) {
                p.addNotBothReason(variable, "assign.field");
            } else if (variable instanceof ArrayAccessTree) {
                p.addNotBothReason(variable, "assign.array");
            } else assert (this.isLocalVariable(variable));
            return p;
        }

        protected boolean isLocalVariable(ExpressionTree variable) {
            return variable instanceof IdentifierTree && !TreeUtils.isFieldAccess(variable);
        }

        @Override
        public PurityResult visitCompoundAssignment(CompoundAssignmentTree node, PurityResult p) {
            ExpressionTree variable = node.getVariable();
            p = this.assignmentCheck(p, variable);
            PurityResult r = this.scan(variable, p);
            r = this.scan(node.getExpression(), r);
            return r;
        }

        @Override
        public PurityResult visitUnary(UnaryTree node, PurityResult p) {
            return this.scan(node.getExpression(), p);
        }

        @Override
        public PurityResult visitBinary(BinaryTree node, PurityResult p) {
            PurityResult r = this.scan(node.getLeftOperand(), p);
            r = this.scan(node.getRightOperand(), r);
            return r;
        }

        @Override
        public PurityResult visitTypeCast(TypeCastTree node, PurityResult p) {
            PurityResult r = this.scan(node.getExpression(), p);
            return r;
        }

        @Override
        public PurityResult visitInstanceOf(InstanceOfTree node, PurityResult p) {
            PurityResult r = this.scan(node.getExpression(), p);
            return r;
        }

        @Override
        public PurityResult visitArrayAccess(ArrayAccessTree node, PurityResult p) {
            PurityResult r = this.scan(node.getExpression(), p);
            r = this.scan(node.getIndex(), r);
            return r;
        }

        @Override
        public PurityResult visitMemberSelect(MemberSelectTree node, PurityResult p) {
            return this.scan(node.getExpression(), p);
        }

        @Override
        public PurityResult visitMemberReference(MemberReferenceTree node, PurityResult p) {
            assert (false) : "this type of tree is unexpected here";
            return null;
        }

        @Override
        public PurityResult visitIdentifier(IdentifierTree node, PurityResult p) {
            return p;
        }

        @Override
        public PurityResult visitLiteral(LiteralTree node, PurityResult p) {
            return p;
        }
    }

    public static class PurityResult {
        protected final List<Pair<Tree, String>> notSeFreeReasons = new ArrayList<Pair<Tree, String>>();
        protected final List<Pair<Tree, String>> notDetReasons = new ArrayList<Pair<Tree, String>>();
        protected final List<Pair<Tree, String>> notBothReasons = new ArrayList<Pair<Tree, String>>();
        protected EnumSet<Pure.Kind> types = EnumSet.allOf(Pure.Kind.class);

        public EnumSet<Pure.Kind> getTypes() {
            return this.types;
        }

        public boolean isPure(Collection<Pure.Kind> kinds) {
            return this.types.containsAll(kinds);
        }

        public List<Pair<Tree, String>> getNotSeFreeReasons() {
            return this.notSeFreeReasons;
        }

        public void addNotSeFreeReason(Tree t, String msgId) {
            this.notSeFreeReasons.add(Pair.of(t, msgId));
            this.types.remove((Object)Pure.Kind.SIDE_EFFECT_FREE);
        }

        public List<Pair<Tree, String>> getNotDetReasons() {
            return this.notDetReasons;
        }

        public void addNotDetReason(Tree t, String msgId) {
            this.notDetReasons.add(Pair.of(t, msgId));
            this.types.remove((Object)Pure.Kind.DETERMINISTIC);
        }

        public List<Pair<Tree, String>> getNotBothReasons() {
            return this.notBothReasons;
        }

        public void addNotBothReason(Tree t, String msgId) {
            this.notBothReasons.add(Pair.of(t, msgId));
            this.types.remove((Object)Pure.Kind.DETERMINISTIC);
            this.types.remove((Object)Pure.Kind.SIDE_EFFECT_FREE);
        }
    }
}

