/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.initialization;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.initialization.InitializationChecker;
import org.checkerframework.checker.initialization.InitializationStore;
import org.checkerframework.checker.initialization.InitializationTransfer;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Raw;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.qual.Unused;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public abstract class InitializationAnnotatedTypeFactory<Value extends CFAbstractValue<Value>, Store extends InitializationStore<Value, Store>, Transfer extends InitializationTransfer<Value, Transfer, Store>, Flow extends CFAbstractAnalysis<Value, Store, Transfer>>
extends GenericAnnotatedTypeFactory<Value, Store, Transfer, Flow> {
    protected final AnnotationMirror UNCLASSIFIED;
    protected final AnnotationMirror COMMITTED;
    protected final AnnotationMirror FREE;
    protected final AnnotationMirror NOT_ONLY_COMMITTED;
    protected final AnnotationMirror FBCBOTTOM;
    protected final boolean useFbc;
    protected final Set<Class<? extends Annotation>> initAnnos;
    private boolean computingAnnotatedTypeMirrorOfLHS = false;

    public InitializationAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFbc) {
        super(checker, true);
        this.useFbc = useFbc;
        LinkedHashSet<Class> tempInitAnnos = new LinkedHashSet<Class>();
        if (useFbc) {
            this.COMMITTED = AnnotationUtils.fromClass(this.elements, Initialized.class);
            this.FREE = AnnotationUtils.fromClass(this.elements, UnderInitialization.class);
            this.NOT_ONLY_COMMITTED = AnnotationUtils.fromClass(this.elements, NotOnlyInitialized.class);
            this.FBCBOTTOM = AnnotationUtils.fromClass(this.elements, FBCBottom.class);
            this.UNCLASSIFIED = AnnotationUtils.fromClass(this.elements, UnknownInitialization.class);
            tempInitAnnos.add(UnderInitialization.class);
            tempInitAnnos.add(Initialized.class);
            tempInitAnnos.add(UnknownInitialization.class);
            tempInitAnnos.add(FBCBottom.class);
        } else {
            this.FBCBOTTOM = this.COMMITTED = AnnotationUtils.fromClass(this.elements, NonRaw.class);
            this.UNCLASSIFIED = AnnotationUtils.fromClass(this.elements, Raw.class);
            this.FREE = null;
            this.NOT_ONLY_COMMITTED = null;
            tempInitAnnos.add(Raw.class);
            tempInitAnnos.add(NonRaw.class);
        }
        this.initAnnos = Collections.unmodifiableSet(tempInitAnnos);
    }

    public Set<Class<? extends Annotation>> getInitializationAnnotations() {
        return this.initAnnos;
    }

    protected boolean isInitializationAnnotation(AnnotationMirror anno) {
        assert (anno != null);
        return AnnotationUtils.areSameIgnoringValues(anno, this.UNCLASSIFIED) || AnnotationUtils.areSameIgnoringValues(anno, this.FREE) || AnnotationUtils.areSameIgnoringValues(anno, this.COMMITTED) || AnnotationUtils.areSameIgnoringValues(anno, this.FBCBOTTOM);
    }

    public Set<Class<? extends Annotation>> getInvalidConstructorReturnTypeAnnotations() {
        return this.getInitializationAnnotations();
    }

    public abstract AnnotationMirror getFieldInvariantAnnotation();

    public AnnotationMirror createFreeAnnotation(TypeMirror typeFrame) {
        assert (typeFrame != null);
        assert (this.useFbc) : "The rawness type system does not have a @UnderInitialization annotation.";
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, UnderInitialization.class);
        builder.setValue((CharSequence)"value", typeFrame);
        return builder.build();
    }

    public AnnotationMirror createFreeAnnotation(Class<?> typeFrame) {
        assert (typeFrame != null);
        assert (this.useFbc) : "The rawness type system does not have a @UnderInitialization annotation.";
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, UnderInitialization.class);
        builder.setValue((CharSequence)"value", typeFrame);
        return builder.build();
    }

    public AnnotationMirror createUnclassifiedAnnotation(Class<?> typeFrame) {
        assert (typeFrame != null);
        Class clazz = this.useFbc ? UnknownInitialization.class : Raw.class;
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, clazz);
        builder.setValue((CharSequence)"value", typeFrame);
        return builder.build();
    }

    public AnnotationMirror createUnclassifiedAnnotation(TypeMirror typeFrame) {
        assert (typeFrame != null);
        Class clazz = this.useFbc ? UnknownInitialization.class : Raw.class;
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, clazz);
        builder.setValue((CharSequence)"value", typeFrame);
        return builder.build();
    }

    public TypeMirror getTypeFrameFromAnnotation(AnnotationMirror annotation) {
        TypeMirror name = AnnotationUtils.getElementValue(annotation, "value", TypeMirror.class, true);
        return name;
    }

    public boolean isFree(AnnotationMirror anno) {
        return this.useFbc && AnnotationUtils.areSameByClass(anno, UnderInitialization.class);
    }

    public boolean isUnclassified(AnnotationMirror anno) {
        Class clazz = this.useFbc ? UnknownInitialization.class : Raw.class;
        return AnnotationUtils.areSameByClass(anno, clazz);
    }

    public boolean isFbcBottom(AnnotationMirror anno) {
        return AnnotationUtils.areSame(anno, this.FBCBOTTOM);
    }

    public boolean isCommitted(AnnotationMirror anno) {
        return AnnotationUtils.areSame(anno, this.COMMITTED);
    }

    public boolean isFree(AnnotatedTypeMirror anno) {
        return this.useFbc && anno.hasEffectiveAnnotation(UnderInitialization.class);
    }

    public boolean isUnclassified(AnnotatedTypeMirror anno) {
        Class clazz = this.useFbc ? UnknownInitialization.class : Raw.class;
        return anno.hasEffectiveAnnotation(clazz);
    }

    public boolean isFbcBottom(AnnotatedTypeMirror anno) {
        Class clazz = this.useFbc ? FBCBottom.class : NonRaw.class;
        return anno.hasEffectiveAnnotation(clazz);
    }

    public boolean isCommitted(AnnotatedTypeMirror anno) {
        Class clazz = this.useFbc ? Initialized.class : NonRaw.class;
        return anno.hasEffectiveAnnotation(clazz);
    }

    @Override
    protected MultiGraphQualifierHierarchy.MultiGraphFactory createQualifierHierarchyFactory() {
        return new MultiGraphQualifierHierarchy.MultiGraphFactory(this);
    }

    protected boolean areAllFieldsCommittedOnly(ClassTree classTree) {
        if (!this.useFbc) {
            return true;
        }
        for (Tree tree : classTree.getMembers()) {
            VariableTree var;
            VariableElement varElt;
            if (!tree.getKind().equals((Object)Tree.Kind.VARIABLE) || this.getDeclAnnotation(varElt = TreeUtils.elementFromDeclaration(var = (VariableTree)tree), NotOnlyInitialized.class) == null || varElt.getModifiers().contains((Object)Modifier.STATIC)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void postAsMemberOf(AnnotatedTypeMirror type, AnnotatedTypeMirror owner, Element element) {
        super.postAsMemberOf(type, owner, element);
        if (element.getKind().isField()) {
            Set<AnnotationMirror> declaredFieldAnnotations = this.getDeclAnnotations(element);
            AnnotatedTypeMirror fieldAnnotations = this.getAnnotatedType(element);
            this.computeFieldAccessType(type, declaredFieldAnnotations, owner, fieldAnnotations, element);
        }
    }

    @Override
    public AnnotatedTypeMirror getAnnotatedTypeLhs(Tree lhsTree) {
        boolean oldComputingAnnotatedTypeMirrorOfLHS = this.computingAnnotatedTypeMirrorOfLHS;
        this.computingAnnotatedTypeMirrorOfLHS = true;
        AnnotatedTypeMirror result = super.getAnnotatedTypeLhs(lhsTree);
        this.computingAnnotatedTypeMirrorOfLHS = oldComputingAnnotatedTypeMirrorOfLHS;
        return result;
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType selfType = super.getSelfType(tree);
        TreePath path = this.getPath(tree);
        Tree topLevelMember = this.findTopLevelClassMemberForTree(path);
        if (topLevelMember != null && (topLevelMember.getKind() != Tree.Kind.METHOD || TreeUtils.isConstructor((MethodTree)topLevelMember))) {
            this.setSelfTypeInInitializationCode(tree, selfType, path);
        }
        return selfType;
    }

    private Tree findTopLevelClassMemberForTree(TreePath path) {
        ClassTree enclosingClass = TreeUtils.enclosingClass(path);
        if (enclosingClass != null) {
            List<? extends Tree> classMembers = enclosingClass.getMembers();
            TreePath searchPath = path;
            while (searchPath.getParentPath() != null && searchPath.getParentPath() != enclosingClass) {
                if (!classMembers.contains((searchPath = searchPath.getParentPath()).getLeaf())) continue;
                return searchPath.getLeaf();
            }
        }
        return null;
    }

    protected void setSelfTypeInInitializationCode(Tree tree, AnnotatedTypeMirror.AnnotatedDeclaredType selfType, TreePath path) {
        List annos;
        InitializationStore store;
        ClassTree enclosingClass = TreeUtils.enclosingClass(path);
        Type classType = ((JCTree)((Object)enclosingClass)).type;
        AnnotationMirror annotation = null;
        if (this.areAllFieldsCommittedOnly(enclosingClass) && (store = (InitializationStore)this.getStoreBefore(tree)) != null && this.getUninitializedInvariantFields(store, path, false, annos = Collections.emptyList()).size() == 0) {
            annotation = this.useFbc ? this.createFreeAnnotation(classType) : this.createUnclassifiedAnnotation(classType);
        }
        if (annotation == null) {
            annotation = this.getFreeOrRawAnnotationOfSuperType(classType);
        }
        selfType.replaceAnnotation(annotation);
    }

    protected AnnotationMirror getFreeOrRawAnnotationOfSuperType(TypeMirror type) {
        List<? extends TypeMirror> superTypes = this.types.directSupertypes(type);
        TypeMirror superClass = null;
        for (TypeMirror typeMirror : superTypes) {
            ElementKind kind = this.types.asElement(typeMirror).getKind();
            if (kind != ElementKind.CLASS) continue;
            superClass = typeMirror;
            break;
        }
        AnnotationMirror annotation = superClass != null ? (this.useFbc ? this.createFreeAnnotation(superClass) : this.createUnclassifiedAnnotation(superClass)) : (this.useFbc ? this.createFreeAnnotation(Object.class) : this.createUnclassifiedAnnotation(Object.class));
        return annotation;
    }

    public List<VariableTree> getUninitializedInvariantFields(Store store, TreePath path, boolean isStatic, List<? extends AnnotationMirror> receiverAnnotations) {
        ClassTree currentClass = TreeUtils.enclosingClass(path);
        List<VariableTree> fields = InitializationChecker.getAllFields(currentClass);
        ArrayList<VariableTree> violatingFields = new ArrayList<VariableTree>();
        AnnotationMirror invariant = this.getFieldInvariantAnnotation();
        for (VariableTree field : fields) {
            VariableElement fieldElem;
            if (this.isUnused(field, receiverAnnotations) || ElementUtils.isStatic(fieldElem = TreeUtils.elementFromDeclaration(field)) != isStatic || !this.getAnnotatedType(field).hasEffectiveAnnotation(invariant) || ((InitializationStore)store).isFieldInitialized(fieldElem)) continue;
            violatingFields.add(field);
        }
        return violatingFields;
    }

    public List<VariableTree> getInitializedInvariantFields(Store store, TreePath path) {
        ClassTree currentClass = TreeUtils.enclosingClass(path);
        List<VariableTree> fields = InitializationChecker.getAllFields(currentClass);
        ArrayList<VariableTree> initializedFields = new ArrayList<VariableTree>();
        AnnotationMirror invariant = this.getFieldInvariantAnnotation();
        for (VariableTree field : fields) {
            VariableElement fieldElem = TreeUtils.elementFromDeclaration(field);
            if (ElementUtils.isStatic(fieldElem) || !this.getAnnotatedType(field).hasEffectiveAnnotation(invariant) || !((InitializationStore)store).isFieldInitialized(fieldElem)) continue;
            initializedFields.add(field);
        }
        return initializedFields;
    }

    private boolean isUnused(VariableTree field, Collection<? extends AnnotationMirror> receiverAnnos) {
        if (receiverAnnos.isEmpty()) {
            return false;
        }
        AnnotationMirror unused = this.getDeclAnnotation(TreeUtils.elementFromDeclaration(field), Unused.class);
        if (unused == null) {
            return false;
        }
        Name when = AnnotationUtils.getElementValueClassName(unused, "when", false);
        for (AnnotationMirror annotationMirror : receiverAnnos) {
            Name annoName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!annoName.contentEquals(when)) continue;
            return true;
        }
        return false;
    }

    public boolean isInitializedForFrame(AnnotatedTypeMirror type, TypeMirror frame) {
        AnnotationMirror initializationAnno = type.getEffectiveAnnotationInHierarchy(this.UNCLASSIFIED);
        TypeMirror typeFrame = this.getTypeFrameFromAnnotation(initializationAnno);
        Types types = this.processingEnv.getTypeUtils();
        return types.isSubtype(typeFrame, frame);
    }

    private void computeFieldAccessType(AnnotatedTypeMirror type, Collection<? extends AnnotationMirror> declaredFieldAnnotations, AnnotatedTypeMirror receiverType, AnnotatedTypeMirror fieldAnnotations, Element element) {
        if (TypesUtils.isPrimitive(type.getUnderlyingType())) {
            return;
        }
        if (AnnotationUtils.containsSameIgnoringValues(fieldAnnotations.getAnnotations(), this.UNCLASSIFIED)) {
            return;
        }
        if (this.isUnclassified(receiverType) || this.isFree(receiverType)) {
            TypeMirror fieldDeclarationType = element.getEnclosingElement().asType();
            boolean isInitializedForFrame = this.isInitializedForFrame(receiverType, fieldDeclarationType);
            if (isInitializedForFrame) {
                type.replaceAnnotation(this.UNCLASSIFIED);
            } else if (this.computingAnnotatedTypeMirrorOfLHS) {
                type.replaceAnnotation(this.UNCLASSIFIED);
            } else {
                type.clearAnnotations();
                type.addAnnotations(this.qualHierarchy.getTopAnnotations());
            }
            if (!AnnotationUtils.containsSame(declaredFieldAnnotations, this.NOT_ONLY_COMMITTED) || !this.useFbc) {
                type.replaceAnnotation(this.COMMITTED);
            }
        }
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new ListTypeAnnotator(super.createTypeAnnotator(), new CommitmentTypeAnnotator(this));
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new CommitmentTreeAnnotator(this));
    }

    protected abstract class InitializationQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public InitializationQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, Object ... arg) {
            super(f, arg);
        }

        public boolean isSubtypeInitialization(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (!InitializationAnnotatedTypeFactory.this.isInitializationAnnotation(rhs) || !InitializationAnnotatedTypeFactory.this.isInitializationAnnotation(lhs)) {
                return false;
            }
            if (AnnotationUtils.areSame(rhs, lhs)) {
                return true;
            }
            if (InitializationAnnotatedTypeFactory.this.isCommitted(lhs)) {
                return InitializationAnnotatedTypeFactory.this.isFbcBottom(rhs);
            }
            if (InitializationAnnotatedTypeFactory.this.isFbcBottom(lhs)) {
                return false;
            }
            if (InitializationAnnotatedTypeFactory.this.isFbcBottom(rhs)) {
                return true;
            }
            boolean unc1 = InitializationAnnotatedTypeFactory.this.isUnclassified(rhs);
            boolean unc2 = InitializationAnnotatedTypeFactory.this.isUnclassified(lhs);
            boolean free1 = InitializationAnnotatedTypeFactory.this.isFree(rhs);
            boolean free2 = InitializationAnnotatedTypeFactory.this.isFree(lhs);
            if (InitializationAnnotatedTypeFactory.this.isCommitted(rhs)) {
                return unc2;
            }
            if (unc1 && free2) {
                return false;
            }
            assert (free1 && free2 || unc1 && unc2 || free1 && unc2);
            TypeMirror frame1 = InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(rhs);
            TypeMirror frame2 = InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(lhs);
            return InitializationAnnotatedTypeFactory.this.types.isSubtype(frame1, frame2);
        }

        protected AnnotationMirror leastUpperBoundInitialization(AnnotationMirror anno1, AnnotationMirror anno2) {
            if (!InitializationAnnotatedTypeFactory.this.isInitializationAnnotation(anno1) || !InitializationAnnotatedTypeFactory.this.isInitializationAnnotation(anno2)) {
                return null;
            }
            if (this.isSubtypeInitialization(anno1, anno2)) {
                return anno2;
            }
            if (this.isSubtypeInitialization(anno2, anno1)) {
                return anno1;
            }
            boolean unc1 = InitializationAnnotatedTypeFactory.this.isUnclassified(anno1);
            boolean unc2 = InitializationAnnotatedTypeFactory.this.isUnclassified(anno2);
            boolean free1 = InitializationAnnotatedTypeFactory.this.isFree(anno1);
            boolean free2 = InitializationAnnotatedTypeFactory.this.isFree(anno2);
            if (InitializationAnnotatedTypeFactory.this.isCommitted(anno1)) {
                assert (free2);
                return InitializationAnnotatedTypeFactory.this.createUnclassifiedAnnotation(InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(anno2));
            }
            if (InitializationAnnotatedTypeFactory.this.isCommitted(anno2)) {
                assert (free1);
                return InitializationAnnotatedTypeFactory.this.createUnclassifiedAnnotation(InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(anno1));
            }
            if (free1 && free2) {
                return InitializationAnnotatedTypeFactory.this.createFreeAnnotation(this.lubTypeFrame(InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(anno1), InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(anno2)));
            }
            assert ((unc1 || free1) && (unc2 || free2));
            return InitializationAnnotatedTypeFactory.this.createUnclassifiedAnnotation(this.lubTypeFrame(InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(anno1), InitializationAnnotatedTypeFactory.this.getTypeFrameFromAnnotation(anno2)));
        }

        protected TypeMirror lubTypeFrame(TypeMirror a, TypeMirror b) {
            if (InitializationAnnotatedTypeFactory.this.types.isSubtype(a, b)) {
                return b;
            }
            if (InitializationAnnotatedTypeFactory.this.types.isSubtype(b, a)) {
                return a;
            }
            return InternalUtils.leastUpperBound(InitializationAnnotatedTypeFactory.this.processingEnv, a, b);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror anno1, AnnotationMirror anno2) {
            return super.greatestLowerBound(anno1, anno2);
        }
    }

    protected class CommitmentTreeAnnotator
    extends TreeAnnotator {
        public CommitmentTreeAnnotator(InitializationAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitMethod(MethodTree node, AnnotatedTypeMirror p) {
            Void result = super.visitMethod(node, p);
            if (TreeUtils.isConstructor(node)) {
                assert (p instanceof AnnotatedTypeMirror.AnnotatedExecutableType);
                AnnotatedTypeMirror.AnnotatedExecutableType exeType = (AnnotatedTypeMirror.AnnotatedExecutableType)p;
                DeclaredType underlyingType = (DeclaredType)exeType.getReturnType().getUnderlyingType();
                AnnotationMirror a = InitializationAnnotatedTypeFactory.this.getFreeOrRawAnnotationOfSuperType(underlyingType);
                exeType.getReturnType().replaceAnnotation(a);
            }
            return result;
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror p) {
            super.visitNewClass(node, p);
            if (InitializationAnnotatedTypeFactory.this.useFbc) {
                boolean allCommitted = true;
                Type type = ((JCTree)((Object)node)).type;
                for (ExpressionTree expressionTree : node.getArguments()) {
                    AnnotatedTypeMirror t = InitializationAnnotatedTypeFactory.this.getAnnotatedType(expressionTree);
                    allCommitted &= InitializationAnnotatedTypeFactory.this.isCommitted(t) || InitializationAnnotatedTypeFactory.this.isFbcBottom(t);
                }
                if (!allCommitted) {
                    p.replaceAnnotation(InitializationAnnotatedTypeFactory.this.createFreeAnnotation(type));
                }
            }
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (tree.getKind() != Tree.Kind.NULL_LITERAL) {
                type.addAnnotation(InitializationAnnotatedTypeFactory.this.COMMITTED);
            }
            return (Void)super.visitLiteral(tree, type);
        }
    }

    protected class CommitmentTypeAnnotator
    extends TypeAnnotator {
        public CommitmentTypeAnnotator(InitializationAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType t, Void p) {
            Void result = super.visitExecutable(t, p);
            ExecutableElement elem = t.getElement();
            if (elem.getKind() == ElementKind.CONSTRUCTOR) {
                AnnotatedTypeMirror.AnnotatedDeclaredType returnType = (AnnotatedTypeMirror.AnnotatedDeclaredType)t.getReturnType();
                DeclaredType underlyingType = returnType.getUnderlyingType();
                returnType.replaceAnnotation(InitializationAnnotatedTypeFactory.this.getFreeOrRawAnnotationOfSuperType(underlyingType));
            }
            return result;
        }
    }
}

