/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ClassPath {
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath SYSTEM_CLASS_PATH = new ClassPath(ClassPath.getClassPath());
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FilenameFilter ARCHIVE_FILTER = new FilenameFilter(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown File dir, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
        }
    };
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PathEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] paths;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_path;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath parent;

    public ClassPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath parent, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_path) {
        this(class_path);
        this.parent = parent;
    }

    public ClassPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_path) {
        this.class_path = class_path;
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        StringTokenizer tok = new StringTokenizer(class_path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.equals("")) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vec.add(new Dir(path));
                    continue;
                }
                vec.add(new Zip(new ZipFile(file)));
            }
            catch (IOException e) {
                if (!path.endsWith(".zip") && !path.endsWith(".jar")) continue;
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    @Deprecated
    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        if (this.parent != null) {
            return this.parent + File.pathSeparator + this.class_path;
        }
        return this.class_path;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        if (this.parent != null) {
            return this.class_path.hashCode() + this.parent.hashCode();
        }
        return this.class_path.hashCode();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
        if (o instanceof ClassPath) {
            ClassPath cp = (ClassPath)o;
            return this.class_path.equals(cp.toString());
        }
        return false;
    }

    private static void getPathComponents(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String path, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> list) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        ArrayList<String> list = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        ArrayList<String> dirs = new ArrayList<String>();
        ClassPath.getPathComponents(ext_path, dirs);
        for (String d : dirs) {
            File ext_dir = new File(d);
            String[] extensions = ext_dir.list(ARCHIVE_FILTER);
            if (extensions == null) continue;
            for (String extension : extensions) {
                list.add(ext_dir.getPath() + File.separatorChar + extension);
            }
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        for (String path : list) {
            buf.append(separator);
            separator = File.pathSeparator;
            buf.append(path);
        }
        return buf.toString().intern();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getInputStream(name.replace('.', '/'), ".class");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(name + suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        for (PathEntry path : this.paths) {
            InputStream is = path.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        for (PathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Enumeration<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URL> getResources(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        Vector<URL> results = new Vector<URL>();
        for (PathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            results.add(url);
        }
        return results.elements();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        ClassFile cf = null;
        if (this.parent != null) {
            cf = this.parent.getClassFileInternal(name, suffix);
        }
        if (cf == null) {
            cf = this.getClassFileInternal(name, suffix);
        }
        if (cf != null) {
            return cf;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFile getClassFileInternal(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        for (PathEntry path : this.paths) {
            ClassFile cf = path.getClassFile(name, suffix);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getClassFile(name, ".class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        try (FilterInputStream dis = null;){
            InputStream is = this.getInputStream(name, suffix);
            if (is == null) {
                throw new IOException("Couldn't find: " + name + suffix);
            }
            dis = new DataInputStream(is);
            byte[] bytes = new byte[is.available()];
            ((DataInputStream)dis).readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getBytes(name, ".class");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    private static class Zip
    extends PathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ZipFile zip;

        Zip(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ZipFile z) {
            this.zip = z;
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? new URL("jar:file:" + this.zip.getName() + "!/" + name) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? this.zip.getInputStream(entry) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            final ZipEntry entry = this.zip.getEntry(name.replace('.', '/') + suffix);
            if (entry == null) {
                return null;
            }
            return new ClassFile(){

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
                    return Zip.this.zip.getInputStream(entry);
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getPath() {
                    return entry.toString();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getTime() {
                    return entry.getTime();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getSize() {
                    return entry.getSize();
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBase() {
                    return Zip.this.zip.getName();
                }
            };
        }
    }

    private static class Dir
    extends PathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String dir;

        Dir(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String d) {
            this.dir = d;
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            File file = new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? file.toURI().toURL() : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            File file = new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? new FileInputStream(file) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            final File file = new File(this.dir + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(){

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
                    return new FileInputStream(file);
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getTime() {
                    return file.lastModified();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getSize() {
                    return file.length();
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBase() {
                    return Dir.this.dir;
                }
            } : null;
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
            return this.dir;
        }
    }

    public static interface ClassFile {
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException;

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getPath();

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBase();

        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getTime();

        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getSize();
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var2) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException;

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1);

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1);
    }
}

