/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.ConstantUtf8;
import org.apache.commons.bcel6.classfile.Utility;
import org.apache.commons.bcel6.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class Unknown
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bytes;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name;
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Unknown> unknown_attributes = new HashMap<String, Unknown>();

    static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Unknown @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getUnknownAttributes() {
        Unknown[] unknowns = new Unknown[unknown_attributes.size()];
        unknown_attributes.values().toArray(unknowns);
        unknown_attributes.clear();
        return unknowns;
    }

    public Unknown(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Unknown c) {
        this(c.getNameIndex(), c.getLength(), c.getBytes(), c.getConstantPool());
    }

    public Unknown(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bytes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)-1, name_index, length, constant_pool);
        this.bytes = bytes;
        this.name = ((ConstantUtf8)constant_pool.getConstant(name_index, (byte)1)).getBytes();
        unknown_attributes.put(this.name, this);
    }

    Unknown(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (byte[])null, constant_pool);
        if (length > 0) {
            this.bytes = new byte[length];
            input.readFully(this.bytes);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitUnknown(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        if (super.getLength() > 0) {
            file.write(this.bytes, 0, super.getLength());
        }
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBytes() {
        return this.bytes;
    }

    @Override
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getName() {
        return this.name;
    }

    public final void setBytes(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bytes) {
        this.bytes = bytes;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String hex;
        if (super.getLength() == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (super.getLength() > 10) {
            byte[] tmp = new byte[10];
            System.arraycopy(this.bytes, 0, tmp, 0, 10);
            hex = Utility.toHexString(tmp) + "... (truncated)";
        } else {
            hex = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + hex + ")";
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        Unknown c = (Unknown)this.clone();
        if (this.bytes != null) {
            c.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, c.bytes, 0, this.bytes.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

