/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;

public class CommonScanner
extends TreePathScanner<Void, Void> {
    public static boolean hasClassKind(Tree tree) {
        Tree.Kind kind = tree.getKind();
        return kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || kind == Tree.Kind.ANNOTATION_TYPE;
    }

    public static TreePath findCountingContext(TreePath path) {
        while (path != null) {
            if (path.getLeaf().getKind() == Tree.Kind.METHOD || CommonScanner.isFieldInit(path) || CommonScanner.isInitBlock(path)) {
                return path;
            }
            path = path.getParentPath();
        }
        return path;
    }

    public static TreePath findEnclosingClass(TreePath path) {
        while (!CommonScanner.hasClassKind(path.getLeaf()) || path.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static TreePath findEnclosingMethod(TreePath path) {
        while (path.getLeaf().getKind() != Tree.Kind.METHOD) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isFieldInit(TreePath path) {
        return path.getLeaf().getKind() == Tree.Kind.VARIABLE && path.getParentPath() != null && CommonScanner.hasClassKind(path.getParentPath().getLeaf());
    }

    public static TreePath findEnclosingFieldInit(TreePath path) {
        while (!CommonScanner.isFieldInit(path)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isInitBlock(TreePath path, boolean isStatic) {
        return CommonScanner.isInitBlock(path) && ((BlockTree)path.getLeaf()).isStatic() == isStatic;
    }

    public static boolean isInitBlock(TreePath path) {
        return path.getParentPath() != null && CommonScanner.hasClassKind(path.getParentPath().getLeaf()) && path.getLeaf().getKind() == Tree.Kind.BLOCK;
    }

    public static TreePath findEnclosingInitBlock(TreePath path, boolean isStatic) {
        while (!CommonScanner.isInitBlock(path, isStatic)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isStaticInit(TreePath path) {
        return CommonScanner.isInitBlock(path, true);
    }

    public static TreePath findEnclosingStaticInit(TreePath path) {
        while (!CommonScanner.isStaticInit(path)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    public static boolean isInstanceInit(TreePath path) {
        return CommonScanner.isInitBlock(path, false);
    }

    public static TreePath findEnclosingInstanceInit(TreePath path) {
        while (!CommonScanner.isInstanceInit(path)) {
            if ((path = path.getParentPath()) != null) continue;
            return null;
        }
        return path;
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        return p;
    }
}

