/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.framework.qual.FromByteCode;
import org.checkerframework.qualframework.base.TypeMirrorConverter;

public final class Digest {
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown byte @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] buffer = new byte[4096];
    private static final @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown char @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @FromByteCode
    private Digest() {
        throw new Error("do not instantiate");
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown byte @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] getFileDigest(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String filename, @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown MessageDigest md) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown IOException {
        md.reset();
        DigestInputStream in = new DigestInputStream(new FileInputStream(filename), md);
        while (in.read(buffer) != -1) {
        }
        byte[] result = md.digest();
        in.close();
        return result;
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String hexEncode(@UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown byte @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] bytes) {
        StringBuffer s2 = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            s2.append(digits[(b & 0xF0) >> 4]);
            s2.append(digits[b & 0xF]);
        }
        return s2.toString();
    }

    @FromByteCode
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown byte @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] hexDecode(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String s2) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown IllegalArgumentException {
        try {
            int len = s2.length();
            byte[] r = new byte[len / 2];
            for (int i = 0; i < r.length; ++i) {
                int digit1 = s2.charAt(i * 2);
                int digit2 = s2.charAt(i * 2 + 1);
                if (digit1 >= 48 && digit1 <= 57) {
                    digit1 -= 48;
                } else if (digit1 >= 97 && digit1 <= 102) {
                    digit1 -= 87;
                }
                if (digit2 >= 48 && digit2 <= 57) {
                    digit2 -= 48;
                } else if (digit2 >= 97 && digit2 <= 102) {
                    digit2 -= 87;
                }
                r[i] = (byte)((digit1 << 4) + digit2);
            }
            return r;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("hexDecode(): invalid input");
        }
    }
}

