/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.util.Map;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class DAVElement {
    private static Map ourProperties = new SVNHashMap();
    public static final String SVN_DAV_PROPERTY_NAMESPACE = "http://subversion.tigris.org/xmlns/dav/";
    public static final String SVN_CUSTOM_PROPERTY_NAMESPACE = "http://subversion.tigris.org/xmlns/custom/";
    public static final String SVN_SVN_PROPERTY_NAMESPACE = "http://subversion.tigris.org/xmlns/svn/";
    public static final String SVN_APACHE_PROPERTY_NAMESPACE = "http://apache.org/dav/xmlns";
    public static final String SVN_DAV_ERROR_NAMESPACE = "svn:";
    public static final String DAV_NAMESPACE = "DAV:";
    public static final String SVN_NAMESPACE = "svn:";
    public static final String DEPTH_OPTION = "http://subversion.tigris.org/xmlns/dav/svn/depth";
    public static final String MERGE_INFO_OPTION = "http://subversion.tigris.org/xmlns/dav/svn/mergeinfo";
    public static final String LOG_REVPROPS_OPTION = "http://subversion.tigris.org/xmlns/dav/svn/log-revprops";
    public static final String PARTIAL_REPLAY_OPTION = "http://subversion.tigris.org/xmlns/dav/svn/partial-replay";
    public static final String ATOMIC_REVPROPS_OPTION = "http://subversion.tigris.org/xmlns/dav/svn/atomic-revprops";
    public static final String INHERITED_PROPS_OPTION = "http://subversion.tigris.org/xmlns/dav/svn/inherited-props";
    public static final String EPHEMERAL_PROPS_OPTION = "http://subversion.tigris.org/xmlns/dav/svn/ephemeral-txnprops";
    public static final DAVElement ACTIVITY = DAVElement.getElement("DAV:", "activity");
    public static final DAVElement VERSION_HISTORY = DAVElement.getElement("DAV:", "version-history");
    public static final DAVElement DISPLAY_NAME = DAVElement.getElement("DAV:", "displayname");
    public static final DAVElement SUPPORTED_LIVE_PROPERTY = DAVElement.getElement("DAV:", "supported-live-property");
    public static final DAVElement MERGE_RESPONSE = DAVElement.getElement("DAV:", "merge-response");
    public static final DAVElement UPDATE_SET = DAVElement.getElement("DAV:", "updated-set");
    public static final DAVElement NO_AUTO_MERGE = DAVElement.getElement("DAV:", "no-auto-merge");
    public static final DAVElement NO_CHECKOUT = DAVElement.getElement("DAV:", "no-checkout");
    public static final DAVElement SOURCE = DAVElement.getElement("DAV:", "source");
    public static final DAVElement MULTISTATUS = DAVElement.getElement("DAV:", "multistatus");
    public static final DAVElement RESPONSE = DAVElement.getElement("DAV:", "response");
    public static final DAVElement RESPONSE_DESCRIPTION = DAVElement.getElement("DAV:", "responsedescription");
    public static final DAVElement HREF = DAVElement.getElement("DAV:", "href");
    public static final DAVElement PROPSTAT = DAVElement.getElement("DAV:", "propstat");
    public static final DAVElement PROP = DAVElement.getElement("DAV:", "prop");
    public static final DAVElement STATUS = DAVElement.getElement("DAV:", "status");
    public static final DAVElement BASELINE = DAVElement.getElement("DAV:", "baseline");
    public static final DAVElement BASELINE_COLLECTION = DAVElement.getElement("DAV:", "baseline-collection");
    public static final DAVElement CHECKED_IN = DAVElement.getElement("DAV:", "checked-in");
    public static final DAVElement COLLECTION = DAVElement.getElement("DAV:", "collection");
    public static final DAVElement RESOURCE_TYPE = DAVElement.getElement("DAV:", "resourcetype");
    public static final DAVElement VERSION_CONTROLLED_CONFIGURATION = DAVElement.getElement("DAV:", "version-controlled-configuration");
    public static final DAVElement VERSION_NAME = DAVElement.getElement("DAV:", "version-name");
    public static final DAVElement GET_CONTENT_LENGTH = DAVElement.getElement("DAV:", "getcontentlength");
    public static final DAVElement CREATION_DATE = DAVElement.getElement("DAV:", "creationdate");
    public static final DAVElement CREATOR_DISPLAY_NAME = DAVElement.getElement("DAV:", "creator-displayname");
    public static final DAVElement COMMENT = DAVElement.getElement("DAV:", "comment");
    public static final DAVElement DATE = DAVElement.getElement("svn:", "date");
    public static final DAVElement POST_COMMIT_ERROR = DAVElement.getElement("svn:", "post-commit-err");
    public static final DAVElement PROPFIND = DAVElement.getElement("DAV:", "propfind");
    public static final DAVElement ALLPROP = DAVElement.getElement("DAV:", "allprop");
    public static final DAVElement PROPNAME = DAVElement.getElement("DAV:", "propname");
    public static final DAVElement ACTIVE_LOCK = DAVElement.getElement("DAV:", "activelock");
    public static final DAVElement LOCK_TYPE = DAVElement.getElement("DAV:", "locktype");
    public static final DAVElement LOCK_SCOPE = DAVElement.getElement("DAV:", "lockscope");
    public static final DAVElement WRITE = DAVElement.getElement("DAV:", "write");
    public static final DAVElement EXCLUSIVE = DAVElement.getElement("DAV:", "exclusive");
    public static final DAVElement SHARED = DAVElement.getElement("DAV:", "shared");
    public static final DAVElement DEPTH = DAVElement.getElement("DAV:", "depth");
    public static final DAVElement SUPPORTED_LOCK = DAVElement.getElement("DAV:", "supportedlock");
    public static final DAVElement LOCK_DISCOVERY = DAVElement.getElement("DAV:", "lockdiscovery");
    public static final DAVElement LOCK_OWNER = DAVElement.getElement("DAV:", "owner");
    public static final DAVElement LOCK_TIMEOUT = DAVElement.getElement("DAV:", "timeout");
    public static final DAVElement LOCK_TOKEN = DAVElement.getElement("DAV:", "locktoken");
    public static final DAVElement LOCK_ENTRY = DAVElement.getElement("DAV:", "lockentry");
    public static final DAVElement SVN_LOCK_TOKEN_LIST = DAVElement.getElement("svn:", "lock-token-list");
    public static final DAVElement SVN_LOCK = DAVElement.getElement("svn:", "lock");
    public static final DAVElement SVN_LOCK_PATH = DAVElement.getElement("svn:", "path");
    public static final DAVElement SVN_LOCK_TOKEN = DAVElement.getElement("svn:", "token");
    public static final DAVElement SVN_LOCK_COMMENT = DAVElement.getElement("svn:", "comment");
    public static final DAVElement SVN_LOCK_OWNER = DAVElement.getElement("svn:", "owner");
    public static final DAVElement SVN_LOCK_CREATION_DATE = DAVElement.getElement("svn:", "creationdate");
    public static final DAVElement SVN_LOCK_EXPIRATION_DATE = DAVElement.getElement("svn:", "expirationdate");
    public static final DAVElement PATH = DAVElement.getElement("svn:", "path");
    public static final DAVElement REVISION = DAVElement.getElement("svn:", "revision");
    public static final DAVElement START_REVISION = DAVElement.getElement("svn:", "start-revision");
    public static final DAVElement END_REVISION = DAVElement.getElement("svn:", "end-revision");
    public static final DAVElement PEG_REVISION = DAVElement.getElement("svn:", "peg-revision");
    public static final DAVElement INCLUDE_MERGED_REVISIONS = DAVElement.getElement("svn:", "include-merged-revisions");
    public static final DAVElement BASELINE_RELATIVE_PATH = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "baseline-relative-path");
    public static final DAVElement REPOSITORY_UUID = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "repository-uuid");
    public static final DAVElement MD5_CHECKSUM = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "md5-checksum");
    public static final DAVElement SHA1_CHECKSUM = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "sha1-checksum");
    public static final DAVElement DEADPROP_COUNT = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "deadprop-count");
    public static final DAVElement AUTO_VERSION = DAVElement.getElement("DAV:", "auto-version");
    public static final DAVElement MERGE_INFO_ITEM = DAVElement.getElement("svn:", "mergeinfo-item");
    public static final DAVElement MERGE_INFO_PATH = DAVElement.getElement("svn:", "mergeinfo-path");
    public static final DAVElement MERGE_INFO_INFO = DAVElement.getElement("svn:", "mergeinfo-info");
    public static final DAVElement GET_CONTENT_LANGUAGE = DAVElement.getElement("DAV:", "getcontentlanguage");
    public static final DAVElement GET_CONTENT_TYPE = DAVElement.getElement("DAV:", "getcontenttype");
    public static final DAVElement GET_ETAG = DAVElement.getElement("DAV:", "getetag");
    public static final DAVElement GET_LAST_MODIFIED = DAVElement.getElement("DAV:", "getlastmodified");
    public static final DAVElement[] STARTING_PROPERTIES = new DAVElement[]{VERSION_CONTROLLED_CONFIGURATION, RESOURCE_TYPE, BASELINE_RELATIVE_PATH, REPOSITORY_UUID};
    public static final DAVElement[] BASELINE_PROPERTIES = new DAVElement[]{BASELINE_COLLECTION, VERSION_NAME};
    private String myPropertyName;
    private String myNamespace;
    public static final DAVElement LOG = DAVElement.getElement("http://subversion.tigris.org/xmlns/svn/", "log");

    public static DAVElement getElement(String namespace, String name) {
        DAVElement property;
        Map properties;
        if (namespace == null) {
            namespace = "";
        }
        if ((properties = (Map)ourProperties.get(namespace)) == null) {
            properties = new SVNHashMap();
            ourProperties.put(namespace, properties);
        }
        if ((property = (DAVElement)properties.get(name = name.replace('\u3007', ':'))) == null) {
            property = new DAVElement(namespace, name);
            properties.put(name, property);
        }
        return property;
    }

    private DAVElement(String namespace, String propertyName) {
        this.myNamespace = namespace;
        this.myPropertyName = propertyName;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String getName() {
        return this.myPropertyName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNamespace());
        if (!this.getNamespace().endsWith(":")) {
            sb.append(":");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myNamespace == null ? 0 : this.myNamespace.hashCode());
        result = 31 * result + (this.myPropertyName == null ? 0 : this.myPropertyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DAVElement other = (DAVElement)obj;
        if (this.myNamespace == null ? other.myNamespace != null : !this.myNamespace.equals(other.myNamespace)) {
            return false;
        }
        return !(this.myPropertyName == null ? other.myPropertyName != null : !this.myPropertyName.equals(other.myPropertyName));
    }
}

