/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;

public class SVNAdminLoadCommand
extends SVNAdminCommand
implements ISVNAdminEventHandler {
    private boolean myIsNodeOpened;

    public SVNAdminLoadCommand() {
        super("load", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
        options.add(SVNAdminOption.QUIET);
        options.add(SVNAdminOption.IGNORE_UUID);
        options.add(SVNAdminOption.FORCE_UUID);
        options.add(SVNAdminOption.USE_PRE_COMMIT_HOOK);
        options.add(SVNAdminOption.USE_POST_COMMIT_HOOK);
        options.add(SVNAdminOption.PARENT_DIR);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        if (!this.getSVNAdminEnvironment().isQuiet()) {
            client.setEventHandler(this);
        }
        SVNUUIDAction uuidAction = SVNUUIDAction.DEFAULT;
        if (this.getSVNAdminEnvironment().isForceUUID()) {
            uuidAction = SVNUUIDAction.FORCE_UUID;
        } else if (this.getSVNAdminEnvironment().isIgnoreUUID()) {
            uuidAction = SVNUUIDAction.IGNORE_UUID;
        }
        client.doLoad(this.getLocalRepository(), this.getEnvironment().getIn(), this.getSVNAdminEnvironment().isUsePreCommitHook(), this.getSVNAdminEnvironment().isUsePostCommitHook(), uuidAction, this.getSVNAdminEnvironment().getParentDir());
    }

    @Override
    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event.getAction() != SVNAdminEventAction.REVISION_LOAD && this.myIsNodeOpened) {
            this.getEnvironment().getOut().println(" done.");
            this.myIsNodeOpened = false;
        }
        if (event.getAction() == SVNAdminEventAction.REVISION_LOADED) {
            this.getEnvironment().getOut().println();
        }
        this.getEnvironment().getOut().print(event.getMessage());
        if (event.getAction() == SVNAdminEventAction.REVISION_LOADED || event.getAction() == SVNAdminEventAction.REVISION_LOAD) {
            this.getEnvironment().getOut().println();
        }
        this.myIsNodeOpened = event.getAction() != SVNAdminEventAction.REVISION_LOAD;
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        this.getEnvironment().checkCancelled();
    }
}

