/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public abstract class CFAbstractAnalysis<V extends CFAbstractValue<V>, S extends CFAbstractStore<V, S>, T extends CFAbstractTransfer<V, S, T>>
extends Analysis<V, S, T> {
    protected final QualifierHierarchy qualifierHierarchy;
    protected final TypeHierarchy typeHierarchy;
    protected final GenericAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> atypeFactory;
    protected final SourceChecker checker;
    protected final List<Pair<VariableElement, V>> fieldValues;

    public CFAbstractAnalysis(BaseTypeChecker checker, GenericAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> factory, List<Pair<VariableElement, V>> fieldValues) {
        super(checker.getProcessingEnvironment());
        this.qualifierHierarchy = factory.getQualifierHierarchy();
        this.typeHierarchy = factory.getTypeHierarchy();
        this.atypeFactory = factory;
        this.checker = checker;
        this.transferFunction = this.createTransferFunction();
        this.fieldValues = fieldValues;
    }

    public List<Pair<VariableElement, V>> getFieldValues() {
        return this.fieldValues;
    }

    public T createTransferFunction() {
        return this.atypeFactory.createFlowTransferFunction(this);
    }

    public abstract S createEmptyStore(boolean var1);

    public abstract S createCopiedStore(S var1);

    public @Nullable V createAbstractValue(AnnotatedTypeMirror type) {
        Set<AnnotationMirror> annos = type.getKind() == TypeKind.WILDCARD ? ((AnnotatedTypeMirror.AnnotatedWildcardType)type).getExtendsBound().getAnnotations() : type.getAnnotations();
        return this.createAbstractValue(annos, type.getUnderlyingType());
    }

    public abstract @Nullable V createAbstractValue(Set<AnnotationMirror> var1, TypeMirror var2);

    public CFValue defaultCreateAbstractValue(CFAbstractAnalysis<CFValue, ?, ?> analysis, Set<AnnotationMirror> annotations, TypeMirror underlyingType) {
        if (!CFAbstractValue.validateSet(annotations, underlyingType, this.qualifierHierarchy)) {
            return null;
        }
        return new CFValue(analysis, annotations, underlyingType);
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    public GenericAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> getTypeFactory() {
        return this.atypeFactory;
    }

    public void visualizeCFG() {
        this.atypeFactory.getCFGVisualizer().visualize(this.cfg, this.cfg.getEntryBlock(), this);
    }

    public V createSingleAnnotationValue(AnnotationMirror anno, TypeMirror underlyingType) {
        QualifierHierarchy hierarchy = this.getTypeFactory().getQualifierHierarchy();
        Set<AnnotationMirror> annos = AnnotationUtils.createAnnotationSet();
        annos.addAll(hierarchy.getTopAnnotations());
        AnnotationMirror f = hierarchy.findAnnotationInSameHierarchy(annos, anno);
        annos.remove(f);
        annos.add(anno);
        return this.createAbstractValue(annos, underlyingType);
    }

    public <W extends GenericAnnotatedTypeFactory<?, ?, ?, ?>, U extends BaseTypeChecker> W getTypeFactoryOfSubchecker(Class<U> checkerClass) {
        return (W)this.atypeFactory.getTypeFactoryOfSubchecker(checkerClass);
    }
}

