/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import org.apache.subversion.javahl.types.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionRange
implements Comparable<RevisionRange>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Revision from;
    private Revision to;

    private RevisionRange(long from, long to) {
        this.from = Revision.getInstance(from);
        this.to = Revision.getInstance(to);
    }

    public RevisionRange(Revision from, Revision to) {
        this.from = from;
        this.to = to;
    }

    public RevisionRange(String revisionElement) {
        if (revisionElement == null) {
            return;
        }
        int hyphen = revisionElement.indexOf(45);
        if (hyphen > 0) {
            try {
                long fromRev = Long.parseLong(revisionElement.substring(0, hyphen));
                long toRev = Long.parseLong(revisionElement.substring(hyphen + 1));
                this.from = new Revision.Number(fromRev);
                this.to = new Revision.Number(toRev);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        try {
            long revNum = Long.parseLong(revisionElement.trim());
            this.to = this.from = new Revision.Number(revNum);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public Revision getFromRevision() {
        return this.from;
    }

    public Revision getToRevision() {
        return this.to;
    }

    public String toString() {
        if (this.from != null && this.to != null) {
            if (this.from.equals(this.to)) {
                return this.from.toString();
            }
            return this.from.toString() + '-' + this.to.toString();
        }
        return super.toString();
    }

    public static Long getRevisionAsLong(Revision rev) {
        long val = 0L;
        if (rev != null && rev instanceof Revision.Number) {
            val = ((Revision.Number)rev).getNumber();
        }
        return new Long(val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object range) {
        if (this == range) {
            return true;
        }
        if (!super.equals(range)) {
            return false;
        }
        if (this.getClass() != range.getClass()) {
            return false;
        }
        RevisionRange other = (RevisionRange)range;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }

    @Override
    public int compareTo(RevisionRange range) {
        if (this == range) {
            return 0;
        }
        Revision other = range.getFromRevision();
        return RevisionRange.getRevisionAsLong(this.getFromRevision()).compareTo(RevisionRange.getRevisionAsLong(other));
    }
}

