/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.verifier.statics;

import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import org.apache.commons.bcel6.verifier.exc.LocalVariableInfoInconsistentException;
import org.apache.commons.bcel6.verifier.statics.DOUBLE_Upper;
import org.apache.commons.bcel6.verifier.statics.LONG_Upper;
import org.apache.commons.bcel6.verifier.statics.LocalVariableInfo;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class LocalVariablesInfo {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInfo @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] localVariableInfos;

    LocalVariablesInfo(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_locals) {
        this.localVariableInfos = new LocalVariableInfo[max_locals];
        for (int i = 0; i < max_locals; ++i) {
            this.localVariableInfos[i] = new LocalVariableInfo();
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInfo getLocalVariableInfo(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slot) {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[slot];
    }

    public void add(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slot, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int startpc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type t) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInfoInconsistentException {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[slot].add(name, startpc, length, t);
        if (t == Type.LONG) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, LONG_Upper.theInstance());
        }
        if (t == Type.DOUBLE) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, DOUBLE_Upper.theInstance());
        }
    }
}

