/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.LocalVariable;
import org.apache.commons.bcel6.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class LocalVariableTable
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] local_variable_table;

    public LocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTable(), c.getConstantPool());
    }

    public LocalVariableTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] local_variable_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)5, name_index, length, constant_pool);
        this.local_variable_table = local_variable_table;
    }

    LocalVariableTable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (LocalVariable[])null, constant_pool);
        int local_variable_table_length = input.readUnsignedShort();
        this.local_variable_table = new LocalVariable[local_variable_table_length];
        for (int i = 0; i < local_variable_table_length; ++i) {
            this.local_variable_table[i] = new LocalVariable(input, constant_pool);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.local_variable_table.length);
        for (LocalVariable variable : this.local_variable_table) {
            variable.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getLocalVariableTable() {
        return this.local_variable_table;
    }

    @Deprecated
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        for (LocalVariable variable : this.local_variable_table) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pc) {
        for (LocalVariable variable : this.local_variable_table) {
            if (variable.getIndex() != index) continue;
            int start_pc = variable.getStartPC();
            int end_pc = start_pc + variable.getLength();
            if (pc < start_pc || pc > end_pc) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] local_variable_table) {
        this.local_variable_table = local_variable_table;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            buf.append(this.local_variable_table[i]);
            if (i >= this.local_variable_table.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        LocalVariableTable c = (LocalVariableTable)this.clone();
        c.local_variable_table = new LocalVariable[this.local_variable_table.length];
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            c.local_variable_table[i] = this.local_variable_table[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getTableLength() {
        return this.local_variable_table == null ? 0 : this.local_variable_table.length;
    }
}

