/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitCommand
extends SVNCommand {
    public SVNCommitCommand() {
        super("commit", new String[]{"ci"});
    }

    @Override
    public boolean isCommitter() {
        return true;
    }

    @Override
    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.NO_UNLOCK);
        options = SVNOption.addLogMessageOptions(options);
        options.add(SVNOption.CHANGELIST);
        options.add(SVNOption.KEEP_CHANGELISTS);
        options.add(SVNOption.INCLUDE_EXTERNALS);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        for (String targetName : targets) {
            SVNErrorMessage err;
            SVNPath target = new SVNPath(targetName);
            if (!target.isURL()) continue;
            if (SVNBasicClient.isWC17Supported()) {
                err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is a URL, but URLs cannot be commit targets", (Object)targetName);
                SVNErrorManager.error(err, SVNLogType.CLIENT);
                continue;
            }
            err = SVNErrorMessage.create(SVNErrorCode.WC_BAD_PATH, "Must give local path (not URL) as the target of commit");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (targets.isEmpty()) {
            targets.add(".");
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        SVNCommitClient client = this.getSVNEnvironment().getClientManager().getCommitClient();
        client.setIgnoreExternals(!this.getSVNEnvironment().isIncludeExternals());
        ArrayList<File> filesList = new ArrayList<File>();
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (target.isFile()) {
                filesList.add(target.getFile());
                continue;
            }
            if (targetName == null) continue;
            this.getSVNEnvironment().getOut().println("Skipped '" + targetName + "'");
        }
        if (filesList.isEmpty()) {
            return;
        }
        File[] files = filesList.toArray(new File[filesList.size()]);
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        client.setCommitHandler(this.getSVNEnvironment());
        boolean keepLocks = this.getSVNEnvironment().getOptions().isKeepLocks();
        SVNCommitInfo info = null;
        client.setFailOnMultipleRepositories(true);
        try {
            info = client.doCommit(files, keepLocks, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().getChangelists(), this.getSVNEnvironment().isKeepChangelist(), this.getSVNEnvironment().isForce(), depth);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().getRootErrorMessage();
            if (err.getErrorCode() == SVNErrorCode.UNKNOWN_CHANGELIST) {
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            throw svne;
        }
        finally {
            client.setFailOnMultipleRepositories(false);
        }
        if (!this.getSVNEnvironment().isQuiet()) {
            this.getSVNEnvironment().printCommitInfo(info);
        }
    }
}

