/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.commons.bcel6.classfile.ClassParser;
import org.apache.commons.bcel6.classfile.ConstantClass;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.ConstantUtf8;
import org.apache.commons.bcel6.classfile.JavaClass;
import org.apache.commons.bcel6.classfile.Utility;
import org.apache.commons.bcel6.util.ClassLoaderRepository;
import org.apache.commons.bcel6.util.Repository;
import org.apache.commons.bcel6.util.SyntheticRepository;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

@Deprecated
public class ClassLoader
extends java.lang.ClassLoader {
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String BCEL_TOKEN = "$$BCEL$$";
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] DEFAULT_IGNORED_PACKAGES = new String[]{"java.", "javax.", "sun."};
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Hashtable<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?>> classes = new Hashtable();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] ignored_packages;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Repository repository = SyntheticRepository.getInstance();

    public ClassLoader() {
        this(DEFAULT_IGNORED_PACKAGES);
    }

    public ClassLoader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown java.lang.ClassLoader deferTo) {
        super(deferTo);
        this.ignored_packages = DEFAULT_IGNORED_PACKAGES;
        this.repository = new ClassLoaderRepository(deferTo);
    }

    public ClassLoader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] ignored_packages) {
        this.ignored_packages = ignored_packages;
    }

    public ClassLoader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown java.lang.ClassLoader deferTo, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] ignored_packages) {
        this(ignored_packages);
        this.repository = new ClassLoaderRepository(deferTo);
    }

    @Override
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean resolve) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        Class<?> cl = null;
        cl = this.classes.get(class_name);
        if (cl == null) {
            for (String ignored_package : this.ignored_packages) {
                if (!class_name.startsWith(ignored_package)) continue;
                cl = this.getParent().loadClass(class_name);
                break;
            }
            if (cl == null) {
                JavaClass clazz = null;
                if (class_name.contains(BCEL_TOKEN)) {
                    clazz = this.createClass(class_name);
                } else {
                    clazz = this.repository.loadClass(class_name);
                    if (clazz != null) {
                        clazz = this.modifyClass(clazz);
                    } else {
                        throw new ClassNotFoundException(class_name);
                    }
                }
                if (clazz != null) {
                    byte[] bytes = clazz.getBytes();
                    cl = this.defineClass(class_name, bytes, 0, bytes.length);
                } else {
                    cl = Class.forName(class_name);
                }
            }
            if (resolve) {
                this.resolveClass(cl);
            }
        }
        this.classes.put(class_name, cl);
        return cl;
    }

    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass modifyClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        return clazz;
    }

    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass createClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name) {
        int index = class_name.indexOf(BCEL_TOKEN);
        String real_name = class_name.substring(index + BCEL_TOKEN.length());
        JavaClass clazz = null;
        try {
            byte[] bytes = Utility.decode(real_name, true);
            ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), "foo");
            clazz = parser.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ConstantPool cp = clazz.getConstantPool();
        ConstantClass cl = (ConstantClass)cp.getConstant(clazz.getClassNameIndex(), (byte)7);
        ConstantUtf8 name = (ConstantUtf8)cp.getConstant(cl.getNameIndex(), (byte)1);
        name.setBytes(class_name.replace('.', '/'));
        return clazz;
    }
}

