/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.bcel6.classfile.AnnotationEntry;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.Node;
import org.apache.commons.bcel6.classfile.ParameterAnnotations;
import org.apache.commons.bcel6.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ParameterAnnotationEntry
implements Node {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] annotation_table;

    ParameterAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        int annotation_table_length = input.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[annotation_table_length];
        for (int i = 0; i < annotation_table_length; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(input, constant_pool, false);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitParameterAnnotationEntry(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAnnotationEntries() {
        return this.annotation_table;
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeShort(this.annotation_table.length);
        for (AnnotationEntry entry : this.annotation_table) {
            entry.dump(dos);
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ParameterAnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] createParameterAnnotationEntries(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attrs) {
        ArrayList accumulatedAnnotations = new ArrayList(attrs.length);
        for (Attribute attribute : attrs) {
            if (!(attribute instanceof ParameterAnnotations)) continue;
            ParameterAnnotations runtimeAnnotations = (ParameterAnnotations)attribute;
            Collections.addAll(accumulatedAnnotations, runtimeAnnotations.getParameterAnnotationEntries());
        }
        return accumulatedAnnotations.toArray(new ParameterAnnotationEntry[accumulatedAnnotations.size()]);
    }
}

