/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.type.TypeFromTree;
import org.checkerframework.framework.type.TypeFromTreeVisitor;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

class TypeFromMemberVisitor
extends TypeFromTreeVisitor {
    TypeFromMemberVisitor() {
    }

    @Override
    public AnnotatedTypeMirror visitVariable(VariableTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror result = TypeFromTree.fromTypeTree(f, node.getType());
        VariableElement elt = TreeUtils.elementFromDeclaration(node);
        ElementAnnotationApplier.apply(result, elt, f);
        TypeFromMemberVisitor.inferLambdaParamAnnotations(f, result, elt);
        return result;
    }

    @Override
    public AnnotatedTypeMirror visitMethod(MethodTree node, AnnotatedTypeFactory f) {
        ExecutableElement elt = TreeUtils.elementFromDeclaration(node);
        AnnotatedTypeMirror.AnnotatedExecutableType result = (AnnotatedTypeMirror.AnnotatedExecutableType)f.toAnnotatedType(elt.asType(), false);
        result.setElement(elt);
        ElementAnnotationApplier.apply(result, elt, f);
        return result;
    }

    private static void inferLambdaParamAnnotations(AnnotatedTypeFactory f, AnnotatedTypeMirror result, Element paramElement) {
        if (f.declarationFromElement(paramElement) == null || f.getPath(f.declarationFromElement(paramElement)) == null || f.getPath(f.declarationFromElement(paramElement)).getParentPath() == null) {
            return;
        }
        Tree declaredInTree = f.getPath(f.declarationFromElement(paramElement)).getParentPath().getLeaf();
        if (declaredInTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            LambdaExpressionTree lambdaDecl = (LambdaExpressionTree)declaredInTree;
            int index = lambdaDecl.getParameters().indexOf(f.declarationFromElement(paramElement));
            Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> res = f.getFnInterfaceFromTree(lambdaDecl);
            AnnotatedTypeMirror.AnnotatedExecutableType fnMethod = (AnnotatedTypeMirror.AnnotatedExecutableType)res.second;
            AnnotatedTypeMirror declaredParam = fnMethod.getParameterTypes().get(index);
            result.addMissingAnnotations(declaredParam.getAnnotations());
        }
    }
}

