/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import annotations.Annotation;
import annotations.el.AClass;
import annotations.el.ADeclaration;
import annotations.el.AElement;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.AnnotationDef;
import annotations.el.BoundLocation;
import annotations.el.DefException;
import annotations.el.InnerTypeLocation;
import annotations.el.LocalLocation;
import annotations.io.IndexFileParser;
import annotations.io.IndexFileWriter;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.stubparser.JavaParser;
import org.checkerframework.stubparser.ParseException;
import org.checkerframework.stubparser.ast.CompilationUnit;
import org.checkerframework.stubparser.ast.ImportDeclaration;
import org.checkerframework.stubparser.ast.IndexUnit;
import org.checkerframework.stubparser.ast.PackageDeclaration;
import org.checkerframework.stubparser.ast.TypeParameter;
import org.checkerframework.stubparser.ast.body.AnnotationDeclaration;
import org.checkerframework.stubparser.ast.body.BodyDeclaration;
import org.checkerframework.stubparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.stubparser.ast.body.ConstructorDeclaration;
import org.checkerframework.stubparser.ast.body.EnumConstantDeclaration;
import org.checkerframework.stubparser.ast.body.EnumDeclaration;
import org.checkerframework.stubparser.ast.body.FieldDeclaration;
import org.checkerframework.stubparser.ast.body.InitializerDeclaration;
import org.checkerframework.stubparser.ast.body.MethodDeclaration;
import org.checkerframework.stubparser.ast.body.Parameter;
import org.checkerframework.stubparser.ast.body.TypeDeclaration;
import org.checkerframework.stubparser.ast.body.VariableDeclarator;
import org.checkerframework.stubparser.ast.expr.AnnotationExpr;
import org.checkerframework.stubparser.ast.expr.Expression;
import org.checkerframework.stubparser.ast.expr.ObjectCreationExpr;
import org.checkerframework.stubparser.ast.expr.VariableDeclarationExpr;
import org.checkerframework.stubparser.ast.stmt.BlockStmt;
import org.checkerframework.stubparser.ast.type.ClassOrInterfaceType;
import org.checkerframework.stubparser.ast.type.PrimitiveType;
import org.checkerframework.stubparser.ast.type.ReferenceType;
import org.checkerframework.stubparser.ast.type.Type;
import org.checkerframework.stubparser.ast.type.VoidType;
import org.checkerframework.stubparser.ast.type.WildcardType;
import org.checkerframework.stubparser.ast.visitor.GenericVisitorAdapter;

public class ToIndexFileConverter
extends GenericVisitorAdapter<Void, AElement> {
    private static Pattern importPattern = Pattern.compile("\\bimport *+((?:[^.]*+[.] *+)*+[^ ]*) *+;");
    private final String pkgName;
    private final List<String> imports;
    private final AScene scene;

    public ToIndexFileConverter(PackageDeclaration pkgDecl, List<ImportDeclaration> importDecls, AScene scene) {
        this.scene = scene;
        String string = this.pkgName = pkgDecl == null ? "" : pkgDecl.getName().getName();
        if (importDecls == null) {
            this.imports = Collections.emptyList();
        } else {
            ArrayList<String> imps = new ArrayList<String>(importDecls.size());
            for (ImportDeclaration decl : importDecls) {
                String s2;
                Matcher m3;
                if (decl.isStatic() || !(m3 = importPattern.matcher(decl.toString())).find() || (s2 = m3.group(1)) == null) continue;
                imps.add(s2);
            }
            imps.trimToSize();
            this.imports = Collections.unmodifiableList(imps);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java ToIndexFileConverter myfile.jaif [stubfile...]");
            System.err.println("(myfile.jaif contains needed annotation definitions)");
            System.exit(1);
        }
        AScene scene = new AScene();
        try {
            IndexFileParser.parseFile(args[0], scene);
            if (args.length == 1) {
                ToIndexFileConverter.convert(scene, System.in, System.out);
                return;
            }
            for (int i = 1; i < args.length; ++i) {
                String f0 = args[i];
                String f1 = (f0.endsWith(".astub") ? f0.substring(0, f0.length() - 6) : f0) + ".jaif";
                try (FileInputStream in = new FileInputStream(f0);
                     FileOutputStream out = new FileOutputStream(f1);){
                    ToIndexFileConverter.convert(new AScene(scene), in, out);
                    continue;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void convert(AScene scene, InputStream in, OutputStream out) throws IOException, DefException, ParseException {
        IndexUnit iu = JavaParser.parse(in);
        ToIndexFileConverter.extractScene(iu, scene);
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));){
            IndexFileWriter.write(scene, w);
        }
    }

    private static void extractScene(IndexUnit iu, AScene scene) {
        for (CompilationUnit cu : iu.getCompilationUnits()) {
            List<TypeDeclaration> typeDecls = cu.getTypes();
            if (typeDecls == null) continue;
            List<ImportDeclaration> impDecls = cu.getImports();
            PackageDeclaration pkgDecl = cu.getPackage();
            for (TypeDeclaration typeDecl : typeDecls) {
                ToIndexFileConverter converter = new ToIndexFileConverter(pkgDecl, impDecls, scene);
                String pkgName = converter.pkgName;
                String name = typeDecl.getName();
                if (!pkgName.isEmpty()) {
                    name = pkgName + "." + name;
                }
                typeDecl.accept(converter, scene.classes.vivify(name));
            }
        }
    }

    private static Annotation extractAnnotation(AnnotationExpr expr) {
        String exprName = expr.toString().substring(1);
        if (exprName.contains("+")) {
            return null;
        }
        AnnotationDef def = new AnnotationDef(exprName);
        def.setFieldTypes(Collections.emptyMap());
        return new Annotation(def, Collections.emptyMap());
    }

    @Override
    public Void visit(AnnotationDeclaration decl, AElement elem) {
        return null;
    }

    @Override
    public Void visit(BlockStmt stmt, AElement elem) {
        return null;
    }

    @Override
    public Void visit(ClassOrInterfaceDeclaration decl, AElement elem) {
        this.visitDecl(decl, (ADeclaration)elem);
        return (Void)super.visit(decl, elem);
    }

    @Override
    public Void visit(ConstructorDeclaration decl, AElement elem) {
        List<Parameter> params = decl.getParameters();
        List<AnnotationExpr> rcvrAnnos = decl.getReceiverAnnotations();
        BlockStmt body = decl.getBlock();
        StringBuilder sb = new StringBuilder("<init>(");
        AClass clazz = (AClass)elem;
        if (params != null) {
            for (Parameter param : params) {
                Type ptype = param.getType();
                sb.append(this.getJVML(ptype));
            }
        }
        sb.append(")V");
        AMethod method = clazz.methods.vivify(sb.toString());
        this.visitDecl(decl, method);
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Parameter param;
                param = params.get(i);
                AField field = method.parameters.vivify(i);
                this.visitType(param.getType(), field.type);
            }
        }
        if (rcvrAnnos != null) {
            for (AnnotationExpr expr : rcvrAnnos) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                method.receiver.tlAnnotationsHere.add(anno);
            }
        }
        return body == null ? null : body.accept(this, method);
    }

    @Override
    public Void visit(EnumConstantDeclaration decl, AElement elem) {
        AField field = ((AClass)elem).fields.vivify(decl.getName());
        this.visitDecl(decl, field);
        return (Void)super.visit(decl, field);
    }

    @Override
    public Void visit(EnumDeclaration decl, AElement elem) {
        this.visitDecl(decl, (ADeclaration)elem);
        return (Void)super.visit(decl, elem);
    }

    @Override
    public Void visit(FieldDeclaration decl, AElement elem) {
        for (VariableDeclarator v : decl.getVariables()) {
            AClass clazz = (AClass)elem;
            AField field = clazz.fields.vivify(v.getId().getName());
            this.visitDecl(decl, field);
            this.visitType(decl.getType(), field.type);
        }
        return null;
    }

    @Override
    public Void visit(InitializerDeclaration decl, AElement elem) {
        BlockStmt block = decl.getBlock();
        AClass clazz = (AClass)elem;
        block.accept(this, clazz.methods.vivify(decl.isStatic() ? "<clinit>" : "<init>"));
        return null;
    }

    @Override
    public Void visit(MethodDeclaration decl, AElement elem) {
        Type type = decl.getType();
        List<Parameter> params = decl.getParameters();
        List<TypeParameter> typeParams = decl.getTypeParameters();
        List<AnnotationExpr> rcvrAnnos = decl.getReceiverAnnotations();
        BlockStmt body = decl.getBody();
        StringBuilder sb = new StringBuilder(decl.getName()).append('(');
        AClass clazz = (AClass)elem;
        if (params != null) {
            for (Parameter param : params) {
                Type ptype = param.getType();
                sb.append(this.getJVML(ptype));
            }
        }
        sb.append(')').append(this.getJVML(type));
        AMethod method = clazz.methods.vivify(sb.toString());
        this.visitDecl(decl, method);
        this.visitType(type, method.returnType);
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Parameter param;
                param = params.get(i);
                AField field = method.parameters.vivify(i);
                this.visitType(param.getType(), field.type);
            }
        }
        if (rcvrAnnos != null) {
            for (AnnotationExpr expr : rcvrAnnos) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                method.receiver.type.tlAnnotationsHere.add(anno);
            }
        }
        if (typeParams != null) {
            for (int i = 0; i < typeParams.size(); ++i) {
                TypeParameter typeParam = typeParams.get(i);
                List<ClassOrInterfaceType> bounds = typeParam.getTypeBound();
                if (bounds == null) continue;
                for (int j = 0; j < bounds.size(); ++j) {
                    ClassOrInterfaceType bound = bounds.get(j);
                    BoundLocation loc = new BoundLocation(i, j);
                    bound.accept(this, method.bounds.vivify(loc));
                }
            }
        }
        return body == null ? null : body.accept(this, method);
    }

    @Override
    public Void visit(ObjectCreationExpr expr, AElement elem) {
        ClassOrInterfaceType type = expr.getType();
        AClass clazz = this.scene.classes.vivify(type.getName());
        Expression scope = expr.getScope();
        List<Type> typeArgs = expr.getTypeArgs();
        List<Expression> args = expr.getArgs();
        List<BodyDeclaration> decls = expr.getAnonymousClassBody();
        if (scope != null) {
            scope.accept(this, elem);
        }
        if (args != null) {
            for (Expression arg : args) {
                arg.accept(this, elem);
            }
        }
        if (typeArgs != null) {
            for (Type typeArg : typeArgs) {
                typeArg.accept(this, elem);
            }
        }
        type.accept(this, clazz);
        if (decls != null) {
            for (BodyDeclaration decl : decls) {
                decl.accept(this, clazz);
            }
        }
        return null;
    }

    @Override
    public Void visit(VariableDeclarationExpr expr, AElement elem) {
        List<AnnotationExpr> annos = expr.getAnnotations();
        AMethod method = (AMethod)elem;
        List<VariableDeclarator> varDecls = expr.getVars();
        for (int i = 0; i < varDecls.size(); ++i) {
            VariableDeclarator decl = varDecls.get(i);
            LocalLocation loc = new LocalLocation(decl.getId().getName(), i);
            AField field = method.body.locals.vivify(loc);
            this.visitType(expr.getType(), field.type);
            if (annos == null) continue;
            for (AnnotationExpr annoExpr : annos) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(annoExpr);
                field.tlAnnotationsHere.add(anno);
            }
        }
        return null;
    }

    private Void visitDecl(BodyDeclaration decl, ADeclaration elem) {
        List<AnnotationExpr> annoExprs = decl.getAnnotations();
        if (annoExprs != null) {
            for (AnnotationExpr annoExpr : annoExprs) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(annoExpr);
                elem.tlAnnotationsHere.add(anno);
            }
        }
        return null;
    }

    private Void visitType(Type type, ATypeElement elem) {
        List<AnnotationExpr> exprs = type.getAnnotations();
        if (exprs != null) {
            for (AnnotationExpr expr : exprs) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                if (anno == null) continue;
                elem.tlAnnotationsHere.add(anno);
            }
        }
        ToIndexFileConverter.visitInnerTypes(type, elem);
        return null;
    }

    private static Void visitInnerTypes(Type type, final ATypeElement elem) {
        return type.accept(new GenericVisitorAdapter<Void, InnerTypeLocation>(){

            @Override
            public Void visit(ClassOrInterfaceType type, InnerTypeLocation loc) {
                List<Type> typeArgs = type.getTypeArgs();
                for (int i = 0; i < typeArgs.size(); ++i) {
                    Type inner = typeArgs.get(i);
                    InnerTypeLocation ext = this.extendedTypePath(loc, 3, i);
                    this.visitInnerType(inner, ext);
                }
                return null;
            }

            @Override
            public Void visit(ReferenceType type, InnerTypeLocation loc) {
                InnerTypeLocation ext = loc;
                int n = type.getArrayCount();
                for (int i = 0; i < n; ++i) {
                    ext = this.extendedTypePath(ext, 1, 0);
                    for (AnnotationExpr expr : type.getAnnotationsAtLevel(i)) {
                        ATypeElement typeElem = elem.innerTypes.vivify(ext);
                        Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                        typeElem.tlAnnotationsHere.add(anno);
                    }
                }
                return null;
            }

            @Override
            public Void visit(WildcardType type, InnerTypeLocation loc) {
                InnerTypeLocation ext;
                ReferenceType lower = type.getExtends();
                ReferenceType upper = type.getSuper();
                if (lower != null) {
                    ext = this.extendedTypePath(loc, 2, 0);
                    this.visitInnerType(lower, ext);
                }
                if (upper != null) {
                    ext = this.extendedTypePath(loc, 2, 0);
                    this.visitInnerType(upper, ext);
                }
                return null;
            }

            private void visitInnerType(Type type, InnerTypeLocation loc) {
                ATypeElement typeElem = elem.innerTypes.vivify(loc);
                for (AnnotationExpr expr : type.getAnnotations()) {
                    Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                    typeElem.tlAnnotationsHere.add(anno);
                    type.accept(this, loc);
                }
            }

            private InnerTypeLocation extendedTypePath(InnerTypeLocation loc, int tag, int arg) {
                ArrayList<TypeAnnotationPosition.TypePathEntry> path = new ArrayList<TypeAnnotationPosition.TypePathEntry>(loc.location.size() + 1);
                path.addAll(loc.location);
                path.add(TypeAnnotationPosition.TypePathEntry.fromBinary(tag, arg));
                return new InnerTypeLocation(path);
            }
        }, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
    }

    private String getJVML(Type type) {
        return type.accept(new GenericVisitorAdapter<String, Void>(){

            @Override
            public String visit(ClassOrInterfaceType type, Void v) {
                String typeName = type.getName();
                String name = ToIndexFileConverter.this.resolve(typeName);
                if (name == null) {
                    return "L" + typeName + ";";
                }
                return "L" + PluginUtil.join("/", name.split("\\.")) + ";";
            }

            @Override
            public String visit(PrimitiveType type, Void v) {
                switch (type.getType()) {
                    case Boolean: {
                        return "Z";
                    }
                    case Byte: {
                        return "B";
                    }
                    case Char: {
                        return "C";
                    }
                    case Double: {
                        return "D";
                    }
                    case Float: {
                        return "F";
                    }
                    case Int: {
                        return "I";
                    }
                    case Long: {
                        return "J";
                    }
                    case Short: {
                        return "S";
                    }
                }
                throw new IllegalArgumentException("baseTypeName(): unknown primitive type " + type);
            }

            @Override
            public String visit(ReferenceType type, Void v) {
                String typeName = type.getType().accept(this, null);
                StringBuilder sb = new StringBuilder();
                int n = type.getArrayCount();
                for (int i = 0; i < n; ++i) {
                    sb.append("[");
                }
                sb.append(typeName);
                return sb.toString();
            }

            @Override
            public String visit(VoidType type, Void v) {
                return "V";
            }

            @Override
            public String visit(WildcardType type, Void v) {
                return type.getSuper().accept(this, null);
            }
        }, null);
    }

    private String resolve(String className) {
        String qualifiedName;
        Class<?> resolved = null;
        if (this.pkgName.isEmpty()) {
            qualifiedName = className;
            resolved = ToIndexFileConverter.loadClass(qualifiedName);
            if (resolved == null) {
                qualifiedName = "java.lang." + className;
                resolved = ToIndexFileConverter.loadClass(qualifiedName);
            }
        } else {
            qualifiedName = this.pkgName + "." + className;
            resolved = ToIndexFileConverter.loadClass(qualifiedName);
            if (resolved == null) {
                qualifiedName = className;
                resolved = ToIndexFileConverter.loadClass(qualifiedName);
            }
        }
        if (resolved == null) {
            for (String declName : this.imports) {
                qualifiedName = ToIndexFileConverter.mergeImport(declName, className);
                if (qualifiedName == null) continue;
                return qualifiedName;
            }
            return className;
        }
        return qualifiedName;
    }

    private static String mergeImport(String importName, String className) {
        if (importName.isEmpty() || importName.equals(className)) {
            return className;
        }
        String[] importSplit = importName.split("\\.");
        String[] classSplit = className.split("\\.");
        String importEnd = importSplit[importSplit.length - 1];
        if ("*".equals(importEnd)) {
            return importName.substring(0, importName.length() - 1) + className;
        }
        int i = importSplit.length;
        int n = i - classSplit.length;
        while (--i >= n) {
            if (classSplit[i - n].equals(importSplit[i])) continue;
            return null;
        }
        return importName;
    }

    private static Class<?> loadClass(String className) {
        assert (className != null);
        try {
            return Class.forName(className, false, null);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

