/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.reflection;

import com.sun.source.tree.Tree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.reflection.ClassValAnnotatedTypeFactory;
import org.checkerframework.common.reflection.qual.ClassBound;
import org.checkerframework.common.reflection.qual.ClassVal;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;

class ClassNameValidator
extends BaseTypeValidator {
    public ClassNameValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor, AnnotatedTypeFactory atypeFactory) {
        super(checker, visitor, atypeFactory);
    }

    @Override
    public boolean isValid(AnnotatedTypeMirror type, Tree tree) {
        AnnotationMirror classVal = type.getAnnotation(ClassVal.class);
        AnnotationMirror annotationMirror = classVal = classVal == null ? type.getAnnotation(ClassBound.class) : classVal;
        if (classVal != null) {
            List<String> classNames = ClassValAnnotatedTypeFactory.getClassNamesFromAnnotation(classVal);
            for (String className : classNames) {
                if (this.isLegalClassName(className)) continue;
                this.checker.report(Result.failure("illegal.classname", className, type), tree);
            }
        }
        return super.isValid(type, tree);
    }

    private boolean isLegalClassName(String className) {
        String[] identifiers;
        int lastBracket = className.lastIndexOf("]");
        if (lastBracket != -1 && lastBracket != className.length() - 1) {
            return false;
        }
        className = className.replaceAll("\\[\\]", "");
        for (String identifier : identifiers = className.split("(\\.)")) {
            if (this.isJavaIdentifier(identifier)) continue;
            return false;
        }
        return true;
    }

    private boolean isJavaIdentifier(String identifier) {
        char[] identifierChars = identifier.toCharArray();
        if (identifierChars.length <= 0 || !Character.isJavaIdentifierStart(identifierChars[0])) {
            return false;
        }
        for (int i = 1; i < identifierChars.length; ++i) {
            if (Character.isJavaIdentifierPart(identifierChars[i])) continue;
            return false;
        }
        return true;
    }
}

