/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationUtils;

public class SignednessAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror UNKNOWN_SIGNEDNESS;

    public SignednessAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN_SIGNEDNESS = AnnotationUtils.fromClass(this.elements, UnknownSignedness.class);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return this.getBundledTypeQualifiersWithoutPolyAll(new Class[0]);
    }

    @Override
    protected void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        this.addUnknownSignednessToSomeLocals(tree, type);
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
    }

    private void addUnknownSignednessToSomeLocals(Tree tree, AnnotatedTypeMirror type) {
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: {
                QualifierDefaults defaults = new QualifierDefaults(this.elements, this);
                defaults.addCheckedCodeDefault(this.UNKNOWN_SIGNEDNESS, TypeUseLocation.LOCAL_VARIABLE);
                defaults.annotate(tree, type);
                break;
            }
        }
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new SignednessTreeAnnotator(this), super.createTreeAnnotator());
    }

    private class SignednessTreeAnnotator
    extends TreeAnnotator {
        public SignednessTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        private Void annotateBoolean(AnnotatedTypeMirror type) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    type.addAnnotation(SignednessAnnotatedTypeFactory.this.UNKNOWN_SIGNEDNESS);
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            return this.annotateBoolean(type);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, AnnotatedTypeMirror type) {
            return this.annotateBoolean(type);
        }
    }
}

