/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.framework.util.dependenttypes.DependentTypesError;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.TreeUtils;

public class OffsetEquation {
    public static final OffsetEquation ZERO = OffsetEquation.createOffsetForInt(0);
    public static final OffsetEquation NEG_1 = OffsetEquation.createOffsetForInt(-1);
    public static final OffsetEquation ONE = OffsetEquation.createOffsetForInt(1);
    private final List<String> addedTerms;
    private final List<String> subtractedTerms;
    private String error = null;
    private int intValue = 0;

    private OffsetEquation() {
        this.addedTerms = new ArrayList<String>();
        this.subtractedTerms = new ArrayList<String>();
    }

    private OffsetEquation(OffsetEquation other) {
        this.addedTerms = new ArrayList<String>(other.addedTerms);
        this.subtractedTerms = new ArrayList<String>(other.subtractedTerms);
        this.error = other.error;
        this.intValue = other.intValue;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetEquation that = (OffsetEquation)o;
        if (this.intValue != that.intValue) {
            return false;
        }
        if (!this.addedTerms.containsAll(that.addedTerms) || !that.addedTerms.containsAll(this.addedTerms)) {
            return false;
        }
        if (!this.subtractedTerms.containsAll(that.subtractedTerms) || !that.subtractedTerms.containsAll(this.subtractedTerms)) {
            return false;
        }
        return this.error != null ? this.error.equals(that.error) : that.error == null;
    }

    public int hashCode() {
        int result = this.addedTerms.hashCode();
        result = 31 * result + this.subtractedTerms.hashCode();
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + this.intValue;
        return result;
    }

    public String toString() {
        if (this.addedTerms.isEmpty() && this.subtractedTerms.isEmpty()) {
            return String.valueOf(this.intValue);
        }
        ArrayList<String> sortedAdds = new ArrayList<String>(this.addedTerms);
        Collections.sort(sortedAdds);
        ArrayList<String> sortedSubs = new ArrayList<String>(this.subtractedTerms);
        Collections.sort(sortedSubs);
        String adds = PluginUtil.join(" + ", sortedAdds);
        String minus = PluginUtil.join(" - ", sortedSubs);
        if (sortedSubs.size() == 1 && sortedAdds.isEmpty()) {
            minus = "-" + minus;
        } else if (!sortedSubs.isEmpty()) {
            minus = " - " + minus;
        }
        String terms = (adds + minus).trim();
        if (this.intValue != 0) {
            char op = this.intValue > 0 ? (char)'+' : '-';
            terms = terms.isEmpty() ? terms + this.intValue : terms + " " + op + " " + Math.abs(this.intValue);
        }
        return terms;
    }

    public OffsetEquation removeArrayLengths(List<String> arrays) {
        OffsetEquation copy = new OffsetEquation(this);
        boolean simplified = false;
        for (String array : arrays) {
            String arrayLen = array + ".length";
            if (!this.addedTerms.contains(arrayLen)) continue;
            copy.addedTerms.remove(arrayLen);
            simplified = true;
        }
        return simplified ? copy : null;
    }

    public OffsetEquation copyAdd(char op, OffsetEquation other) {
        assert (op == '-' || op == '+');
        OffsetEquation copy = new OffsetEquation(this);
        if (op == '+') {
            copy.plus(other);
        } else {
            copy.minus(other);
        }
        return copy;
    }

    private void plus(OffsetEquation eq) {
        this.addInt(eq.intValue);
        for (String term : eq.addedTerms) {
            this.addTerm('+', term);
        }
        for (String term : eq.subtractedTerms) {
            this.addTerm('-', term);
        }
    }

    private void minus(OffsetEquation eq) {
        this.addInt(-1 * eq.intValue);
        for (String term : eq.addedTerms) {
            this.addTerm('-', term);
        }
        for (String term : eq.subtractedTerms) {
            this.addTerm('+', term);
        }
    }

    public boolean lessThanOrEqual(OffsetEquation other) {
        return this.isInt() && other.isInt() && this.intValue <= other.getInt() || this.equals(other);
    }

    public boolean isInt() {
        return this.addedTerms.isEmpty() && this.subtractedTerms.isEmpty();
    }

    public int getInt() {
        return this.intValue;
    }

    public boolean isNegOne() {
        return this.isInt() && this.getInt() == -1;
    }

    public boolean isNonNegative() {
        return this.isInt() && this.getInt() >= 0;
    }

    public boolean isNegativeOrZero() {
        return this.isInt() && this.getInt() <= 0;
    }

    public void standardizeAndViewpointAdaptExpressions(FlowExpressionParseUtil.FlowExpressionContext context, TreePath scope, boolean useLocalScope) throws FlowExpressionParseUtil.FlowExpressionParseException {
        ArrayList<String> newAddterms = new ArrayList<String>();
        for (String term : this.addedTerms) {
            String standardizedTerm = FlowExpressionParseUtil.parse(term, context, scope, useLocalScope).toString();
            newAddterms.add(standardizedTerm);
        }
        ArrayList<String> newSubTerms = new ArrayList<String>();
        for (String term : this.subtractedTerms) {
            String standardizedTerm = FlowExpressionParseUtil.parse(term, context, scope, useLocalScope).toString();
            newSubTerms.add(standardizedTerm);
        }
        this.addedTerms.clear();
        this.addedTerms.addAll(newAddterms);
        this.subtractedTerms.clear();
        this.subtractedTerms.addAll(newSubTerms);
    }

    private void addTerm(char operator, String term) {
        if (OffsetEquation.isInt(term = term.trim())) {
            int literal = OffsetEquation.parseInt(term);
            this.addInt(operator == '-' ? -1 * literal : literal);
            return;
        }
        if (operator == '-') {
            if (this.addedTerms.contains(term)) {
                this.addedTerms.remove(term);
            } else {
                this.subtractedTerms.add(term);
            }
        } else if (operator == '+') {
            if (this.subtractedTerms.contains(term)) {
                this.subtractedTerms.remove(term);
            } else {
                this.addedTerms.add(term);
            }
        } else assert (false);
    }

    private void addInt(int value) {
        this.intValue += value;
    }

    public static OffsetEquation getIntOffsetEquation(Set<OffsetEquation> equationSet) {
        for (OffsetEquation eq : equationSet) {
            if (!eq.isInt()) continue;
            return eq;
        }
        return null;
    }

    public static OffsetEquation createOffsetForInt(int value) {
        OffsetEquation equation = new OffsetEquation();
        equation.intValue = value;
        return equation;
    }

    public static OffsetEquation createOffsetFromJavaExpression(String expressionEquation) {
        expressionEquation = expressionEquation.trim();
        OffsetEquation equation = new OffsetEquation();
        if (expressionEquation.isEmpty()) {
            equation.addTerm('+', "0");
            return equation;
        }
        if (DependentTypesError.isExpressionError(expressionEquation)) {
            equation.error = expressionEquation;
            return equation;
        }
        if (OffsetEquation.indexOf(expressionEquation, '-', '+', 0) == -1) {
            equation.addTerm('+', expressionEquation);
            return equation;
        }
        int index = 0;
        while (index < expressionEquation.length()) {
            String subexpression;
            char operator = expressionEquation.charAt(index);
            if (operator == '-' || operator == '+') {
                ++index;
            } else {
                operator = '+';
            }
            int endIndex = OffsetEquation.indexOf(expressionEquation, '-', '+', index);
            if (endIndex == -1) {
                endIndex = expressionEquation.length();
                subexpression = expressionEquation.substring(index);
            } else {
                subexpression = expressionEquation.substring(index, endIndex);
            }
            equation.addTerm(operator, subexpression);
            index = endIndex;
        }
        return equation;
    }

    private static boolean isInt(String string) {
        return string.isEmpty() || string.matches("[-+]?[0-9]+");
    }

    private static int parseInt(String intLiteral) {
        if (intLiteral.isEmpty()) {
            return 0;
        }
        return Integer.valueOf(intLiteral);
    }

    private static int indexOf(String string, char a, char b, int index) {
        int aIndex = string.indexOf(a, index);
        int bIndex = string.indexOf(b, index);
        if (aIndex == -1) {
            return bIndex;
        }
        if (bIndex == -1) {
            return aIndex;
        }
        return Math.min(aIndex, bIndex);
    }

    public static OffsetEquation createOffsetFromNodesValue(Node node, UpperBoundAnnotatedTypeFactory factory, char op) {
        Long i;
        assert (op == '+' || op == '-');
        if (node.getTree() != null && TreeUtils.isExpressionTree(node.getTree()) && (i = IndexUtil.getExactValue(node.getTree(), factory.getValueAnnotatedTypeFactory())) != null) {
            if (op == '-') {
                i = -i.longValue();
            }
            OffsetEquation eq = new OffsetEquation();
            eq.addInt(i.intValue());
            return eq;
        }
        return null;
    }

    public static OffsetEquation createOffsetFromNode(Node node, UpperBoundAnnotatedTypeFactory factory, char op) {
        assert (op == '+' || op == '-');
        OffsetEquation eq = new OffsetEquation();
        OffsetEquation.createOffsetFromNode(node, factory, eq, op);
        return eq;
    }

    private static void createOffsetFromNode(Node node, UpperBoundAnnotatedTypeFactory factory, OffsetEquation eq, char op) {
        FlowExpressions.Receiver r = FlowExpressions.internalReprOf((AnnotationProvider)factory, node);
        if (r instanceof FlowExpressions.Unknown || r == null) {
            if (node instanceof NumericalAdditionNode) {
                OffsetEquation.createOffsetFromNode(((NumericalAdditionNode)node).getLeftOperand(), factory, eq, op);
                OffsetEquation.createOffsetFromNode(((NumericalAdditionNode)node).getRightOperand(), factory, eq, op);
            } else if (node instanceof NumericalSubtractionNode) {
                OffsetEquation.createOffsetFromNode(((NumericalSubtractionNode)node).getLeftOperand(), factory, eq, op);
                char other = op == '+' ? (char)'-' : '+';
                OffsetEquation.createOffsetFromNode(((NumericalSubtractionNode)node).getRightOperand(), factory, eq, other);
            } else {
                eq.error = node.toString();
            }
        } else {
            eq.addTerm(op, r.toString());
        }
    }
}

