/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import plume.Pair;

public class AnnotationInsertion
extends Insertion {
    private final String annotation;
    private String type;
    private boolean generateBound;
    private boolean generateExtends;
    private boolean wasGenerateExtends;

    public AnnotationInsertion(String annotation, Criteria criteria, boolean separateLine) {
        super(criteria, separateLine);
        this.annotation = annotation;
        this.type = null;
        this.generateBound = false;
        this.generateExtends = false;
        this.wasGenerateExtends = false;
    }

    public AnnotationInsertion(String annotation) {
        this(annotation, new Criteria(), false);
    }

    public boolean isGenerateExtends() {
        return this.generateExtends;
    }

    public boolean isGenerateBound() {
        return this.generateBound;
    }

    public void setGenerateExtends(boolean generateExtends) {
        this.generateExtends = generateExtends;
        this.wasGenerateExtends |= generateExtends;
    }

    public void setGenerateBound(boolean b) {
        this.generateBound = b;
    }

    @Override
    protected String getText(boolean comments, boolean abbreviate) {
        String result = this.annotation;
        if (abbreviate) {
            Pair<String, String> ps = AnnotationInsertion.removePackage(result);
            String packageName = (String)ps.a;
            if (packageName != null) {
                this.packageNames.add(packageName);
                result = (String)ps.b;
            }
        }
        if (!result.startsWith("@")) {
            throw new Error("Illegal insertion, must start with @: " + result);
        }
        if (this.type != null) {
            result = "new " + result + " " + this.type;
        } else if (this.generateBound) {
            result = result + " Object &";
        } else if (this.generateExtends) {
            result = " extends " + result + " Object";
        }
        return comments ? "/*" + result + "*/" : result;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        if (this.generateExtends || precedingChar == '.') {
            return false;
        }
        return super.addLeadingSpace(gotSeparateLine, pos, precedingChar);
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return !this.wasGenerateExtends && super.addTrailingSpace(gotSeparateLine);
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.ANNOTATION;
    }

    @Override
    public String toString() {
        return this.annotation + " " + super.toString();
    }

    public void setType(String s2) {
        this.type = s2;
    }
}

