/*
 * Decompiled with CFR 0.152.
 */
package annotations.io;

import annotations.util.PersistentStack;

class ConsStack<E>
implements PersistentStack<E> {
    private int size = 0;
    private E elem = null;
    private PersistentStack<E> rest = null;

    private static <T, S extends ConsStack<T>> S extend(T el, S s0) {
        try {
            ConsStack s1;
            ConsStack cs = s1 = (ConsStack)s0.getClass().newInstance();
            cs.size = 1 + s0.size();
            cs.elem = el;
            cs.rest = s0;
            return (S)s1;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public E peek() {
        if (this.size > 0) {
            return this.elem;
        }
        throw new IllegalStateException("peek() on empty stack");
    }

    @Override
    public PersistentStack<E> pop() {
        if (this.size > 0) {
            return this.rest;
        }
        throw new IllegalStateException("pop() on empty stack");
    }

    @Override
    public PersistentStack<E> push(E elem) {
        return ConsStack.extend(elem, this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.size > 0) {
            StringBuilder sb = new StringBuilder("]").insert(0, this.peek());
            PersistentStack<E> stack = this.pop();
            while (!stack.isEmpty()) {
                sb = sb.insert(0, ", ").insert(0, stack.peek());
                stack = stack.pop();
            }
            return sb.insert(0, "[").toString();
        }
        return "[]";
    }
}

