/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;

public class FileIOException
extends IOException {
    static final long serialVersionUID = 20050923L;
    public final String fileName;
    public final int lineNumber;

    public FileIOException() {
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(Throwable cause) {
        this.initCause(cause);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(String message) {
        super(message);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(String message, Throwable cause) {
        super(message);
        this.initCause(cause);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(String message, String fileName, int lineNumber) {
        super(message);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public FileIOException(String message, Throwable cause, String fileName, int lineNumber) {
        super(message);
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public FileIOException(LineNumberReader reader, Throwable cause) {
        this(reader, (String)null, cause);
    }

    public FileIOException(String message, LineNumberReader reader) {
        this(message, reader, (String)null);
    }

    public FileIOException(String message, LineNumberReader reader, Throwable cause) {
        this(message, reader, (String)null, cause);
    }

    public FileIOException(String message, LineNumberReader reader, String fileName) {
        super(message);
        this.fileName = fileName;
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    public FileIOException(LineNumberReader reader, String fileName, Throwable cause) {
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    public FileIOException(String message, LineNumberReader reader, String fileName, Throwable cause) {
        super(message);
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    public FileIOException(String message, LineNumberReader reader, File file) {
        this(message, reader, file.getName());
    }

    public FileIOException(String message, LineNumberReader reader, File file, Throwable cause) {
        this(message, reader, file.getName(), cause);
    }

    public FileIOException(LineNumberReader reader, File file, Throwable cause) {
        this.initCause(cause);
        this.fileName = file.getName();
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.fileName != null) {
            result = result + " in file " + this.fileName;
        }
        if (this.lineNumber != -1) {
            result = result + " at line " + this.lineNumber;
        }
        return result;
    }

    private static int getLineNumber(LineNumberReader reader) {
        if (reader != null) {
            return reader.getLineNumber();
        }
        return -1;
    }
}

