/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.initialization.InitializationVisitor;
import org.checkerframework.checker.nullness.AbstractNullnessChecker;
import org.checkerframework.checker.nullness.NullnessAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.NullnessStore;
import org.checkerframework.checker.nullness.NullnessValue;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFCFGBuilder;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.QualifierPolymorphism;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class NullnessVisitor
extends InitializationVisitor<NullnessAnnotatedTypeFactory, NullnessValue, NullnessStore> {
    private static final @CompilerMessageKey String UNBOXING_OF_NULLABLE = "unboxing.of.nullable";
    private static final @CompilerMessageKey String KNOWN_NONNULL = "known.nonnull";
    private static final @CompilerMessageKey String LOCKING_NULLABLE = "locking.nullable";
    private static final @CompilerMessageKey String THROWING_NULLABLE = "throwing.nullable";
    private static final @CompilerMessageKey String ACCESSING_NULLABLE = "accessing.nullable";
    private static final @CompilerMessageKey String CONDITION_NULLABLE = "condition.nullable";
    private static final @CompilerMessageKey String ITERATING_NULLABLE = "iterating.over.nullable";
    private static final @CompilerMessageKey String SWITCHING_NULLABLE = "switching.nullable";
    private static final @CompilerMessageKey String DEREFERENCE_OF_NULLABLE = "dereference.of.nullable";
    private final AnnotationMirror NONNULL;
    private final AnnotationMirror NULLABLE;
    private final AnnotationMirror MONOTONIC_NONNULL;
    private final TypeMirror stringType;
    private final ExecutableElement collectionSize;
    private final ExecutableElement collectionToArray;

    public NullnessVisitor(BaseTypeChecker checker, boolean useFbc) {
        super(checker);
        this.NONNULL = ((NullnessAnnotatedTypeFactory)this.atypeFactory).NONNULL;
        this.NULLABLE = ((NullnessAnnotatedTypeFactory)this.atypeFactory).NULLABLE;
        this.MONOTONIC_NONNULL = ((NullnessAnnotatedTypeFactory)this.atypeFactory).MONOTONIC_NONNULL;
        this.stringType = this.elements.getTypeElement("java.lang.String").asType();
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.collectionSize = TreeUtils.getMethod(Collection.class.getName(), "size", 0, env);
        this.collectionToArray = TreeUtils.getMethod(Collection.class.getName(), "toArray", 1, env);
        this.checkForAnnotatedJdk();
    }

    @Override
    public NullnessAnnotatedTypeFactory createTypeFactory() {
        return new NullnessAnnotatedTypeFactory(this.checker, ((AbstractNullnessChecker)this.checker).useFbc);
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        boolean foundInit = false;
        boolean foundNonNull = false;
        Set<Class<? extends Annotation>> initQuals = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getInitializationAnnotations();
        Set<Class<? extends Annotation>> nonNullQuals = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getNullnessAnnotations();
        for (AnnotationMirror anno : useType.getAnnotations()) {
            if (QualifierPolymorphism.isPolyAll(anno)) continue;
            if (this.containsSameIgnoringValues(initQuals, anno)) {
                if (foundInit) {
                    return false;
                }
                foundInit = true;
                continue;
            }
            if (!this.containsSameIgnoringValues(nonNullQuals, anno)) continue;
            if (foundNonNull) {
                return false;
            }
            foundNonNull = true;
        }
        if (tree.getKind() == Tree.Kind.VARIABLE) {
            Element vs = InternalUtils.symbol(tree);
            switch (vs.getKind()) {
                case EXCEPTION_PARAMETER: {
                    if (!useType.hasAnnotation(this.NULLABLE)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Tree tree) {
        if (tree.getKind() != Tree.Kind.TYPE_CAST && !type.hasAnnotation(this.NONNULL)) {
            return false;
        }
        return super.isValidUse(type, tree);
    }

    private boolean containsSameIgnoringValues(Set<Class<? extends Annotation>> quals, AnnotationMirror anno) {
        for (Class<? extends Annotation> q : quals) {
            if (!AnnotationUtils.areSameByClass(anno, q)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        VariableElement elem;
        if (varTree.getKind() == Tree.Kind.VARIABLE && ((NullnessAnnotatedTypeFactory)this.atypeFactory).fromElement(elem = TreeUtils.elementFromDeclaration((VariableTree)varTree)).hasEffectiveAnnotation(this.MONOTONIC_NONNULL) && !this.checker.getLintOption("noInitForMonotonicNonNull", false)) {
            return;
        }
        super.commonAssignmentCheck(varTree, valueExp, errorKey);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        ((NullnessAnnotatedTypeFactory)this.atypeFactory).replacePolyQualifier(varType, valueExp);
        super.commonAssignmentCheck(varType, valueExp, errorKey);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        boolean succeed;
        if (TypesUtils.isPrimitive(varType.getUnderlyingType()) && !TypesUtils.isPrimitive(valueType.getUnderlyingType()) && !(succeed = this.checkForNullability(valueType, valueTree, UNBOXING_OF_NULLABLE))) {
            return;
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        boolean isType;
        boolean bl = isType = node.getExpression().getKind() == Tree.Kind.PARAMETERIZED_TYPE;
        if (!TreeUtils.isSelfAccess(node) && !isType) {
            this.checkForNullability(node.getExpression(), DEREFERENCE_OF_NULLABLE);
        }
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
        this.checkForNullability(node.getExpression(), ITERATING_NULLABLE);
        return super.visitEnhancedForLoop(node, p);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void p) {
        this.checkForNullability(node.getExpression(), ACCESSING_NULLABLE);
        return super.visitArrayAccess(node, p);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void p) {
        AnnotatedTypeMirror.AnnotatedArrayType type = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        AnnotatedTypeMirror componentType = type.getComponentType();
        if (componentType.hasEffectiveAnnotation(this.NONNULL) && !NullnessVisitor.isNewArrayAllZeroDims(node) && !this.isNewArrayInToArray(node) && !TypesUtils.isPrimitive(componentType.getUnderlyingType()) && this.checker.getLintOption("forbidnonnullarraycomponents", false)) {
            this.checker.report(Result.failure("new.array.type.invalid", componentType.getAnnotations(), type.toString()), node);
        }
        return super.visitNewArray(node, p);
    }

    private static boolean isNewArrayAllZeroDims(NewArrayTree node) {
        boolean isAllZeros = true;
        for (ExpressionTree expressionTree : node.getDimensions()) {
            if (expressionTree instanceof LiteralTree) {
                Object val = ((LiteralTree)expressionTree).getValue();
                if (val instanceof Number && Integer.valueOf(0).equals(val)) continue;
                isAllZeros = false;
                break;
            }
            isAllZeros = false;
            break;
        }
        return isAllZeros;
    }

    private boolean isNewArrayInToArray(NewArrayTree node) {
        ProcessingEnvironment env;
        if (node.getDimensions().size() != 1) {
            return false;
        }
        ExpressionTree dim = node.getDimensions().get(0);
        if (!TreeUtils.isMethodInvocation(dim, this.collectionSize, env = this.checker.getProcessingEnvironment())) {
            return false;
        }
        ExpressionTree rcvsize = ((MethodInvocationTree)dim).getMethodSelect();
        if (!(rcvsize instanceof MemberSelectTree)) {
            return false;
        }
        if (!((rcvsize = ((MemberSelectTree)rcvsize).getExpression()) instanceof IdentifierTree)) {
            return false;
        }
        Tree encl = this.getCurrentPath().getParentPath().getLeaf();
        if (!TreeUtils.isMethodInvocation(encl, this.collectionToArray, env)) {
            return false;
        }
        ExpressionTree rcvtoarray = ((MethodInvocationTree)encl).getMethodSelect();
        if (!(rcvtoarray instanceof MemberSelectTree)) {
            return false;
        }
        if (!((rcvtoarray = ((MemberSelectTree)rcvtoarray).getExpression()) instanceof IdentifierTree)) {
            return false;
        }
        return ((IdentifierTree)rcvsize).getName() == ((IdentifierTree)rcvtoarray).getName();
    }

    @Override
    protected void checkThrownExpression(ThrowTree node) {
        this.checkForNullability(node.getExpression(), THROWING_NULLABLE);
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Void p) {
        this.checkForNullability(node.getExpression(), LOCKING_NULLABLE);
        return (Void)super.visitSynchronized(node, p);
    }

    @Override
    public Void visitAssert(AssertTree node, Void p) {
        boolean doVisitAssert = true;
        if (this.checker.hasOption("assumeAssertionsAreEnabled") || CFCFGBuilder.assumeAssertionsActivatedForAssertTree(this.checker, node)) {
            doVisitAssert = true;
        } else if (this.checker.hasOption("assumeAssertionsAreDisabled")) {
            doVisitAssert = false;
        }
        if (doVisitAssert) {
            this.checkForNullability(node.getCondition(), CONDITION_NULLABLE);
            return (Void)super.visitAssert(node, p);
        }
        return null;
    }

    @Override
    public Void visitIf(IfTree node, Void p) {
        this.checkForNullability(node.getCondition(), CONDITION_NULLABLE);
        return (Void)super.visitIf(node, p);
    }

    protected void checkForRedundantTests(BinaryTree node) {
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        if (!this.checker.getLintOption("redundantNullComparison", false)) {
            return;
        }
        if (node.getKind() == Tree.Kind.EQUAL_TO || node.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            AnnotatedTypeMirror left = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(leftOp);
            AnnotatedTypeMirror right = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(rightOp);
            if (leftOp.getKind() == Tree.Kind.NULL_LITERAL && right.hasEffectiveAnnotation(this.NONNULL)) {
                this.checker.report(Result.warning(KNOWN_NONNULL, rightOp.toString()), node);
            } else if (rightOp.getKind() == Tree.Kind.NULL_LITERAL && left.hasEffectiveAnnotation(this.NONNULL)) {
                this.checker.report(Result.warning(KNOWN_NONNULL, leftOp.toString()), node);
            }
        }
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        if (this.isUnboxingOperation(node)) {
            this.checkForNullability(leftOp, UNBOXING_OF_NULLABLE);
            this.checkForNullability(rightOp, UNBOXING_OF_NULLABLE);
        }
        this.checkForRedundantTests(node);
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitUnary(UnaryTree node, Void p) {
        this.checkForNullability(node.getExpression(), UNBOXING_OF_NULLABLE);
        return super.visitUnary(node, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        if (!this.isString(node)) {
            this.checkForNullability(node.getVariable(), UNBOXING_OF_NULLABLE);
            this.checkForNullability(node.getExpression(), UNBOXING_OF_NULLABLE);
        }
        return super.visitCompoundAssignment(node, p);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        if (NullnessVisitor.isPrimitive(node) && !NullnessVisitor.isPrimitive(node.getExpression())) {
            this.checkForNullability(node.getExpression(), UNBOXING_OF_NULLABLE);
        }
        return super.visitTypeCast(node, p);
    }

    private boolean checkForNullability(ExpressionTree tree, @CompilerMessageKey String errMsg) {
        AnnotatedTypeMirror type = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree);
        return this.checkForNullability(type, tree, errMsg);
    }

    private boolean checkForNullability(AnnotatedTypeMirror type, Tree tree, @CompilerMessageKey String errMsg) {
        if (!type.hasEffectiveAnnotation(this.NONNULL)) {
            this.checker.report(Result.failure(errMsg, tree), tree);
            return false;
        }
        return true;
    }

    @Override
    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
        if (!TreeUtils.isSelfAccess(node) && method.getReceiverType() != null) {
            Set<AnnotationMirror> recvAnnos = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getReceiverType(node).getAnnotations();
            AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = method.getReceiverType().getErased();
            AnnotatedTypeMirror treeReceiver = ((AnnotatedTypeMirror)methodReceiver).shallowCopy(false);
            AnnotatedTypeMirror rcv = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
            treeReceiver.addAnnotations(rcv.getEffectiveAnnotations());
            if (treeReceiver.hasAnnotation(this.NULLABLE) || recvAnnos.contains(this.MONOTONIC_NONNULL)) {
                return;
            }
        }
        super.checkMethodInvocability(method, node);
    }

    private final boolean isUnboxingOperation(BinaryTree tree) {
        if (tree.getKind() == Tree.Kind.EQUAL_TO || tree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            return NullnessVisitor.isPrimitive(tree.getLeftOperand()) != NullnessVisitor.isPrimitive(tree.getRightOperand());
        }
        return !this.isString(tree);
    }

    private final boolean isString(ExpressionTree tree) {
        TypeMirror type = InternalUtils.typeOf(tree);
        return this.types.isAssignable(this.stringType, type);
    }

    private static final boolean isPrimitive(ExpressionTree tree) {
        return InternalUtils.typeOf(tree).getKind().isPrimitive();
    }

    @Override
    public Void visitSwitch(SwitchTree node, Void p) {
        this.checkForNullability(node.getExpression(), SWITCHING_NULLABLE);
        return (Void)super.visitSwitch(node, p);
    }

    @Override
    public Void visitForLoop(ForLoopTree node, Void p) {
        if (node.getCondition() != null) {
            this.checkForNullability(node.getCondition(), CONDITION_NULLABLE);
        }
        return (Void)super.visitForLoop(node, p);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = ((NullnessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        ExpressionTree identifier = node.getIdentifier();
        if (identifier instanceof AnnotatedTypeTree) {
            AnnotatedTypeTree t = (AnnotatedTypeTree)identifier;
            for (AnnotationMirror a : ((NullnessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(t).getAnnotations()) {
                boolean nullnessCheckerAnno = this.containsSameIgnoringValues(((NullnessAnnotatedTypeFactory)this.atypeFactory).getNullnessAnnotations(), a);
                if (!nullnessCheckerAnno || AnnotationUtils.areSame(this.NONNULL, a)) continue;
                this.checker.report(Result.warning("new.class.type.invalid", type.getAnnotations()), node);
            }
            if (t.toString().contains("@PolyNull")) {
                this.checker.report(Result.warning("new.class.type.invalid", type.getAnnotations()), node);
            }
        }
        return super.visitNewClass(node, p);
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, Void p) {
        this.checkForNullability(node.getCondition(), CONDITION_NULLABLE);
        return (Void)super.visitWhileLoop(node, p);
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Void p) {
        this.checkForNullability(node.getCondition(), CONDITION_NULLABLE);
        return (Void)super.visitDoWhileLoop(node, p);
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        this.checkForNullability(node.getCondition(), CONDITION_NULLABLE);
        return super.visitConditionalExpression(node, p);
    }

    @Override
    protected void checkExceptionParameter(CatchTree node) {
    }
}

