/*
 * Decompiled with CFR 0.152.
 */
package annotations.util;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import plume.UtilMDE;

public class JVMNames {
    public static String getJVMMethodName(MethodTree methodTree) {
        String returnTypeStr;
        Symbol.MethodSymbol methodElement = ((JCTree.JCMethodDecl)methodTree).sym;
        StringBuilder builder = new StringBuilder();
        builder.append(methodTree.getName());
        builder.append("(");
        if (methodElement == null) {
            List<JCTree.JCVariableDecl> params = ((JCTree.JCMethodDecl)methodTree).params;
            JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)params.head;
            JCTree.JCExpression jCExpression = ((JCTree.JCMethodDecl)methodTree).restype;
            returnTypeStr = JVMNames.treeToJVMLString(jCExpression);
            while (param != null) {
                builder.append(JVMNames.treeToJVMLString(param.vartype));
                params = params.tail;
                param = (JCTree.JCVariableDecl)params.head;
            }
        } else {
            TypeMirror returnType = methodElement.getReturnType();
            returnTypeStr = JVMNames.typeToJvmlString((Type)returnType);
            for (VariableElement variableElement : methodElement.getParameters()) {
                Type vt = (Type)variableElement.asType();
                if (vt.getTag() == TypeTag.TYPEVAR) {
                    vt = vt.getUpperBound();
                }
                builder.append(JVMNames.typeToJvmlString(vt));
            }
        }
        builder.append(")");
        builder.append(returnTypeStr);
        return builder.toString();
    }

    public static String getJVMMethodName(ExecutableElement methodElement) {
        StringBuilder builder = new StringBuilder();
        builder.append(methodElement.getSimpleName());
        builder.append("(");
        TypeMirror returnType = methodElement.getReturnType();
        String returnTypeStr = JVMNames.typeToJvmlString((Type)returnType);
        for (VariableElement variableElement : methodElement.getParameters()) {
            Type vt = (Type)variableElement.asType();
            if (vt.getTag() == TypeTag.TYPEVAR) {
                vt = vt.getUpperBound();
            }
            builder.append(JVMNames.typeToJvmlString(vt));
        }
        builder.append(")");
        builder.append(returnTypeStr);
        return builder.toString();
    }

    public static String typeToJvmlString(Type type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return "[" + JVMNames.typeToJvmlString((Type)((ArrayType)((Object)type)).getComponentType());
        }
        if (type.getKind() == TypeKind.INTERSECTION) {
            return JVMNames.typeToJvmlString(type.tsym.erasure_field);
        }
        if (type.getKind() == TypeKind.VOID) {
            return "V";
        }
        return UtilMDE.binaryNameToFieldDescriptor(type.tsym.flatName().toString());
    }

    private static String treeToJVMLString(Tree typeTree) {
        StringBuilder builder = new StringBuilder();
        JVMNames.treeToJVMLString(typeTree, builder);
        return builder.toString();
    }

    private static void treeToJVMLString(Tree typeTree, StringBuilder builder) {
        switch (typeTree.getKind()) {
            case ARRAY_TYPE: {
                builder.append('[');
                JVMNames.treeToJVMLString(((ArrayTypeTree)typeTree).getType(), builder);
                break;
            }
            default: {
                String str = typeTree.toString();
                builder.append("void".equals(str) ? "V" : UtilMDE.binaryNameToFieldDescriptor(typeTree.toString()));
            }
        }
    }

    public static String jvmlStringToJavaTypeString(String str) {
        return str.equals("V") ? "void" : UtilMDE.fieldDescriptorToBinaryName(str);
    }
}

