/*
 * Decompiled with CFR 0.152.
 */
package annotations.el;

import annotations.util.Hasher;

public final class LocalLocation {
    public final int index;
    public final int scopeStart;
    public final int scopeLength;
    public final String varName;
    public final int varIndex;

    public LocalLocation(int index, int scopeStart, int scopeLength) {
        this.index = index;
        this.scopeStart = scopeStart;
        this.scopeLength = scopeLength;
        this.varName = null;
        this.varIndex = -1;
    }

    public LocalLocation(String varName, int varIndex) {
        this.index = -1;
        this.scopeStart = -1;
        this.scopeLength = -1;
        this.varName = varName;
        this.varIndex = varIndex;
    }

    public boolean equals(LocalLocation l) {
        return this.index == l.index && this.scopeStart == l.scopeStart && this.scopeLength == l.scopeLength && (this.varName == null || this.varName.equals(l.varName)) && this.varIndex == l.varIndex;
    }

    public boolean equals(Object o) {
        return o instanceof LocalLocation && this.equals((LocalLocation)o);
    }

    public int hashCode() {
        Hasher h2 = new Hasher();
        if (this.varName == null) {
            h2.mash(this.index);
            h2.mash(this.scopeStart);
            h2.mash(this.scopeLength);
        } else {
            h2.mash(this.varName.hashCode());
            h2.mash(this.varIndex);
        }
        return h2.hash;
    }

    public String toString() {
        if (this.varName == null) {
            return "LocalLocation(" + this.index + ", " + this.scopeStart + ", " + this.scopeLength + ")";
        }
        return "LocalLocation(\"" + this.varName + "\" #" + this.varIndex + ")";
    }
}

