/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public class SVNWCDbSelectWCRootNodes
extends SVNSqlJetSelectStatement {
    public SVNWCDbSelectWCRootNodes(SVNSqlJetDb sDb) throws SVNException {
        super(sDb, SVNWCDbSchema.NODES);
    }

    @Override
    protected boolean isFilterPassed() throws SVNException {
        String localRelpath = this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath);
        String reposRelpath = this.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path);
        if ("".equals(localRelpath) && !"".equals(reposRelpath)) {
            return true;
        }
        if (!"".equals(localRelpath)) {
            if (this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) != 0L) {
                return false;
            }
            long wcId = this.getColumnLong(SVNWCDbSchema.NODES__Fields.wc_id);
            String localParentRelpath = this.getColumnString(SVNWCDbSchema.NODES__Fields.parent_relpath);
            String childName = localParentRelpath.length() == 0 ? localRelpath : localRelpath.substring(localParentRelpath.length() + 1);
            String nodeReposRelpath = this.getNodeReposRelpath(wcId, localParentRelpath);
            if (nodeReposRelpath == null) {
                return true;
            }
            String expectedChildReposPath = SVNPathUtil.append(nodeReposRelpath, childName);
            if (!expectedChildReposPath.equals(reposRelpath)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNodeReposRelpath(long wcId, String path) throws SVNException {
        ISqlJetCursor cursor = null;
        try {
            cursor = this.getTable().lookup(null, wcId, path);
            if (!cursor.eof()) {
                String string = cursor.getString(SVNWCDbSchema.NODES__Fields.repos_path.toString());
                return string;
            }
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (SqlJetException e) {}
            }
        }
        return null;
    }
}

