/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogStream
extends OutputStream {
    private ISVNDebugLog myLog;
    private ByteArrayOutputStream myBuffer;
    private String myPrefix;

    public SVNLogStream(ISVNDebugLog log, boolean write) {
        this.myLog = log;
        this.myBuffer = new ByteArrayOutputStream(2048);
        this.myPrefix = write ? "SENT" : "READ";
    }

    @Override
    public void write(int b) throws IOException {
        this.myBuffer.write(b);
        this.flushBuffer(false);
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer(true);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(true);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.myBuffer.write(b, off, len);
        this.flushBuffer(false);
    }

    public void flushBuffer(boolean force) {
        if (!force && this.myBuffer.size() < 1024) {
            return;
        }
        if (this.myLog != null && this.myBuffer.size() > 0) {
            this.myLog.log(SVNLogType.NETWORK, this.myPrefix, this.myBuffer.toByteArray());
        }
        this.myBuffer.reset();
    }
}

