/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svndumpfilter;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svndumpfilter.SVNDumpFilterCommand;
import org.tmatesoft.svn.core.SVNException;

public class SVNDumpFilterHelpCommand
extends SVNDumpFilterCommand {
    private static final String GENERIC_HELP_HEADER = "general usage: {0} SUBCOMMAND [ARGS & OPTIONS ...]\nType ''{0} help <subcommand>'' for help on a specific subcommand.\nType ''{0} --version'' to see the program version.\n\nAvailable subcommands:";

    public SVNDumpFilterHelpCommand() {
        super("help", new String[]{"?", "h"}, 1);
    }

    @Override
    protected Collection createSupportedOptions() {
        return new LinkedList();
    }

    @Override
    public void run() throws SVNException {
        if (!this.getEnvironment().getArguments().isEmpty()) {
            for (String commandName : this.getEnvironment().getArguments()) {
                AbstractSVNCommand command = AbstractSVNCommand.getCommand(commandName);
                if (command == null) {
                    this.getEnvironment().getErr().println("\"" + commandName + "\": unknown command.\n");
                    continue;
                }
                String help = SVNCommandUtil.getCommandHelp(command, this.getEnvironment().getProgramName(), false);
                this.getEnvironment().getOut().println(help);
            }
        } else if (this.getSVNDumpFilterEnvironment().isVersion()) {
            String version2 = SVNCommandUtil.getVersion(this.getEnvironment(), this.getSVNDumpFilterEnvironment().isQuiet());
            this.getEnvironment().getOut().println(version2);
        } else if (this.getEnvironment().getArguments().isEmpty()) {
            Comparator commandComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    AbstractSVNCommand c1 = (AbstractSVNCommand)o1;
                    AbstractSVNCommand c2 = (AbstractSVNCommand)o2;
                    if (c1 instanceof SVNDumpFilterCommand && c2 instanceof SVNDumpFilterCommand) {
                        SVNDumpFilterCommand dumpFilterCommand1 = (SVNDumpFilterCommand)c1;
                        SVNDumpFilterCommand dumpFilterCommand2 = (SVNDumpFilterCommand)c2;
                        if (dumpFilterCommand1.getOutputPriority() != dumpFilterCommand2.getOutputPriority()) {
                            return dumpFilterCommand1.getOutputPriority() < dumpFilterCommand2.getOutputPriority() ? -1 : 1;
                        }
                    }
                    return c1.getName().compareTo(c2.getName());
                }
            };
            String help = SVNCommandUtil.getGenericHelp(this.getEnvironment().getProgramName(), GENERIC_HELP_HEADER, null, commandComparator);
            this.getEnvironment().getOut().print(help);
        } else {
            String message = MessageFormat.format("Type ''{0} help'' for usage.", this.getEnvironment().getProgramName());
            this.getEnvironment().getOut().println(message);
        }
    }
}

