/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import java.util.Collection;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.qualframework.base.Checker;
import org.checkerframework.qualframework.base.DefaultQualifiedTypeFactory;
import org.checkerframework.qualframework.base.QualifiedTypeFactory;
import org.checkerframework.qualframework.base.QualifiedTypeFactoryAdapter;
import org.checkerframework.qualframework.base.TypeMirrorConverter;
import org.checkerframework.qualframework.base.format.QualifiedTypeFormatter;

public class CheckerAdapter<Q>
extends BaseTypeChecker {
    private final Checker<Q> underlying;
    private TypeMirrorConverter<Q> typeMirrorConverter;
    private QualifiedTypeFactoryAdapter<Q> typeFactory;

    public CheckerAdapter(Checker<Q> underlying) {
        this.underlying = underlying;
        underlying.setAdapter(this);
    }

    public TypeMirrorConverter<Q> getTypeMirrorConverter() {
        if (this.typeMirrorConverter == null) {
            this.typeMirrorConverter = new TypeMirrorConverter(this.getProcessingEnvironment(), this);
        }
        return this.typeMirrorConverter;
    }

    public QualifiedTypeFactoryAdapter<Q> getTypeFactory() {
        if (this.typeFactory == null) {
            this.typeFactory = this.createTypeFactory();
            this.typeFactory.doPostInit();
        }
        return this.typeFactory;
    }

    private QualifiedTypeFactoryAdapter<Q> createTypeFactory() {
        QualifiedTypeFactory<Q> underlyingFactory = this.underlying.getTypeFactory();
        final QualAnnotationFormatterAdapter formatterAdapter = new QualAnnotationFormatterAdapter(this.underlying.createQualifiedTypeFormatter());
        QualifiedTypeFactoryAdapter factoryAdapter = new QualifiedTypeFactoryAdapter<Q>(underlyingFactory, this){

            @Override
            protected AnnotatedTypeFormatter createAnnotatedTypeFormatter() {
                return formatterAdapter;
            }

            @Override
            protected AnnotationFormatter createAnnotationFormatter() {
                return formatterAdapter;
            }
        };
        if (underlyingFactory instanceof DefaultQualifiedTypeFactory) {
            DefaultQualifiedTypeFactory defaultFactory = (DefaultQualifiedTypeFactory)underlyingFactory;
            defaultFactory.setAdapter(factoryAdapter);
        }
        return factoryAdapter;
    }

    @Override
    protected BaseTypeVisitor<?> createSourceVisitor() {
        return new BaseTypeVisitor<QualifiedTypeFactoryAdapter<Q>>(this){

            @Override
            protected QualifiedTypeFactoryAdapter<Q> createTypeFactory() {
                return CheckerAdapter.this.getTypeFactory();
            }
        };
    }

    public Checker<Q> getUnderlying() {
        return this.underlying;
    }

    public void setupDefaults(QualifierDefaults defaults) {
        defaults.addCheckedCodeDefault(this.getTypeMirrorConverter().getAnnotation(this.underlying.getTypeFactory().getQualifierHierarchy().getBottom()), TypeUseLocation.IMPLICIT_LOWER_BOUND);
        defaults.addCheckedCodeDefault(this.getTypeMirrorConverter().getAnnotation(this.underlying.getTypeFactory().getQualifierHierarchy().getTop()), TypeUseLocation.LOCAL_VARIABLE);
    }

    protected class QualAnnotationFormatterAdapter
    implements AnnotatedTypeFormatter,
    AnnotationFormatter {
        private final QualifiedTypeFormatter<Q> qualifiedTypeFormatter;

        public QualAnnotationFormatterAdapter(QualifiedTypeFormatter<Q> qualifiedTypeFormatter) {
            this.qualifiedTypeFormatter = qualifiedTypeFormatter;
        }

        @Override
        public String format(AnnotatedTypeMirror type) {
            return this.qualifiedTypeFormatter.format(CheckerAdapter.this.getTypeMirrorConverter().getQualifiedType(type));
        }

        @Override
        public String format(AnnotatedTypeMirror type, boolean printVerbose) {
            return this.qualifiedTypeFormatter.format(CheckerAdapter.this.getTypeMirrorConverter().getQualifiedType(type), printVerbose);
        }

        @Override
        public String formatAnnotationString(Collection<? extends AnnotationMirror> annos, boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            for (AnnotationMirror annotationMirror : annos) {
                String result = this.qualifiedTypeFormatter.getQualFormatter().format(CheckerAdapter.this.getTypeMirrorConverter().getQualifier(annotationMirror), printInvisible);
                if (result == null) continue;
                sb.append(result);
                sb.append(" ");
            }
            return sb.toString();
        }

        @Override
        public String formatAnnotationMirror(AnnotationMirror anno) {
            return this.qualifiedTypeFormatter.getQualFormatter().format(CheckerAdapter.this.getTypeMirrorConverter().getQualifier(anno));
        }
    }
}

