/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.KeyForAnalysis;
import org.checkerframework.checker.nullness.KeyForAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.KeyForSubchecker;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class KeyForTransfer
extends CFAbstractTransfer<CFValue, CFStore, KeyForTransfer> {
    protected KeyForAnalysis analysis;
    protected KeyForSubchecker checker;
    protected final AnnotationMirror UNKNOWNKEYFOR;
    protected final AnnotationMirror KEYFOR;

    public KeyForTransfer(KeyForAnalysis analysis, KeyForSubchecker checker) {
        super(analysis);
        this.analysis = analysis;
        this.checker = checker;
        this.UNKNOWNKEYFOR = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), UnknownKeyFor.class);
        this.KEYFOR = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), KeyFor.class);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(node, in);
        String methodName = node.getTarget().getMethod().toString();
        boolean containsKey = methodName.startsWith("containsKey(");
        boolean put = methodName.startsWith("put(");
        if (containsKey || put) {
            Types types = this.analysis.getTypes();
            TypeMirror mapInterfaceTypeMirror = types.erasure(TypesUtils.typeFromClass(types, this.analysis.getEnv().getElementUtils(), Map.class));
            TypeMirror receiverType = types.erasure(node.getTarget().getReceiver().getType());
            if (types.isSubtype(receiverType, mapInterfaceTypeMirror)) {
                AnnotationMirror prevAm;
                Node receiver = node.getTarget().getReceiver();
                FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(this.checker.getAnnotationProvider(), receiver);
                String mapName = internalReceiver.toString();
                FlowExpressions.Receiver keyReceiver = FlowExpressions.internalReprOf(this.checker.getAnnotationProvider(), node.getArgument(0));
                KeyForAnnotatedTypeFactory atypeFactory = (KeyForAnnotatedTypeFactory)this.analysis.getTypeFactory();
                LinkedHashSet<String> keyForMaps = new LinkedHashSet<String>();
                keyForMaps.add(mapName);
                CFValue previousKeyValue = in.getValueOfSubNode(node.getArgument(0));
                if (previousKeyValue != null && (prevAm = previousKeyValue.getType().getAnnotationInHierarchy(this.KEYFOR)) != null && AnnotationUtils.areSameByClass(prevAm, KeyFor.class)) {
                    keyForMaps.addAll(this.getKeys(prevAm));
                }
                AnnotationMirror am = atypeFactory.createKeyForAnnotationMirrorWithValue(keyForMaps);
                if (containsKey) {
                    ConditionalTransferResult conditionalResult = (ConditionalTransferResult)result;
                    ((CFStore)conditionalResult.getThenStore()).insertValue(keyReceiver, am);
                } else if (put) {
                    result.getThenStore().insertValue(keyReceiver, am);
                    result.getElseStore().insertValue(keyReceiver, am);
                }
            }
        }
        return result;
    }

    private Set<String> getKeys(AnnotationMirror keyFor) {
        if (keyFor.getElementValues().size() == 0) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(AnnotationUtils.getElementValueArray(keyFor, "value", String.class, true));
    }
}

