/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.verifier.structurals;

import org.apache.commons.bcel6.Repository;
import org.apache.commons.bcel6.classfile.AccessFlags;
import org.apache.commons.bcel6.classfile.Constant;
import org.apache.commons.bcel6.classfile.ConstantClass;
import org.apache.commons.bcel6.classfile.ConstantDouble;
import org.apache.commons.bcel6.classfile.ConstantFieldref;
import org.apache.commons.bcel6.classfile.ConstantFloat;
import org.apache.commons.bcel6.classfile.ConstantInteger;
import org.apache.commons.bcel6.classfile.ConstantLong;
import org.apache.commons.bcel6.classfile.ConstantString;
import org.apache.commons.bcel6.classfile.Field;
import org.apache.commons.bcel6.classfile.FieldOrMethod;
import org.apache.commons.bcel6.classfile.JavaClass;
import org.apache.commons.bcel6.generic.AALOAD;
import org.apache.commons.bcel6.generic.AASTORE;
import org.apache.commons.bcel6.generic.ACONST_NULL;
import org.apache.commons.bcel6.generic.ALOAD;
import org.apache.commons.bcel6.generic.ANEWARRAY;
import org.apache.commons.bcel6.generic.ARETURN;
import org.apache.commons.bcel6.generic.ARRAYLENGTH;
import org.apache.commons.bcel6.generic.ASTORE;
import org.apache.commons.bcel6.generic.ATHROW;
import org.apache.commons.bcel6.generic.ArrayType;
import org.apache.commons.bcel6.generic.BALOAD;
import org.apache.commons.bcel6.generic.BASTORE;
import org.apache.commons.bcel6.generic.BIPUSH;
import org.apache.commons.bcel6.generic.BREAKPOINT;
import org.apache.commons.bcel6.generic.CALOAD;
import org.apache.commons.bcel6.generic.CASTORE;
import org.apache.commons.bcel6.generic.CHECKCAST;
import org.apache.commons.bcel6.generic.CPInstruction;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.D2F;
import org.apache.commons.bcel6.generic.D2I;
import org.apache.commons.bcel6.generic.D2L;
import org.apache.commons.bcel6.generic.DADD;
import org.apache.commons.bcel6.generic.DALOAD;
import org.apache.commons.bcel6.generic.DASTORE;
import org.apache.commons.bcel6.generic.DCMPG;
import org.apache.commons.bcel6.generic.DCMPL;
import org.apache.commons.bcel6.generic.DCONST;
import org.apache.commons.bcel6.generic.DDIV;
import org.apache.commons.bcel6.generic.DLOAD;
import org.apache.commons.bcel6.generic.DMUL;
import org.apache.commons.bcel6.generic.DNEG;
import org.apache.commons.bcel6.generic.DREM;
import org.apache.commons.bcel6.generic.DRETURN;
import org.apache.commons.bcel6.generic.DSTORE;
import org.apache.commons.bcel6.generic.DSUB;
import org.apache.commons.bcel6.generic.DUP;
import org.apache.commons.bcel6.generic.DUP2;
import org.apache.commons.bcel6.generic.DUP2_X1;
import org.apache.commons.bcel6.generic.DUP2_X2;
import org.apache.commons.bcel6.generic.DUP_X1;
import org.apache.commons.bcel6.generic.DUP_X2;
import org.apache.commons.bcel6.generic.EmptyVisitor;
import org.apache.commons.bcel6.generic.F2D;
import org.apache.commons.bcel6.generic.F2I;
import org.apache.commons.bcel6.generic.F2L;
import org.apache.commons.bcel6.generic.FADD;
import org.apache.commons.bcel6.generic.FALOAD;
import org.apache.commons.bcel6.generic.FASTORE;
import org.apache.commons.bcel6.generic.FCMPG;
import org.apache.commons.bcel6.generic.FCMPL;
import org.apache.commons.bcel6.generic.FCONST;
import org.apache.commons.bcel6.generic.FDIV;
import org.apache.commons.bcel6.generic.FLOAD;
import org.apache.commons.bcel6.generic.FMUL;
import org.apache.commons.bcel6.generic.FNEG;
import org.apache.commons.bcel6.generic.FREM;
import org.apache.commons.bcel6.generic.FRETURN;
import org.apache.commons.bcel6.generic.FSTORE;
import org.apache.commons.bcel6.generic.FSUB;
import org.apache.commons.bcel6.generic.FieldInstruction;
import org.apache.commons.bcel6.generic.GETFIELD;
import org.apache.commons.bcel6.generic.GETSTATIC;
import org.apache.commons.bcel6.generic.GOTO;
import org.apache.commons.bcel6.generic.GOTO_W;
import org.apache.commons.bcel6.generic.I2B;
import org.apache.commons.bcel6.generic.I2C;
import org.apache.commons.bcel6.generic.I2D;
import org.apache.commons.bcel6.generic.I2F;
import org.apache.commons.bcel6.generic.I2L;
import org.apache.commons.bcel6.generic.I2S;
import org.apache.commons.bcel6.generic.IADD;
import org.apache.commons.bcel6.generic.IALOAD;
import org.apache.commons.bcel6.generic.IAND;
import org.apache.commons.bcel6.generic.IASTORE;
import org.apache.commons.bcel6.generic.ICONST;
import org.apache.commons.bcel6.generic.IDIV;
import org.apache.commons.bcel6.generic.IFEQ;
import org.apache.commons.bcel6.generic.IFGE;
import org.apache.commons.bcel6.generic.IFGT;
import org.apache.commons.bcel6.generic.IFLE;
import org.apache.commons.bcel6.generic.IFLT;
import org.apache.commons.bcel6.generic.IFNE;
import org.apache.commons.bcel6.generic.IFNONNULL;
import org.apache.commons.bcel6.generic.IFNULL;
import org.apache.commons.bcel6.generic.IF_ACMPEQ;
import org.apache.commons.bcel6.generic.IF_ACMPNE;
import org.apache.commons.bcel6.generic.IF_ICMPEQ;
import org.apache.commons.bcel6.generic.IF_ICMPGE;
import org.apache.commons.bcel6.generic.IF_ICMPGT;
import org.apache.commons.bcel6.generic.IF_ICMPLE;
import org.apache.commons.bcel6.generic.IF_ICMPLT;
import org.apache.commons.bcel6.generic.IF_ICMPNE;
import org.apache.commons.bcel6.generic.IINC;
import org.apache.commons.bcel6.generic.ILOAD;
import org.apache.commons.bcel6.generic.IMPDEP1;
import org.apache.commons.bcel6.generic.IMPDEP2;
import org.apache.commons.bcel6.generic.IMUL;
import org.apache.commons.bcel6.generic.INEG;
import org.apache.commons.bcel6.generic.INSTANCEOF;
import org.apache.commons.bcel6.generic.INVOKEDYNAMIC;
import org.apache.commons.bcel6.generic.INVOKEINTERFACE;
import org.apache.commons.bcel6.generic.INVOKESPECIAL;
import org.apache.commons.bcel6.generic.INVOKESTATIC;
import org.apache.commons.bcel6.generic.INVOKEVIRTUAL;
import org.apache.commons.bcel6.generic.IOR;
import org.apache.commons.bcel6.generic.IREM;
import org.apache.commons.bcel6.generic.IRETURN;
import org.apache.commons.bcel6.generic.ISHL;
import org.apache.commons.bcel6.generic.ISHR;
import org.apache.commons.bcel6.generic.ISTORE;
import org.apache.commons.bcel6.generic.ISUB;
import org.apache.commons.bcel6.generic.IUSHR;
import org.apache.commons.bcel6.generic.IXOR;
import org.apache.commons.bcel6.generic.Instruction;
import org.apache.commons.bcel6.generic.InvokeInstruction;
import org.apache.commons.bcel6.generic.JSR;
import org.apache.commons.bcel6.generic.JSR_W;
import org.apache.commons.bcel6.generic.L2D;
import org.apache.commons.bcel6.generic.L2F;
import org.apache.commons.bcel6.generic.L2I;
import org.apache.commons.bcel6.generic.LADD;
import org.apache.commons.bcel6.generic.LALOAD;
import org.apache.commons.bcel6.generic.LAND;
import org.apache.commons.bcel6.generic.LASTORE;
import org.apache.commons.bcel6.generic.LCMP;
import org.apache.commons.bcel6.generic.LCONST;
import org.apache.commons.bcel6.generic.LDC;
import org.apache.commons.bcel6.generic.LDC2_W;
import org.apache.commons.bcel6.generic.LDC_W;
import org.apache.commons.bcel6.generic.LDIV;
import org.apache.commons.bcel6.generic.LLOAD;
import org.apache.commons.bcel6.generic.LMUL;
import org.apache.commons.bcel6.generic.LNEG;
import org.apache.commons.bcel6.generic.LOOKUPSWITCH;
import org.apache.commons.bcel6.generic.LOR;
import org.apache.commons.bcel6.generic.LREM;
import org.apache.commons.bcel6.generic.LRETURN;
import org.apache.commons.bcel6.generic.LSHL;
import org.apache.commons.bcel6.generic.LSHR;
import org.apache.commons.bcel6.generic.LSTORE;
import org.apache.commons.bcel6.generic.LSUB;
import org.apache.commons.bcel6.generic.LUSHR;
import org.apache.commons.bcel6.generic.LXOR;
import org.apache.commons.bcel6.generic.LoadClass;
import org.apache.commons.bcel6.generic.LoadInstruction;
import org.apache.commons.bcel6.generic.LocalVariableInstruction;
import org.apache.commons.bcel6.generic.MONITORENTER;
import org.apache.commons.bcel6.generic.MONITOREXIT;
import org.apache.commons.bcel6.generic.MULTIANEWARRAY;
import org.apache.commons.bcel6.generic.MethodGen;
import org.apache.commons.bcel6.generic.NEW;
import org.apache.commons.bcel6.generic.NEWARRAY;
import org.apache.commons.bcel6.generic.NOP;
import org.apache.commons.bcel6.generic.ObjectType;
import org.apache.commons.bcel6.generic.POP;
import org.apache.commons.bcel6.generic.POP2;
import org.apache.commons.bcel6.generic.PUTFIELD;
import org.apache.commons.bcel6.generic.PUTSTATIC;
import org.apache.commons.bcel6.generic.RET;
import org.apache.commons.bcel6.generic.RETURN;
import org.apache.commons.bcel6.generic.ReferenceType;
import org.apache.commons.bcel6.generic.ReturnInstruction;
import org.apache.commons.bcel6.generic.ReturnaddressType;
import org.apache.commons.bcel6.generic.SALOAD;
import org.apache.commons.bcel6.generic.SASTORE;
import org.apache.commons.bcel6.generic.SIPUSH;
import org.apache.commons.bcel6.generic.SWAP;
import org.apache.commons.bcel6.generic.StackConsumer;
import org.apache.commons.bcel6.generic.StackInstruction;
import org.apache.commons.bcel6.generic.StackProducer;
import org.apache.commons.bcel6.generic.StoreInstruction;
import org.apache.commons.bcel6.generic.TABLESWITCH;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.verifier.VerificationResult;
import org.apache.commons.bcel6.verifier.Verifier;
import org.apache.commons.bcel6.verifier.VerifierFactory;
import org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import org.apache.commons.bcel6.verifier.exc.StructuralCodeConstraintException;
import org.apache.commons.bcel6.verifier.structurals.Frame;
import org.apache.commons.bcel6.verifier.structurals.GenericArray;
import org.apache.commons.bcel6.verifier.structurals.LocalVariables;
import org.apache.commons.bcel6.verifier.structurals.OperandStack;
import org.apache.commons.bcel6.verifier.structurals.UninitializedObjectType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class InstConstraintVisitor
extends EmptyVisitor {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType GENERIC_ARRAY = ObjectType.getInstance(GenericArray.class.getName());
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame frame = null;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg = null;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen mg = null;

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown OperandStack stack() {
        return this.frame.getStack();
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariables locals() {
        return this.frame.getLocals();
    }

    private void constraintViolated(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction violator, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String description) {
        String fq_classname = violator.getClass().getName();
        throw new StructuralCodeConstraintException("Instruction " + fq_classname.substring(fq_classname.lastIndexOf(46) + 1) + " constraint violated: " + description);
    }

    public void setFrame(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Frame f) {
        this.frame = f;
    }

    public void setConstantPoolGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void setMethodGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen mg) {
        this.mg = mg;
    }

    private void indexOfInt(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type index) {
        if (!index.equals(Type.INT)) {
            this.constraintViolated(o, "The 'index' is not of type int but of type " + index + ".");
        }
    }

    private void referenceTypeIsInitialized(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReferenceType r) {
        if (r instanceof UninitializedObjectType) {
            this.constraintViolated(o, "Working on an uninitialized object '" + r + "'.");
        }
    }

    private void valueOfInt(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type value) {
        if (!value.equals(Type.INT)) {
            this.constraintViolated(o, "The 'value' is not of type int but of type " + value + ".");
        }
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean arrayrefOfArrayType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type arrayref) {
        if (!(arrayref instanceof ArrayType) && !arrayref.equals(Type.NULL)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array but is of type " + arrayref + ".");
        }
        return arrayref instanceof ArrayType;
    }

    private void _visitStackAccessor(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction o) {
        int produce;
        int consume = o.consumeStack(this.cpg);
        if (consume > this.stack().slotsUsed()) {
            this.constraintViolated(o, "Cannot consume " + consume + " stack slots: only " + this.stack().slotsUsed() + " slot(s) left on stack!\nStack:\n" + this.stack());
        }
        if ((produce = o.produceStack(this.cpg) - o.consumeStack(this.cpg)) + this.stack().slotsUsed() > this.stack().maxStack()) {
            this.constraintViolated(o, "Cannot produce " + produce + " stack slots: only " + (this.stack().maxStack() - this.stack().slotsUsed()) + " free stack slot(s) left.\nStack:\n" + this.stack());
        }
    }

    @Override
    public void visitLoadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LoadClass o) {
        Verifier v;
        VerificationResult vr;
        ObjectType t = o.getLoadClassType(this.cpg);
        if (t != null && (vr = (v = VerifierFactory.getVerifier(t.getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated((Instruction)((Object)o), "Class '" + o.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    @Override
    public void visitStackConsumer(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackConsumer o) {
        this._visitStackAccessor((Instruction)((Object)o));
    }

    @Override
    public void visitStackProducer(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackProducer o) {
        this._visitStackAccessor((Instruction)((Object)o));
    }

    @Override
    public void visitCPInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CPInstruction o) {
        int idx = o.getIndex();
        if (idx < 0 || idx >= this.cpg.getSize()) {
            throw new AssertionViolatedException("Huh?! Constant pool index of instruction '" + o + "' illegal? Pass 3a should have checked this!");
        }
    }

    @Override
    public void visitFieldInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldInstruction o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantFieldref)) {
            this.constraintViolated(o, "Index '" + o.getIndex() + "' should refer to a CONSTANT_Fieldref_info structure, but refers to '" + c + "'.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    @Override
    public void visitInvokeInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction o) {
    }

    @Override
    public void visitStackInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackInstruction o) {
        this._visitStackAccessor(o);
    }

    @Override
    public void visitLocalVariableInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInstruction o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
    }

    @Override
    public void visitLoadInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LoadInstruction o) {
        if (this.locals().get(o.getIndex()) == Type.UNKNOWN) {
            this.constraintViolated(o, "Read-Access on local variable " + o.getIndex() + " with unknown content.");
        }
        if (o.getType(this.cpg).getSize() == 2 && this.locals().get(o.getIndex() + 1) != Type.UNKNOWN) {
            this.constraintViolated(o, "Reading a two-locals value from local variables " + o.getIndex() + " and " + (o.getIndex() + 1) + " where the latter one is destroyed.");
        }
        if (!(o instanceof ALOAD)) {
            if (this.locals().get(o.getIndex()) != o.getType(this.cpg)) {
                this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else if (!(this.locals().get(o.getIndex()) instanceof ReferenceType)) {
            this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction expects a ReferenceType.");
        }
        if (this.stack().maxStack() - this.stack().slotsUsed() < o.getType(this.cpg).getSize()) {
            this.constraintViolated(o, "Not enough free stack slots to load a '" + o.getType(this.cpg) + "' onto the OperandStack.");
        }
    }

    @Override
    public void visitStoreInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StoreInstruction o) {
        if (this.stack().isEmpty()) {
            this.constraintViolated(o, "Cannot STORE: Stack to read from is empty.");
        }
        if (!(o instanceof ASTORE)) {
            if (this.stack().peek() != o.getType(this.cpg)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else {
            Type stacktop = this.stack().peek();
            if (!(stacktop instanceof ReferenceType) && !(stacktop instanceof ReturnaddressType)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction expects a ReferenceType or a ReturnadressType.");
            }
        }
    }

    @Override
    public void visitReturnInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReturnInstruction o) {
        Type method_type = this.mg.getType();
        if (method_type == Type.BOOLEAN || method_type == Type.BYTE || method_type == Type.SHORT || method_type == Type.CHAR) {
            method_type = Type.INT;
        }
        if (o instanceof RETURN) {
            if (method_type != Type.VOID) {
                this.constraintViolated(o, "RETURN instruction in non-void method.");
            } else {
                return;
            }
        }
        if (o instanceof ARETURN) {
            if (method_type == Type.VOID) {
                this.constraintViolated(o, "ARETURN instruction in void method.");
            }
            if (this.stack().peek() == Type.NULL) {
                return;
            }
            if (!(this.stack().peek() instanceof ReferenceType)) {
                this.constraintViolated(o, "Reference type expected on top of stack, but is: '" + this.stack().peek() + "'.");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        } else if (!method_type.equals(this.stack().peek())) {
            this.constraintViolated(o, "Current method has return type of '" + this.mg.getType() + "' expecting a '" + method_type + "' on top of the stack. But stack top is a '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitAALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref) && !(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    @Override
    public void visitAASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (!(value instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'value' is not of a ReferenceType but of type " + value + ".");
        }
        if (this.arrayrefOfArrayType(o, arrayref) && !(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    @Override
    public void visitACONST_NULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ACONST_NULL o) {
    }

    @Override
    public void visitALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ALOAD o) {
    }

    @Override
    public void visitANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ANEWARRAY o) {
        if (!this.stack().peek().equals(Type.INT)) {
            this.constraintViolated(o, "The 'count' at the stack top is not of type '" + Type.INT + "' but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitARETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ARETURN o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' at the stack top is not of a ReferenceType but of type '" + this.stack().peek() + "'.");
        }
        ReferenceType objectref = (ReferenceType)this.stack().peek();
        this.referenceTypeIsInitialized(o, objectref);
    }

    @Override
    public void visitARRAYLENGTH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ARRAYLENGTH o) {
        Type arrayref = this.stack().peek(0);
        this.arrayrefOfArrayType(o, arrayref);
    }

    @Override
    public void visitASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ASTORE o) {
        if (!(this.stack().peek() instanceof ReferenceType) && !(this.stack().peek() instanceof ReturnaddressType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType or of ReturnaddressType but of " + this.stack().peek() + ".");
        }
    }

    @Override
    public void visitATHROW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ATHROW o) {
        try {
            ObjectType throwable;
            if (!(this.stack().peek() instanceof ObjectType) && !this.stack().peek().equals(Type.NULL)) {
                this.constraintViolated(o, "The 'objectref' is not of an (initialized) ObjectType but of type " + this.stack().peek() + ".");
            }
            if (this.stack().peek().equals(Type.NULL)) {
                return;
            }
            ObjectType exc = (ObjectType)this.stack().peek();
            if (!exc.subclassOf(throwable = (ObjectType)Type.getType("Ljava/lang/Throwable;")) && !exc.equals(throwable)) {
                this.constraintViolated(o, "The 'objectref' is not of class Throwable or of a subclass of Throwable, but of '" + this.stack().peek() + "'.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitBALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    @Override
    public void visitBASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    @Override
    public void visitBIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BIPUSH o) {
    }

    @Override
    public void visitBREAKPOINT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BREAKPOINT o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as BREAKPOINT.");
    }

    @Override
    public void visitCALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.arrayrefOfArrayType(o, arrayref);
    }

    @Override
    public void visitCASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.CHAR)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of type char but to an array of type " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    @Override
    public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CHECKCAST o) {
        Constant c;
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        }
        if (!((c = this.cpg.getConstant(o.getIndex())) instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    @Override
    public void visitD2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown D2F o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitD2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown D2I o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitD2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown D2L o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DADD o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DASTORE o) {
        Type t;
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitDCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DCMPG o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DCMPL o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DCONST o) {
    }

    @Override
    public void visitDDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DDIV o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DLOAD o) {
    }

    @Override
    public void visitDMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DMUL o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DNEG o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DREM o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DRETURN o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitDSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DSTORE o) {
    }

    @Override
    public void visitDSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DSUB o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitDUP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Won't DUP type on stack top '" + this.stack().peek() + "' because it must occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitDUP_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP_X1 o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Type on stack top '" + this.stack().peek() + "' should occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "Type on stack next-to-top '" + this.stack().peek(1) + "' should occupy exactly one slot, not '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    @Override
    public void visitDUP_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP_X2 o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top type must be of size 1, but is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() == 2) {
            return;
        }
        if (this.stack().peek(2).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1 and stack next-to-top's size is 1, stack next-to-next-to-top's size must also be 1, but is: '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    @Override
    public void visitDUP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP2 o) {
        if (this.stack().peek().getSize() == 2) {
            return;
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDUP2_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP2_X1 o) {
        if (this.stack().peek().getSize() == 2) {
            if (this.stack().peek(1).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2, then stack next-to-top's size must be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            return;
        } else {
            if (this.stack().peek(1).getSize() != 1) {
                this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDUP2_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DUP2_X2 o) {
        if (this.stack().peek(0).getSize() == 2) {
            if (this.stack().peek(1).getSize() == 2) {
                return;
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2 and stack-next-to-top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        } else if (this.stack().peek(1).getSize() == 1) {
            if (this.stack().peek(2).getSize() == 2) {
                return;
            }
            if (this.stack().peek(3).getSize() == 1) {
                return;
            }
        }
        this.constraintViolated(o, "The operand sizes on the stack do not match any of the four forms of usage of this instruction.");
    }

    @Override
    public void visitF2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown F2D o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitF2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown F2I o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitF2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown F2L o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FADD o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FASTORE o) {
        Type t;
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitFCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FCMPG o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FCMPL o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FCONST o) {
    }

    @Override
    public void visitFDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FDIV o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FLOAD o) {
    }

    @Override
    public void visitFMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FMUL o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FNEG o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FREM o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitFRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FRETURN o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitFSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FSTORE o) {
    }

    @Override
    public void visitFSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FSUB o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getObjectType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldInstruction o) {
        ReferenceType rt = o.getReferenceType(this.cpg);
        if (rt instanceof ObjectType) {
            return (ObjectType)rt;
        }
        this.constraintViolated(o, "expecting ObjectType but got " + rt);
        return null;
    }

    @Override
    public void visitGETFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GETFIELD o) {
        try {
            ObjectType curr;
            ObjectType classtype;
            Type objectref = this.stack().peek();
            if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
                this.constraintViolated(o, "Stack top should be an object reference that's not an array reference, but is '" + objectref + "'.");
            }
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
            Field[] fields = jc.getFields();
            AccessFlags f = null;
            for (Field field : fields) {
                Type o_type;
                Type f_type;
                if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                f = field;
                break;
            }
            if (f == null) {
                JavaClass[] superclasses;
                block3: for (JavaClass superclass : superclasses = jc.getSuperClasses()) {
                    for (Field field : fields = superclass.getFields()) {
                        Type o_type;
                        Type f_type;
                        if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                        f = field;
                        if ((f.getAccessFlags() & 5) != 0) break block3;
                        f = null;
                        break block3;
                    }
                }
                if (f == null) {
                    throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
                }
            }
            if (f.isProtected() && ((classtype = this.getObjectType(o)).equals(curr = ObjectType.getInstance(this.mg.getClassName())) || curr.subclassOf(classtype))) {
                ObjectType objreftype;
                Type t = this.stack().peek();
                if (t == Type.NULL) {
                    return;
                }
                if (!(t instanceof ObjectType)) {
                    this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + t + "'.");
                }
                if ((objreftype = (ObjectType)t).equals(curr) || !objreftype.subclassOf(curr)) {
                    // empty if block
                }
            }
            if (f.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitGETSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GETSTATIC o) {
    }

    @Override
    public void visitGOTO(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GOTO o) {
    }

    @Override
    public void visitGOTO_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GOTO_W o) {
    }

    @Override
    public void visitI2B(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2B o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2C(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2C o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2D o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2F o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2L o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitI2S(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown I2S o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IADD o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.INT) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IAND o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IASTORE o) {
        Type t;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.INT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitICONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ICONST o) {
    }

    @Override
    public void visitIDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IDIV o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ACMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ACMPEQ o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ACMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ACMPNE o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPEQ o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPGE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPGT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPLE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPLT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIF_ICMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IF_ICMPNE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIFEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFEQ o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFGE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFGT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFLE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFLT o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFNE o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitIFNONNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFNONNULL o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitIFNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IFNULL o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    @Override
    public void visitIINC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IINC o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
        this.indexOfInt(o, this.locals().get(o.getIndex()));
    }

    @Override
    public void visitILOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ILOAD o) {
    }

    @Override
    public void visitIMPDEP1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IMPDEP1 o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP1.");
    }

    @Override
    public void visitIMPDEP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IMPDEP2 o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP2.");
    }

    @Override
    public void visitIMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IMUL o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitINEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INEG o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INSTANCEOF o) {
        Constant c;
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        }
        if (!((c = this.cpg.getConstant(o.getIndex())) instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    @Override
    public void visitINVOKEDYNAMIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEDYNAMIC o) {
        throw new RuntimeException("INVOKEDYNAMIC instruction is not supported at this time");
    }

    @Override
    public void visitINVOKEINTERFACE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEINTERFACE o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        int count = o.getCount();
        if (count == 0) {
            this.constraintViolated(o, "The 'count' argument must not be 0.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        for (int i = nargs - 1; i >= 0; --i) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                fromDesc = Type.INT;
            }
            if (fromStack.equals(fromDesc)) continue;
            if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                ReferenceType rFromStack = (ReferenceType)fromStack;
                this.referenceTypeIsInitialized(o, rFromStack);
                continue;
            }
            this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
        }
        Type objref = this.stack().peek(nargs);
        if (objref == Type.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)objref);
        if (!(objref instanceof ObjectType)) {
            if (!(objref instanceof ArrayType)) {
                this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
            } else {
                objref = GENERIC_ARRAY;
            }
        }
        int counted_count = 1;
        for (int i = 0; i < nargs; ++i) {
            counted_count += argtypes[i].getSize();
        }
        if (count != counted_count) {
            this.constraintViolated(o, "The 'count' argument should probably read '" + counted_count + "' but is '" + count + "'.");
        }
    }

    @Override
    public void visitINVOKESPECIAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKESPECIAL o) {
        try {
            String name;
            Verifier v;
            VerificationResult vr;
            Type t;
            if (o.getMethodName(this.cpg).equals("<init>") && !(this.stack().peek(o.getArgumentTypes(this.cpg).length) instanceof UninitializedObjectType)) {
                this.constraintViolated(o, "Possibly initializing object twice. A valid instruction sequence must not have an uninitialized object on the operand stack or in a local variable during a backwards branch, or in a local variable in code protected by an exception handler. Please see The Java Virtual Machine Specification, Second Edition, 4.9.4 (pages 147 and 148) for details.");
            }
            if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i = nargs - 1; i >= 0; --i) {
                Type fromStack = this.stack().peek(nargs - 1 - i);
                Type fromDesc = argtypes[i];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o, rFromStack);
                    continue;
                }
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
            Type objref = this.stack().peek(nargs);
            if (objref == Type.NULL) {
                return;
            }
            if (!(objref instanceof ReferenceType)) {
                this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
            }
            String objref_classname = null;
            if (!o.getMethodName(this.cpg).equals("<init>")) {
                this.referenceTypeIsInitialized(o, (ReferenceType)objref);
                if (!(objref instanceof ObjectType)) {
                    if (!(objref instanceof ArrayType)) {
                        this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                    } else {
                        objref = GENERIC_ARRAY;
                    }
                }
                objref_classname = ((ObjectType)objref).getClassName();
            } else {
                if (!(objref instanceof UninitializedObjectType)) {
                    this.constraintViolated(o, "Expecting an UninitializedObjectType as 'objectref' on the stack, not a '" + objref + "'. Otherwise, you couldn't invoke a method since an array has no methods (not to speak of a return address).");
                }
                objref_classname = ((UninitializedObjectType)objref).getInitialized().getClassName();
            }
            String theClass = o.getClassName(this.cpg);
            if (!Repository.instanceOf(objref_classname, theClass)) {
                this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitINVOKESTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKESTATIC o) {
        try {
            String name;
            Verifier v;
            VerificationResult vr;
            Type t = o.getType(this.cpg);
            if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i = nargs - 1; i >= 0; --i) {
                Type fromStack = this.stack().peek(nargs - 1 - i);
                Type fromDesc = argtypes[i];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o, rFromStack);
                    continue;
                }
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INVOKEVIRTUAL o) {
        try {
            String theClass;
            String objref_classname;
            String name;
            Verifier v;
            VerificationResult vr;
            Type t = o.getType(this.cpg);
            if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i = nargs - 1; i >= 0; --i) {
                Type fromStack = this.stack().peek(nargs - 1 - i);
                Type fromDesc = argtypes[i];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o, rFromStack);
                    continue;
                }
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
            Type objref = this.stack().peek(nargs);
            if (objref == Type.NULL) {
                return;
            }
            if (!(objref instanceof ReferenceType)) {
                this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)objref);
            if (!(objref instanceof ObjectType)) {
                if (!(objref instanceof ArrayType)) {
                    this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                } else {
                    objref = GENERIC_ARRAY;
                }
            }
            if (!Repository.instanceOf(objref_classname = ((ObjectType)objref).getClassName(), theClass = o.getClassName(this.cpg))) {
                this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitIOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IREM o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IRETURN o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitISHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISHL o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitISHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitISTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISTORE o) {
    }

    @Override
    public void visitISUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ISUB o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IUSHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitIXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IXOR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitJSR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JSR o) {
    }

    @Override
    public void visitJSR_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JSR_W o) {
    }

    @Override
    public void visitL2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown L2D o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitL2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown L2F o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitL2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown L2I o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LADD o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LAND o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LASTORE o) {
        Type t;
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitLCMP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LCMP o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LCONST o) {
    }

    @Override
    public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString || c instanceof ConstantClass)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float, a CONSTANT_String or a CONSTANT_Class, but is '" + c + "'.");
        }
    }

    public void visitLDC_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString || c instanceof ConstantClass)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float, a CONSTANT_String or a CONSTANT_Class, but is '" + c + "'.");
        }
    }

    @Override
    public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC2_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    @Override
    public void visitLDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDIV o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LLOAD o) {
    }

    @Override
    public void visitLMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LMUL o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LNEG o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLOOKUPSWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LOOKUPSWITCH o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LOR o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LREM o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LRETURN o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitLSHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSHL o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSTORE o) {
    }

    @Override
    public void visitLSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LSUB o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LUSHR o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitLXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LXOR o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitMONITORENTER(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MONITORENTER o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitMONITOREXIT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MONITOREXIT o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitMULTIANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MULTIANEWARRAY o) {
        int dimensions = o.getDimensions();
        for (int i = 0; i < dimensions; ++i) {
            if (this.stack().peek(i) == Type.INT) continue;
            this.constraintViolated(o, "The '" + dimensions + "' upper stack types should be 'int' but aren't.");
        }
    }

    @Override
    public void visitNEW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEW o) {
        Type t = o.getType(this.cpg);
        if (!(t instanceof ReferenceType)) {
            throw new AssertionViolatedException("NEW.getType() returning a non-reference type?!");
        }
        if (!(t instanceof ObjectType)) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + t + "'.");
        }
        ObjectType obj = (ObjectType)t;
        try {
            if (!obj.referencesClassExact()) {
                this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + obj + "'.");
            }
        }
        catch (ClassNotFoundException e) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + obj + "'. which threw " + e);
        }
    }

    @Override
    public void visitNEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEWARRAY o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    @Override
    public void visitNOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NOP o) {
    }

    @Override
    public void visitPOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown POP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top size should be 1 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitPOP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown POP2 o) {
        if (this.stack().peek().getSize() != 2) {
            this.constraintViolated(o, "Stack top size should be 2 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    @Override
    public void visitPUTFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PUTFIELD o) {
        try {
            ObjectType curr;
            ObjectType classtype;
            Type objectref = this.stack().peek(1);
            if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
                this.constraintViolated(o, "Stack next-to-top should be an object reference that's not an array reference, but is '" + objectref + "'.");
            }
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f = null;
            for (Field field : fields) {
                Type o_type;
                Type f_type;
                if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                f = field;
                break;
            }
            if (f == null) {
                throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
            }
            Type value = this.stack().peek();
            Type t = Type.getType(f.getSignature());
            Type shouldbe = t;
            if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
                shouldbe = Type.INT;
            }
            if (t instanceof ReferenceType) {
                ReferenceType rvalue = null;
                if (value instanceof ReferenceType) {
                    rvalue = (ReferenceType)value;
                    this.referenceTypeIsInitialized(o, rvalue);
                } else {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
                }
                if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
                }
            } else if (shouldbe != value) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
            }
            if (f.isProtected() && ((classtype = this.getObjectType(o)).equals(curr = ObjectType.getInstance(this.mg.getClassName())) || curr.subclassOf(classtype))) {
                ObjectType objreftype;
                Type tp = this.stack().peek(1);
                if (tp == Type.NULL) {
                    return;
                }
                if (!(tp instanceof ObjectType)) {
                    this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + tp + "'.");
                }
                if (!(objreftype = (ObjectType)tp).equals(curr) && !objreftype.subclassOf(curr)) {
                    this.constraintViolated(o, "The referenced field has the ACC_PROTECTED modifier, and it's a member of the current class or a superclass of the current class. However, the referenced object type '" + this.stack().peek() + "' is not the current class or a subclass of the current class.");
                }
            }
            if (f.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitPUTSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PUTSTATIC o) {
        try {
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f = null;
            for (Field field : fields) {
                Type o_type;
                Type f_type;
                if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                f = field;
                break;
            }
            if (f == null) {
                throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
            }
            Type value = this.stack().peek();
            Type t = Type.getType(f.getSignature());
            Type shouldbe = t;
            if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
                shouldbe = Type.INT;
            }
            if (t instanceof ReferenceType) {
                ReferenceType rvalue = null;
                if (value instanceof ReferenceType) {
                    rvalue = (ReferenceType)value;
                    this.referenceTypeIsInitialized(o, rvalue);
                } else {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
                }
                if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                    this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
                }
            } else if (shouldbe != value) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    @Override
    public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown RET o) {
        if (!(this.locals().get(o.getIndex()) instanceof ReturnaddressType)) {
            this.constraintViolated(o, "Expecting a ReturnaddressType in local variable " + o.getIndex() + ".");
        }
        if (this.locals().get(o.getIndex()) == ReturnaddressType.NO_TARGET) {
            throw new AssertionViolatedException("Oops: RET expecting a target!");
        }
    }

    @Override
    public void visitRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown RETURN o) {
        if (this.mg.getName().equals("<init>") && Frame.getThis() != null && !this.mg.getClassName().equals(Type.OBJECT.getClassName())) {
            this.constraintViolated(o, "Leaving a constructor that itself did not call a constructor.");
        }
    }

    @Override
    public void visitSALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    @Override
    public void visitSASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SASTORE o) {
        Type t;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    @Override
    public void visitSIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SIPUSH o) {
    }

    @Override
    public void visitSWAP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SWAP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "The value at the stack top is not of size '1', but of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of size '1', but of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    @Override
    public void visitTABLESWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown TABLESWITCH o) {
        this.indexOfInt(o, this.stack().peek());
    }
}

