/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.bcel6.classfile.ClassParser;
import org.apache.commons.bcel6.classfile.JavaClass;
import org.apache.commons.bcel6.util.ClassPath;
import org.apache.commons.bcel6.util.Repository;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ClassLoaderRepository
implements Repository {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassLoader loader;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass> loadedClasses = new HashMap<String, JavaClass>();

    public ClassLoaderRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) {
        return this.loadedClasses.containsKey(className) ? this.loadedClasses.get(className) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass javaClass;
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        InputStream is = this.loader.getResourceAsStream(classFile + ".class");
        if (is == null) {
            throw new ClassNotFoundException(className + " not found.");
        }
        try {
            ClassParser parser = new ClassParser(is, className);
            RC = parser.parse();
            this.storeClass(RC);
            javaClass = RC;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className + " not found: " + e, e);
            }
        }
        is.close();
        return javaClass;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath getClassPath() {
        return null;
    }
}

