/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.commons.bcel6.classfile.AnnotationEntry;
import org.apache.commons.bcel6.classfile.Annotations;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.Code;
import org.apache.commons.bcel6.classfile.CodeException;
import org.apache.commons.bcel6.classfile.ExceptionTable;
import org.apache.commons.bcel6.classfile.LineNumber;
import org.apache.commons.bcel6.classfile.LineNumberTable;
import org.apache.commons.bcel6.classfile.LocalVariable;
import org.apache.commons.bcel6.classfile.LocalVariableTable;
import org.apache.commons.bcel6.classfile.Method;
import org.apache.commons.bcel6.classfile.ParameterAnnotationEntry;
import org.apache.commons.bcel6.classfile.ParameterAnnotations;
import org.apache.commons.bcel6.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.commons.bcel6.classfile.Utility;
import org.apache.commons.bcel6.generic.AnnotationEntryGen;
import org.apache.commons.bcel6.generic.BranchInstruction;
import org.apache.commons.bcel6.generic.ClassGenException;
import org.apache.commons.bcel6.generic.CodeExceptionGen;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.FieldGenOrMethodGen;
import org.apache.commons.bcel6.generic.IINC;
import org.apache.commons.bcel6.generic.IfInstruction;
import org.apache.commons.bcel6.generic.IndexedInstruction;
import org.apache.commons.bcel6.generic.Instruction;
import org.apache.commons.bcel6.generic.InstructionHandle;
import org.apache.commons.bcel6.generic.InstructionList;
import org.apache.commons.bcel6.generic.InstructionTargeter;
import org.apache.commons.bcel6.generic.LineNumberGen;
import org.apache.commons.bcel6.generic.LocalVariableGen;
import org.apache.commons.bcel6.generic.LocalVariableInstruction;
import org.apache.commons.bcel6.generic.MethodObserver;
import org.apache.commons.bcel6.generic.NOP;
import org.apache.commons.bcel6.generic.ObjectType;
import org.apache.commons.bcel6.generic.RET;
import org.apache.commons.bcel6.generic.Select;
import org.apache.commons.bcel6.generic.TargetLostException;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.generic.TypedInstruction;
import org.apache.commons.bcel6.util.BCELComparator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class MethodGen
extends FieldGenOrMethodGen {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_names;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_locals;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_stack;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean strip_attributes;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen> variable_vec = new ArrayList<LocalVariableGen>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen> line_number_vec = new ArrayList<LineNumberGen>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen> exception_vec = new ArrayList<CodeExceptionGen>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> throws_vec = new ArrayList<String>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute> code_attrs_vec = new ArrayList<Attribute>();
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] param_annotations;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean hasParameterAnnotations = false;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean haveUnpackedParameterAnnotations = false;
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            MethodGen THIS = (MethodGen)o1;
            MethodGen THAT = (MethodGen)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            MethodGen THIS = (MethodGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObserver> observers;

    public MethodGen(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type return_type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_names, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String method_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        super(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(arg_types);
        this.setArgumentNames(arg_names);
        this.setName(method_name);
        this.setClassName(class_name);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            end = il.getEnd();
            if (!this.isStatic() && class_name != null) {
                this.addLocalVariable("this", ObjectType.getInstance(class_name), start, end);
            }
        }
        if (arg_types != null) {
            int size = arg_types.length;
            for (Type arg_type : arg_types) {
                if (Type.VOID != arg_type) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (arg_names != null) {
                if (size != arg_names.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + arg_names.length);
                }
            } else {
                arg_names = new String[size];
                for (int i = 0; i < size; ++i) {
                    arg_names[i] = "arg" + i;
                }
                this.setArgumentNames(arg_names);
            }
            if (!abstract_) {
                for (int i = 0; i < size; ++i) {
                    this.addLocalVariable(arg_names[i], arg_types[i], start, end);
                }
            }
        }
    }

    public MethodGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method m3, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        this(m3.getAccessFlags(), Type.getReturnType(m3.getSignature()), Type.getArgumentTypes(m3.getSignature()), null, m3.getName(), class_name, (m3.getAccessFlags() & 0x500) == 0 ? new InstructionList(m3.getCode().getCode()) : null, cp);
        Attribute[] attributes;
        for (Attribute attribute : attributes = m3.getAttributes()) {
            Attribute a = attribute;
            if (a instanceof Code) {
                Attribute[] c_attributes;
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                Object[] ces = c.getExceptionTable();
                if (ces != null) {
                    for (Object ce : ces) {
                        InstructionHandle end;
                        int type = ((CodeException)ce).getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            String cen = m3.getConstantPool().getConstantString(type, (byte)7);
                            c_type = ObjectType.getInstance(cen);
                        }
                        int end_pc = ((CodeException)ce).getEndPC();
                        int length = m3.getCode().getCode().length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(((CodeException)ce).getStartPC()), end, this.il.findHandle(((CodeException)ce).getHandlerPC()), c_type);
                    }
                }
                Attribute[] attributeArray = c_attributes = c.getAttributes();
                int n = attributeArray.length;
                for (int ce = 0; ce < n; ++ce) {
                    Attribute c_attribute = attributeArray[ce];
                    a = c_attribute;
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln = ((LineNumberTable)a).getLineNumberTable();
                        for (Cloneable cloneable : ln) {
                            InstructionHandle ih = this.il.findHandle(((LineNumber)cloneable).getStartPC());
                            if (ih == null) continue;
                            this.addLineNumber(ih, ((LineNumber)cloneable).getLineNumber());
                        }
                        continue;
                    }
                    if (a instanceof LocalVariableTable) {
                        LocalVariable[] lv = ((LocalVariableTable)a).getLocalVariableTable();
                        this.removeLocalVariables();
                        for (Cloneable cloneable : lv) {
                            InstructionHandle start = this.il.findHandle(((LocalVariable)cloneable).getStartPC());
                            InstructionHandle end = this.il.findHandle(((LocalVariable)cloneable).getStartPC() + ((LocalVariable)cloneable).getLength());
                            if (null == start) {
                                start = this.il.getStart();
                            }
                            if (null == end) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)cloneable).getName(), Type.getType(((LocalVariable)cloneable).getSignature()), ((LocalVariable)cloneable).getIndex(), start, end);
                        }
                        continue;
                    }
                    this.addCodeAttribute(a);
                }
                continue;
            }
            if (a instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a).getExceptionNames();
                for (String name2 : names) {
                    this.addException(name2);
                }
                continue;
            }
            if (a instanceof Annotations) {
                AnnotationEntry[] aes;
                Annotations runtimeAnnotations = (Annotations)a;
                for (AnnotationEntry element : aes = runtimeAnnotations.getAnnotationEntries()) {
                    this.addAnnotationEntry(new AnnotationEntryGen(element, cp, false));
                }
                continue;
            }
            this.addAttribute(a);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen addLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int slot, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end) {
        byte t = type.getType();
        if (t != 16) {
            LocalVariableGen l;
            int i;
            int add = type.getSize();
            if (slot + add > this.max_locals) {
                this.max_locals = slot + add;
            }
            if ((i = this.variable_vec.indexOf(l = new LocalVariableGen(slot, name, type, start, end))) >= 0) {
                this.variable_vec.set(i, l);
            } else {
                this.variable_vec.add(l);
            }
            return l;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen addLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end) {
        return this.addLocalVariable(name, type, this.max_locals, start, end);
    }

    public void removeLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen l) {
        l.dispose();
        this.variable_vec.remove(l);
    }

    public void removeLocalVariables() {
        for (LocalVariableGen lv : this.variable_vec) {
            lv.dispose();
        }
        this.variable_vec.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getLocalVariables() {
        int size = this.variable_vec.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.variable_vec.toArray(lg);
        for (int i = 0; i < size; ++i) {
            if (lg[i].getStart() == null && this.il != null) {
                lg[i].setStart(this.il.getStart());
            }
            if (lg[i].getEnd() != null || this.il == null) continue;
            lg[i].setEnd(this.il.getEnd());
        }
        if (size > 1) {
            Arrays.sort(lg, new Comparator<LocalVariableGen>(){

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int compare(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableGen o2) {
                    return o1.getIndex() - o2.getIndex();
                }
            });
        }
        return lg;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable getLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        for (int i = 0; i < size; ++i) {
            lv[i] = lg[i].getLocalVariable(cp);
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen addLineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int src_line) {
        LineNumberGen l = new LineNumberGen(ih, src_line);
        this.line_number_vec.add(l);
        return l;
    }

    public void removeLineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen l) {
        this.line_number_vec.remove(l);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lg);
        return lg;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LineNumberTable getLineNumberTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        int size = this.line_number_vec.size();
        LineNumber[] ln = new LineNumber[size];
        for (int i = 0; i < size; ++i) {
            ln[i] = this.line_number_vec.get(i).getLineNumber();
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen addExceptionHandler(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle start_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle end_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle handler_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exception_vec.add(c);
        return c;
    }

    public void removeExceptionHandler(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen c) {
        this.exception_vec.remove(c);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(cg);
        return cg;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getCodeExceptions() {
        int size = this.exception_vec.size();
        CodeException[] c_exc = new CodeException[size];
        for (int i = 0; i < size; ++i) {
            CodeExceptionGen c = this.exception_vec.get(i);
            c_exc[i] = c.getCodeException(super.getConstantPool());
        }
        return c_exc;
    }

    public void addException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name) {
        this.throws_vec.add(class_name);
    }

    public void removeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String c) {
        this.throws_vec.remove(c);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getExceptions() {
        String[] e = new String[this.throws_vec.size()];
        this.throws_vec.toArray(e);
        return e;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ExceptionTable getExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        int size = this.throws_vec.size();
        int[] ex = new int[size];
        for (int i = 0; i < size; ++i) {
            ex[i] = cp.addClass(this.throws_vec.get(i));
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.code_attrs_vec.add(a);
    }

    public void removeCodeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.code_attrs_vec.remove(a);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.clear();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getCodeAttributes() {
        Attribute[] attributes = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributes);
        return attributes;
    }

    public void addAnnotationsAsAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Attribute[] attrs;
        for (Attribute attr : attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries())) {
            this.addAttribute(attr);
        }
    }

    public void addParameterAnnotationsAsAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attrs = AnnotationEntryGen.getParameterAnnotationAttributes(cp, this.param_annotations);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                this.addAttribute(attr);
            }
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method getMethod() {
        String signature = this.getSignature();
        ConstantPoolGen _cp = super.getConstantPool();
        int name_index = _cp.addUtf8(super.getName());
        int signature_index = _cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            lvt = this.getLocalVariableTable(_cp);
            this.addCodeAttribute(lvt);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lnt = this.getLineNumberTable(_cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        for (Attribute code_attr : code_attrs) {
            attrs_len += code_attr.getLength() + 6;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributes;
            for (Attribute a : attributes = this.getAttributes()) {
                if (!(a instanceof Code)) continue;
                this.removeAttribute(a);
            }
            code = new Code(_cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.max_stack, this.max_locals, byte_code, c_exc, code_attrs, _cp.getConstantPool());
            this.addAttribute(code);
        }
        this.addAnnotationsAsAttribute(_cp);
        this.addParameterAnnotationsAsAttribute(_cp);
        ExceptionTable et = null;
        if (this.throws_vec.size() > 0) {
            et = this.getExceptionTable(_cp);
            this.addAttribute(et);
        }
        Method m3 = new Method(super.getAccessFlags(), name_index, signature_index, this.getAttributes(), _cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        return m3;
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                InstructionHandle next = ih.getNext();
                if (next != null && ih.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(ih);
                    }
                    catch (TargetLostException e) {
                        for (InstructionHandle target : e.getTargets()) {
                            for (InstructionTargeter targeter : target.getTargeters()) {
                                targeter.updateTarget(target, next);
                            }
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int m3) {
        this.max_locals = m3;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int m3) {
        this.max_stack = m3;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxStack() {
        return this.max_stack;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getClassName() {
        return this.class_name;
    }

    public void setClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name) {
        this.class_name = class_name;
    }

    public void setReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type return_type) {
        this.setType(return_type);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types) {
        this.arg_types = arg_types;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        this.arg_types[i] = type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getArgumentType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return this.arg_types[i];
    }

    public void setArgumentNames(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_names) {
        this.arg_names = arg_names;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        this.arg_names[i] = name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getArgumentName(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return this.arg_names[i];
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il) {
        this.il = il;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature() {
        return Type.getMethodSignature(super.getType(), this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(super.getConstantPool(), this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max;
            int n = max = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                for (Type arg_type : this.arg_types) {
                    max += arg_type.getSize();
                }
            }
            for (InstructionHandle ih = this.il.getStart(); ih != null; ih = ih.getNext()) {
                int index;
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof LocalVariableInstruction) && !(ins instanceof RET) && !(ins instanceof IINC) || (index = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(super.getConstantPool()).getSize()) <= max) continue;
                max = index;
            }
            this.max_locals = max;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean flag) {
        this.strip_attributes = flag;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMaxStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList il, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeExceptionGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] et) {
        BranchStack branchTargets = new BranchStack();
        for (CodeExceptionGen element : et) {
            InstructionHandle handler_pc = element.getHandlerPC();
            if (handler_pc == null) continue;
            branchTargets.push(handler_pc, 1);
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.getOpcode();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    InstructionHandle[] targets;
                    Select select = (Select)branch;
                    for (InstructionHandle target : targets = select.getTargets()) {
                        branchTargets.push(target, stackDepth);
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<MethodObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (MethodObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        String signature = Type.getMethodSignature(super.getType(), this.arg_types);
        signature = Utility.methodSignatureToString(signature, super.getName(), access, true, this.getLocalVariableTable(super.getConstantPool()));
        StringBuilder buf = new StringBuilder(signature);
        for (Attribute a : this.getAttributes()) {
            if (a instanceof Code || a instanceof ExceptionTable) continue;
            buf.append(" [").append(a).append("]");
        }
        if (this.throws_vec.size() > 0) {
            for (String throwsDescriptor : this.throws_vec) {
                buf.append("\n\t\tthrows ").append(throwsDescriptor);
            }
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Method m3 = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m3, class_name, super.getConstantPool());
        if (super.getConstantPool() != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(super.getConstantPool(), cp);
        }
        return mg;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> getAnnotationsOnParameter(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || i > this.arg_types.length) {
            return null;
        }
        return this.param_annotations[i];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        Attribute[] attrs = this.getAttributes();
        ParameterAnnotations paramAnnVisAttr = null;
        ParameterAnnotations paramAnnInvisAttr = null;
        for (Attribute attribute : attrs) {
            int j;
            if (!(attribute instanceof ParameterAnnotations)) continue;
            if (!this.hasParameterAnnotations) {
                List[] parmList = new List[this.arg_types.length];
                this.param_annotations = parmList;
                for (j = 0; j < this.arg_types.length; ++j) {
                    this.param_annotations[j] = new ArrayList<AnnotationEntryGen>();
                }
            }
            this.hasParameterAnnotations = true;
            ParameterAnnotations rpa = (ParameterAnnotations)attribute;
            if (rpa instanceof RuntimeVisibleParameterAnnotations) {
                paramAnnVisAttr = rpa;
            } else {
                paramAnnInvisAttr = rpa;
            }
            for (j = 0; j < this.arg_types.length; ++j) {
                ParameterAnnotationEntry immutableArray = rpa.getParameterAnnotationEntries()[j];
                List<AnnotationEntryGen> mutable = this.makeMutableVersion(immutableArray.getAnnotationEntries());
                this.param_annotations[j].addAll(mutable);
            }
        }
        if (paramAnnVisAttr != null) {
            this.removeAttribute(paramAnnVisAttr);
        }
        if (paramAnnInvisAttr != null) {
            this.removeAttribute(paramAnnInvisAttr);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> makeMutableVersion(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] mutableArray) {
        ArrayList<AnnotationEntryGen> result = new ArrayList<AnnotationEntryGen>();
        for (AnnotationEntry element : mutableArray) {
            result.add(new AnnotationEntryGen(element, this.getConstantPool(), false));
        }
        return result;
    }

    public void addParameterAnnotation(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int parameterIndex, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen annotation) {
        List<AnnotationEntryGen> existingAnnotations;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            List[] parmList = new List[this.arg_types.length];
            this.param_annotations = parmList;
            this.hasParameterAnnotations = true;
        }
        if ((existingAnnotations = this.param_annotations[parameterIndex]) != null) {
            existingAnnotations.add(annotation);
        } else {
            ArrayList<AnnotationEntryGen> l = new ArrayList<AnnotationEntryGen>();
            l.add(annotation);
            this.param_annotations[parameterIndex] = l;
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object obj) {
        return _cmp.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return _cmp.hashCode(this);
    }

    static final class BranchStack {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Stack<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchTarget> branchTargets = new Stack();
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Hashtable<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchTarget> visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchTarget visit(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean visited(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target;
        final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth;

        BranchTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

