/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.BootstrapMethod;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class BootstrapMethods
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrap_methods;

    public BootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethods c) {
        this(c.getNameIndex(), c.getLength(), c.getBootstrapMethods(), c.getConstantPool());
    }

    public BootstrapMethods(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrap_methods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)20, name_index, length, constant_pool);
        this.bootstrap_methods = bootstrap_methods;
    }

    BootstrapMethods(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (BootstrapMethod[])null, constant_pool);
        int num_bootstrap_methods = input.readUnsignedShort();
        this.bootstrap_methods = new BootstrapMethod[num_bootstrap_methods];
        for (int i = 0; i < num_bootstrap_methods; ++i) {
            this.bootstrap_methods[i] = new BootstrapMethod(input);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBootstrapMethods() {
        return this.bootstrap_methods;
    }

    public final void setBootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethod @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bootstrap_methods) {
        this.bootstrap_methods = bootstrap_methods;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitBootstrapMethods(this);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BootstrapMethods copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        BootstrapMethods c = (BootstrapMethods)this.clone();
        c.bootstrap_methods = new BootstrapMethod[this.bootstrap_methods.length];
        for (int i = 0; i < this.bootstrap_methods.length; ++i) {
            c.bootstrap_methods[i] = this.bootstrap_methods[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.bootstrap_methods.length);
        for (BootstrapMethod bootstrap_method : this.bootstrap_methods) {
            bootstrap_method.dump(file);
        }
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("BootstrapMethods(");
        buf.append(this.bootstrap_methods.length);
        buf.append("):\n");
        for (int i = 0; i < this.bootstrap_methods.length; ++i) {
            buf.append("  ").append(i).append(": ");
            buf.append(this.bootstrap_methods[i].toString(super.getConstantPool())).append("\n");
        }
        return buf.toString();
    }
}

