/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotations.el.InnerTypeLocation;
import annotations.io.ASTIndex;
import annotations.io.ASTPath;
import annotations.io.ASTRecord;
import annotator.find.ASTPathCriterion;
import annotator.find.CastInsertion;
import annotator.find.CloseParenthesisInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.InClassCriterion;
import annotator.find.Insertion;
import annotator.find.NewInsertion;
import annotator.find.TypedInsertion;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;
import type.ArrayType;
import type.BoundedType;
import type.DeclaredType;
import type.Type;

public class Insertions
implements Iterable<Insertion> {
    private static final Comparator<Insertion> byASTRecord = new Comparator<Insertion>(){

        @Override
        public int compare(Insertion o1, Insertion o2) {
            Criteria c1 = o1.getCriteria();
            Criteria c2 = o2.getCriteria();
            ASTPath p1 = c1.getASTPath();
            ASTPath p2 = c2.getASTPath();
            ASTRecord r1 = new ASTRecord(null, c1.getClassName(), c1.getMethodName(), c1.getFieldName(), p1 == null ? ASTPath.empty() : p1);
            ASTRecord r2 = new ASTRecord(null, c2.getClassName(), c2.getMethodName(), c2.getFieldName(), p2 == null ? ASTPath.empty() : p2);
            int c = r1.compareTo(r2);
            if (c == 0 && (c = Integer.compare(Insertions.kindLevel(o2), Insertions.kindLevel(o1))) == 0) {
                c = o1.toString().compareTo(o2.toString());
            }
            return c;
        }
    };
    private Map<String, Map<String, Set<Insertion>>> store = new HashMap<String, Map<String, Set<Insertion>>>();
    private int size = 0;

    private static int kindLevel(Insertion i) {
        switch (i.getKind()) {
            case CONSTRUCTOR: {
                return 3;
            }
            case NEW: 
            case RECEIVER: {
                return 2;
            }
            case CAST: {
                return 1;
            }
        }
        return 0;
    }

    private Pair<String, String> nameSplit(String name) {
        int i = name.indexOf(36);
        return i < 0 ? Pair.of(name, "") : Pair.of(name.substring(0, i), name.substring(i));
    }

    private void forClass(CompilationUnitTree cut, String qualifiedClassName, Set<Insertion> result) {
        Pair<String, String> pair = this.nameSplit(qualifiedClassName);
        Map<String, Set<Insertion>> map = this.store.get(pair.fst);
        if (map != null) {
            Set<Insertion> set = new TreeSet<Insertion>(byASTRecord);
            set.addAll((Collection<Insertion>)map.get(pair.snd));
            if (set != null) {
                set = this.organizeTypedInsertions(cut, qualifiedClassName, set);
                result.addAll(set);
            }
        }
    }

    public Set<Insertion> forClass(CompilationUnitTree cut, String qualifiedClassName) {
        LinkedHashSet<Insertion> set = new LinkedHashSet<Insertion>();
        this.forClass(cut, qualifiedClassName, set);
        return set;
    }

    public Set<Insertion> forOuterClass(CompilationUnitTree cut, String qualifiedOuterClassName) {
        Map<String, Set<Insertion>> map = this.store.get(qualifiedOuterClassName);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Insertion> set = new LinkedHashSet<Insertion>();
        for (String key : map.keySet()) {
            String qualifiedClassName = qualifiedOuterClassName + key;
            this.forClass(cut, qualifiedClassName, set);
        }
        return set;
    }

    public void add(Insertion ins) {
        Set<Insertion> set;
        Map<String, Set<Insertion>> map;
        InClassCriterion icc = ins.getCriteria().getInClass();
        String k1 = "";
        String k2 = "";
        if (icc != null) {
            Pair<String, String> triple = this.nameSplit(icc.className);
            k1 = (String)triple.fst;
            k2 = (String)triple.snd;
        }
        if ((map = this.store.get(k1)) == null) {
            map = new HashMap<String, Set<Insertion>>();
            this.store.put(k1, map);
        }
        if ((set = map.get(k2)) == null) {
            set = new LinkedHashSet<Insertion>();
            map.put(k2, set);
        }
        this.size -= set.size();
        set.add(ins);
        this.size += set.size();
    }

    public void addAll(Collection<? extends Insertion> c) {
        for (Insertion insertion : c) {
            this.add(insertion);
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Insertion> iterator() {
        return new Iterator<Insertion>(){
            private Iterator<Map<String, Set<Insertion>>> miter;
            private Iterator<Set<Insertion>> siter;
            private Iterator<Insertion> iiter;
            {
                this.miter = Insertions.this.store.values().iterator();
                this.siter = Collections.emptySet().iterator();
                this.iiter = Collections.emptySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.iiter.hasNext()) {
                    return true;
                }
                while (this.siter.hasNext()) {
                    this.iiter = this.siter.next().iterator();
                    if (!this.iiter.hasNext()) continue;
                    return true;
                }
                while (this.miter.hasNext()) {
                    this.siter = this.miter.next().values().iterator();
                    while (this.siter.hasNext()) {
                        this.iiter = this.siter.next().iterator();
                        if (!this.iiter.hasNext()) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Insertion next() {
                if (this.hasNext()) {
                    return this.iiter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public java.util.List<Insertion> toList() {
        ArrayList<Insertion> list = new ArrayList<Insertion>(this.size);
        for (Insertion ins : this) {
            list.add(ins);
        }
        return null;
    }

    private Set<Insertion> organizeTypedInsertions(CompilationUnitTree cut, String className, Collection<Insertion> insertions) {
        Criteria criteria;
        ASTRecordMap<TypedInsertion> map = new ASTRecordMap<TypedInsertion>();
        LinkedHashSet<Insertion> organized = new LinkedHashSet<Insertion>();
        LinkedHashSet unorganized = new LinkedHashSet();
        ArrayList<Insertion> list = new ArrayList<Insertion>();
        for (Insertion ins : insertions) {
            ASTPath temp;
            Tree node;
            if (ins.getInserted()) continue;
            criteria = ins.getCriteria();
            GenericArrayLocationCriterion galc = criteria.getGenericArrayLocation();
            ASTPath p = criteria.getASTPath();
            if (p == null || p.isEmpty() || galc != null && !galc.getLocation().isEmpty() || ins instanceof CastInsertion || ins instanceof CloseParenthesisInsertion) {
                organized.add(ins);
                continue;
            }
            ASTRecord rec = new ASTRecord(cut, criteria.getClassName(), criteria.getMethodName(), criteria.getFieldName(), p);
            ASTPath.ASTEntry entry = rec.astPath.get(-1);
            node = entry.getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type") && entry.getArgument() == 0 ? ((node = ASTIndex.getNode(cut, rec.replacePath(temp = rec.astPath.getParentPath()))) instanceof JCTree.JCNewArray ? TypeTree.fromType(((JCTree.JCNewArray)node).type) : null) : ASTIndex.getNode(cut, rec);
            if (ins instanceof TypedInsertion) {
                TypedInsertion tins = (TypedInsertion)map.get(rec);
                if (ins instanceof NewInsertion) {
                    NewInsertion nins = (NewInsertion)ins;
                    if (entry.getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type")) {
                        int a = entry.getArgument();
                        ArrayList loc0 = new ArrayList(a);
                        ASTRecord rec0 = null;
                        if (a == 0) {
                            rec0 = rec.replacePath(p.getParentPath());
                            Tree t = ASTIndex.getNode(cut, rec0);
                            if (t == null || t.toString().startsWith("{")) {
                                rec0 = null;
                            } else {
                                rec = rec0;
                                rec0 = rec.extend(Tree.Kind.NEW_ARRAY, "type", 0);
                            }
                        } else if (node != null && !nins.getInnerTypeInsertions().isEmpty()) {
                            if (node.getKind() == Tree.Kind.IDENTIFIER) {
                                node = ASTIndex.getNode(cut, rec.replacePath(p.getParentPath()));
                            }
                            if (!(node.getKind() != Tree.Kind.NEW_ARRAY && node.getKind() != Tree.Kind.ARRAY_TYPE || node.toString().startsWith("{"))) {
                                rec = rec.replacePath(p.getParentPath());
                                Collections.fill(loc0, TypeAnnotationPosition.TypePathEntry.ARRAY);
                                rec0 = rec.extend(Tree.Kind.NEW_ARRAY, "type", 0);
                            }
                        }
                        if (rec0 != null) {
                            for (Insertion inner : nins.getInnerTypeInsertions()) {
                                Criteria icriteria = inner.getCriteria();
                                GenericArrayLocationCriterion igalc = icriteria.getGenericArrayLocation();
                                if (igalc == null) continue;
                                int b = igalc.getLocation().size();
                                ArrayList<TypeAnnotationPosition.TypePathEntry> loc = new ArrayList<TypeAnnotationPosition.TypePathEntry>(a + b);
                                loc.addAll(loc0);
                                loc.addAll(igalc.getLocation());
                                ASTRecord rec1 = this.extendToInnerType(rec0, loc, node);
                                icriteria.add(new GenericArrayLocationCriterion());
                                icriteria.add(new ASTPathCriterion(rec1.astPath));
                                inner.setInserted(false);
                                organized.add(inner);
                            }
                            nins.getInnerTypeInsertions().clear();
                        }
                    }
                }
                if (tins == null) {
                    map.put(rec, (TypedInsertion)ins);
                    continue;
                }
                if (!tins.getType().equals(((TypedInsertion)ins).getType())) continue;
                this.mergeTypedInsertions(tins, (TypedInsertion)ins);
                continue;
            }
            int d = this.newArrayInnerTypeDepth(p);
            if (d > 0) {
                ASTPath temp2 = p;
                while (!(temp2.isEmpty() || node != null && node.getKind() == Tree.Kind.NEW_ARRAY)) {
                    temp2 = temp2.getParentPath();
                    node = ASTIndex.getNode(cut, rec.replacePath(temp2));
                }
                if (node == null) {
                    // empty if block
                }
                temp2 = temp2.extend(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
                if (node.toString().startsWith("{")) {
                    TypedInsertion tins = (TypedInsertion)map.get(rec.replacePath(temp2));
                    if (tins != null) {
                        tins.getInnerTypeInsertions().add(ins);
                        ins.setInserted(true);
                    }
                } else {
                    java.util.List<TypeAnnotationPosition.TypePathEntry> loc;
                    java.util.List<? extends ExpressionTree> dims = ((NewArrayTree)node).getDimensions();
                    ASTRecord irec = rec.replacePath(p.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", 0);
                    GenericArrayLocationCriterion igalc = criteria.getGenericArrayLocation();
                    for (int i = 0; i < d; ++i) {
                        irec = irec.extend(Tree.Kind.ARRAY_TYPE, "type");
                    }
                    if (igalc != null && !(loc = igalc.getLocation()).isEmpty()) {
                        try {
                            Tree dim = dims.get(d - 1);
                            irec = this.extendToInnerType(irec, loc, dim);
                            criteria.add(new ASTPathCriterion(irec.astPath));
                            criteria.add(new GenericArrayLocationCriterion());
                        }
                        catch (RuntimeException dim) {
                            // empty catch block
                        }
                    }
                }
            }
            list.add(ins);
        }
        Collections.sort(list, byASTRecord);
        unorganized.addAll(list);
        block21: for (Insertion ins : unorganized) {
            ASTPath.ASTEntry entry;
            int i;
            Tree node;
            Tree.Kind kind;
            ASTRecord rec;
            criteria = ins.getCriteria();
            String methodName = criteria.getMethodName();
            String fieldName = criteria.getFieldName();
            ASTPath ap1 = criteria.getASTPath();
            ArrayList<TypeAnnotationPosition.TypePathEntry> tpes = new ArrayList<TypeAnnotationPosition.TypePathEntry>();
            if (ap1 == null) {
                organized.add(ins);
                continue;
            }
            ArrayDeque<ASTPath> astack = new ArrayDeque<ASTPath>(ap1.size());
            ASTPath ap0 = ap1;
            do {
                astack.push(ap0);
            } while (!(ap0 = ap0.getParentPath()).isEmpty());
            do {
                ap0 = (ASTPath)astack.pop();
                kind = ap0.get(-1).getTreeKind();
                rec = new ASTRecord(cut, className, methodName, fieldName, ap0);
            } while (!astack.isEmpty() && !map.containsKey(rec));
            TypedInsertion tins = (TypedInsertion)map.get(rec);
            TreePath path = ASTIndex.getTreePath(cut, rec);
            Tree tree = node = path == null ? null : path.getLeaf();
            if (node == null && ap0.isEmpty()) {
                organized.add(ins);
                continue;
            }
            if (tins == null) {
                GenericArrayLocationCriterion galc = criteria.getGenericArrayLocation();
                if (node == null) {
                    organized.add(ins);
                    continue;
                }
                Tree t = path.getLeaf();
                switch (t.getKind()) {
                    case NEW_ARRAY: {
                        int d = 0;
                        ASTPath.ASTEntry e = ap1.get(-1);
                        java.util.List<TypeAnnotationPosition.TypePathEntry> loc = null;
                        ArrayList<Insertion> inners = new ArrayList<Insertion>();
                        Type type = TypeTree.conv(((JCTree.JCNewArray)t).type);
                        if (e.getTreeKind() == Tree.Kind.NEW_ARRAY) {
                            d += e.getArgument();
                        }
                        if (galc != null) {
                            loc = galc.getLocation();
                            int n = loc.size();
                            while (--n >= 0 && loc.get((int)n).tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                                ++d;
                            }
                            loc = n < 0 ? null : loc.subList(0, ++n);
                        }
                        criteria.add(new ASTPathCriterion(rec.astPath.getParentPath().extendNewArray(d)));
                        criteria.add(loc == null || loc.isEmpty() ? new GenericArrayLocationCriterion() : new GenericArrayLocationCriterion(new InnerTypeLocation(loc)));
                        inners.add(ins);
                        tins = new NewInsertion(type, criteria, inners);
                        tins.setInserted(true);
                        map.put(rec, tins);
                        break;
                    }
                }
                path = path.getParentPath();
            }
            if (node == null) {
                ASTPath ap = ap0;
                if (!ap.isEmpty()) {
                    while ((node = ASTIndex.getNode(cut, rec.replacePath(ap = ap.getParentPath()))) == null && !ap.isEmpty()) {
                    }
                }
                if (node == null) {
                    organized.add(ins);
                    continue;
                }
                Symbol.ClassSymbol csym = null;
                switch (tins.getKind()) {
                    case CONSTRUCTOR: {
                        if (node instanceof JCTree.JCMethodDecl) {
                            Symbol.MethodSymbol msym = ((JCTree.JCMethodDecl)node).sym;
                            csym = (Symbol.ClassSymbol)msym.owner;
                            node = TypeTree.fromType(csym.type);
                            break;
                        }
                        if (node instanceof JCTree.JCClassDecl) {
                            csym = ((JCTree.JCClassDecl)node).sym;
                            if (csym.owner instanceof Symbol.ClassSymbol) {
                                csym = (Symbol.ClassSymbol)csym.owner;
                                node = TypeTree.fromType(csym.type);
                                break;
                            }
                        }
                        throw new RuntimeException();
                    }
                    case NEW: {
                        if (node instanceof JCTree.JCNewArray) {
                            if (node.toString().startsWith("{")) {
                                node = TypeTree.fromType(((JCTree.JCNewArray)node).type);
                                break;
                            }
                            organized.add(ins);
                            continue block21;
                        }
                        throw new RuntimeException();
                    }
                    case RECEIVER: {
                        if (node instanceof JCTree.JCMethodDecl) {
                            JCTree.JCMethodDecl jmd = (JCTree.JCMethodDecl)node;
                            csym = (Symbol.ClassSymbol)jmd.sym.owner;
                            if ("<init>".equals(jmd.name.toString())) {
                                csym = (Symbol.ClassSymbol)csym.owner;
                            }
                        } else if (node instanceof JCTree.JCClassDecl) {
                            csym = ((JCTree.JCClassDecl)node).sym;
                        }
                        if (csym != null) {
                            node = TypeTree.fromType(csym.type);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            int n = ap1.size();
            int actualDepth = 0;
            int expectedDepth = 0;
            for (i = ap0.size(); i < n && ((kind = (entry = ap1.get(i)).getTreeKind()) == Tree.Kind.METHOD || kind == Tree.Kind.VARIABLE); ++i) {
            }
            while (i < n) {
                entry = ap1.get(i);
                rec = rec.extend(entry);
                kind = entry.getTreeKind();
                while (node.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                    node = ((AnnotatedTypeTree)node).getUnderlyingType();
                }
                if (expectedDepth == 0) {
                    expectedDepth = this.localDepth(node);
                }
                switch (kind) {
                    case ARRAY_TYPE: {
                        if (expectedDepth == 0 && node.getKind() == kind) {
                            node = ((ArrayTypeTree)node).getType();
                            while (--actualDepth >= 0) {
                                tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                            }
                            tpes.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    case MEMBER_SELECT: {
                        if (--expectedDepth >= 0) {
                            node = ((MemberSelectTree)node).getExpression();
                            ++actualDepth;
                            break;
                        }
                        throw new RuntimeException();
                    }
                    case NEW_ARRAY: {
                        assert (tpes.isEmpty());
                        ap0 = ap0.add(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
                        if (expectedDepth == 0 && node.getKind() == kind) {
                            if (node instanceof JCTree.JCNewArray) {
                                int arg = entry.getArgument();
                                if (arg > 0) {
                                    node = ((JCTree.JCNewArray)node).elemtype;
                                    tpes.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                                    while (--arg > 0 && node instanceof JCTree.JCArrayTypeTree) {
                                        node = ((JCTree.JCArrayTypeTree)node).elemtype;
                                        tpes.add(TypeAnnotationPosition.TypePathEntry.ARRAY);
                                    }
                                    if (arg <= 0) break;
                                    throw new RuntimeException();
                                }
                                node = TypeTree.fromType(((JCTree.JCNewArray)node).type);
                                break;
                            }
                            throw new RuntimeException("NYI");
                        }
                        throw new RuntimeException();
                    }
                    case PARAMETERIZED_TYPE: {
                        if (node.getKind() == kind) {
                            ParameterizedTypeTree ptt = (ParameterizedTypeTree)node;
                            if (entry.childSelectorIs("type")) {
                                node = ptt.getType();
                                break;
                            }
                            if (expectedDepth == 0 && entry.childSelectorIs("typeArgument")) {
                                java.util.List<? extends Tree> typeArgs = ptt.getTypeArguments();
                                int j = entry.getArgument();
                                if (j >= 0 && j < typeArgs.size()) {
                                    actualDepth = 0;
                                    expectedDepth = this.localDepth(ptt.getType());
                                    while (--expectedDepth >= 0) {
                                        tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                                    }
                                    node = typeArgs.get(j);
                                    tpes.add(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, j));
                                    break;
                                }
                            }
                        }
                        throw new RuntimeException();
                    }
                    case UNBOUNDED_WILDCARD: {
                        if (!(!ASTPath.isWildcard(node.getKind()) || expectedDepth != 0 || i >= 1 && ap1.get(i - 1).getTreeKind() == Tree.Kind.INSTANCE_OF || i >= 2 && ap1.get(i - 2).getTreeKind() == Tree.Kind.ARRAY_TYPE)) {
                            while (--actualDepth >= 0) {
                                tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
                            }
                            tpes.add(TypeAnnotationPosition.TypePathEntry.WILDCARD);
                            break;
                        }
                        throw new RuntimeException();
                    }
                    default: {
                        node = ASTIndex.getNode(cut, rec);
                    }
                }
                ++i;
            }
            while (--actualDepth >= 0) {
                tpes.add(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            organized.add(ins);
            if (tpes.isEmpty()) continue;
            criteria.add(new ASTPathCriterion(ap0));
            criteria.add(new GenericArrayLocationCriterion(new InnerTypeLocation(tpes)));
            tins.getInnerTypeInsertions().add(ins);
        }
        organized.addAll(map.values());
        return organized;
    }

    private int newArrayInnerTypeDepth(ASTPath path) {
        int d = 0;
        if (path != null) {
            while (!path.isEmpty()) {
                ASTPath.ASTEntry entry = path.get(-1);
                switch (entry.getTreeKind()) {
                    case MEMBER_SELECT: 
                    case PARAMETERIZED_TYPE: 
                    case UNBOUNDED_WILDCARD: 
                    case ANNOTATED_TYPE: {
                        d = 0;
                        break;
                    }
                    case ARRAY_TYPE: {
                        ++d;
                        break;
                    }
                    case NEW_ARRAY: {
                        if (entry.childSelectorIs("type") && entry.hasArgument()) {
                            d += entry.getArgument();
                        }
                        return d;
                    }
                    default: {
                        return 0;
                    }
                }
                path = path.getParentPath();
            }
        }
        return 0;
    }

    private ASTRecord extendToInnerType(ASTRecord rec, java.util.List<TypeAnnotationPosition.TypePathEntry> loc) {
        ASTRecord r = rec;
        Iterator<TypeAnnotationPosition.TypePathEntry> iter = loc.iterator();
        int depth = 0;
        block6: while (iter.hasNext()) {
            TypeAnnotationPosition.TypePathEntry tpe = iter.next();
            switch (tpe.tag) {
                case ARRAY: {
                    while (depth-- > 0) {
                        r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                    }
                    r = r.extend(Tree.Kind.ARRAY_TYPE, "type");
                    continue block6;
                }
                case INNER_TYPE: {
                    ++depth;
                    continue block6;
                }
                case TYPE_ARGUMENT: {
                    depth = 0;
                    r = r.extend(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", tpe.arg);
                    continue block6;
                }
                case WILDCARD: {
                    while (depth-- > 0) {
                        r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                    }
                    r = r.extend(Tree.Kind.UNBOUNDED_WILDCARD, "bound");
                    continue block6;
                }
            }
            throw new RuntimeException();
        }
        while (depth-- > 0) {
            r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
        }
        return r;
    }

    private ASTRecord extendToInnerType(ASTRecord rec, java.util.List<TypeAnnotationPosition.TypePathEntry> loc, Tree node) {
        ASTRecord r = rec;
        Tree t = node;
        Iterator<TypeAnnotationPosition.TypePathEntry> iter = loc.iterator();
        TypeAnnotationPosition.TypePathEntry tpe = iter.next();
        block8: while (true) {
            int d = this.localDepth(node);
            switch (t.getKind()) {
                case ANNOTATED_TYPE: {
                    r = r.extend(Tree.Kind.ANNOTATED_TYPE, "type");
                    t = ((JCTree.JCAnnotatedType)t).getUnderlyingType();
                    break;
                }
                case ARRAY_TYPE: {
                    if (d == 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                        ASTPath.ASTEntry e;
                        int a = 0;
                        if (!r.astPath.isEmpty() && (e = r.astPath.get(-1)).getTreeKind() == Tree.Kind.NEW_ARRAY && e.childSelectorIs("type")) {
                            a = 1 + e.getArgument();
                        }
                        r = a > 0 ? r.replacePath(r.astPath.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", a) : r.extend(Tree.Kind.ARRAY_TYPE, "type");
                        t = ((ArrayTypeTree)t).getType();
                        break;
                    }
                    throw new RuntimeException();
                }
                case MEMBER_SELECT: {
                    if (d > 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                        Tree temp = t;
                        do {
                            temp = ((JCTree.JCFieldAccess)temp).getExpression();
                            if (!iter.hasNext()) {
                                do {
                                    r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                                } while (--d > 0);
                                return r;
                            }
                            tpe = iter.next();
                            if (--d == 0) continue block8;
                        } while (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE);
                    }
                    throw new RuntimeException();
                }
                case NEW_ARRAY: {
                    if (d == 0) {
                        ASTPath.ASTEntry e;
                        if (!r.astPath.isEmpty() && (e = r.astPath.get(-1)).getTreeKind() == Tree.Kind.NEW_ARRAY) {
                            int a = 0;
                            while (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.ARRAY) {
                                ++a;
                                if (!iter.hasNext()) break;
                                tpe = iter.next();
                            }
                            r = r.replacePath(r.astPath.getParentPath()).extend(Tree.Kind.NEW_ARRAY, "type", a);
                            break;
                        }
                        r = r.extend(Tree.Kind.ARRAY_TYPE, "type");
                        t = ((JCTree.JCArrayTypeTree)t).getType();
                        break;
                    }
                    throw new RuntimeException();
                }
                case PARAMETERIZED_TYPE: {
                    if (d == 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT) {
                        r = r.extend(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", tpe.arg);
                        t = (Tree)((List)((JCTree.JCTypeApply)t).getTypeArguments()).get(tpe.arg);
                        break;
                    }
                    if (d > 0 && tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE) {
                        JCTree temp = ((JCTree.JCTypeApply)t).getType();
                        r = r.extend(Tree.Kind.PARAMETERIZED_TYPE, "type");
                        t = temp;
                        do {
                            temp = ((JCTree.JCFieldAccess)temp).getExpression();
                            if (!iter.hasNext()) {
                                do {
                                    r = r.extend(Tree.Kind.MEMBER_SELECT, "expression");
                                } while (--d > 0);
                                return r;
                            }
                            tpe = iter.next();
                            if (--d == 0) continue block8;
                        } while (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE);
                    }
                    throw new RuntimeException();
                }
                case UNBOUNDED_WILDCARD: 
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    if (tpe.tag == TypeAnnotationPosition.TypePathEntryKind.WILDCARD) {
                        t = ((JCTree.JCWildcard)t).getBound();
                        break;
                    }
                    throw new RuntimeException();
                }
                default: {
                    if (!iter.hasNext()) break;
                    throw new RuntimeException();
                }
            }
            if (!iter.hasNext()) {
                return r;
            }
            tpe = iter.next();
        }
    }

    private void mergeTypedInsertions(TypedInsertion ins0, TypedInsertion ins1) {
        this.mergeTypes(ins0.getType(), ins1.getType());
    }

    private void mergeTypes(Type t0, Type t1) {
        if (t0 == t1) {
            return;
        }
        switch (t0.getKind()) {
            case ARRAY: {
                ArrayType at0 = (ArrayType)t0;
                ArrayType at1 = (ArrayType)t1;
                this.mergeTypes(at0.getComponentType(), at1.getComponentType());
                return;
            }
            case BOUNDED: {
                BoundedType bt0 = (BoundedType)t0;
                BoundedType bt1 = (BoundedType)t1;
                if (bt0.getBoundKind() != bt1.getBoundKind()) break;
                this.mergeTypes(bt0.getBound(), bt1.getBound());
                this.mergeTypes(bt0.getType(), bt1.getType());
                return;
            }
            case DECLARED: {
                DeclaredType dt0 = (DeclaredType)t0;
                DeclaredType dt1 = (DeclaredType)t1;
                java.util.List<Type> tps0 = dt0.getTypeParameters();
                java.util.List<Type> tps1 = dt1.getTypeParameters();
                int n = tps0.size();
                if (tps1.size() != n) break;
                this.mergeTypes(dt0.getInnerType(), dt1.getInnerType());
                for (String anno : dt1.getAnnotations()) {
                    if (dt0.getAnnotations().contains(anno)) continue;
                    dt0.addAnnotation(anno);
                }
                for (int i = 0; i < n; ++i) {
                    this.mergeTypes(tps0.get(i), tps1.get(i));
                }
                return;
            }
        }
        throw new RuntimeException();
    }

    private int localDepth(Tree node) {
        Tree t = node;
        int n = 0;
        block4: while (t != null) {
            switch (t.getKind()) {
                case ANNOTATED_TYPE: {
                    t = ((AnnotatedTypeTree)t).getUnderlyingType();
                    continue block4;
                }
                case MEMBER_SELECT: {
                    if (t instanceof JCTree.JCFieldAccess) {
                        JCTree.JCFieldAccess jfa = (JCTree.JCFieldAccess)t;
                        if (jfa.sym.kind == 1) {
                            t = jfa.getExpression();
                            continue block4;
                        }
                    }
                    t = ((MemberSelectTree)t).getExpression();
                    ++n;
                    continue block4;
                }
            }
            break;
        }
        return n;
    }

    static abstract class TypeTree
    implements ExpressionTree {
        private static Map<String, TypeTag> primTags = new HashMap<String, TypeTag>();

        TypeTree() {
            primTags.put("byte", TypeTag.BYTE);
            primTags.put("char", TypeTag.CHAR);
            primTags.put("short", TypeTag.SHORT);
            primTags.put("long", TypeTag.LONG);
            primTags.put("float", TypeTag.FLOAT);
            primTags.put("int", TypeTag.INT);
            primTags.put("double", TypeTag.DOUBLE);
            primTags.put("boolean", TypeTag.BOOLEAN);
        }

        static TypeTree fromJCTree(JCTree jt) {
            if (jt != null) {
                Tree.Kind kind = jt.getKind();
                switch (kind) {
                    case ANNOTATED_TYPE: {
                        return TypeTree.fromJCTree(((JCTree.JCAnnotatedType)jt).getUnderlyingType());
                    }
                    case IDENTIFIER: {
                        return new IdenT(((JCTree.JCIdent)jt).sym.getSimpleName().toString());
                    }
                    case ARRAY_TYPE: {
                        return new ArrT(TypeTree.fromJCTree(((JCTree.JCArrayTypeTree)jt).getType()));
                    }
                    case MEMBER_SELECT: {
                        return new LocT(TypeTree.fromJCTree(((JCTree.JCFieldAccess)jt).getExpression()), ((JCTree.JCFieldAccess)jt).getIdentifier());
                    }
                    case EXTENDS_WILDCARD: 
                    case SUPER_WILDCARD: {
                        return new WildT(kind, TypeTree.fromJCTree(((JCTree.JCWildcard)jt).getBound()));
                    }
                    case UNBOUNDED_WILDCARD: {
                        return new WildT();
                    }
                    case PARAMETERIZED_TYPE: {
                        java.util.List typeArgs = ((JCTree.JCTypeApply)jt).getTypeArguments();
                        ArrayList<TypeTree> args = new ArrayList<TypeTree>(((List)typeArgs).size());
                        for (JCTree.JCExpression typeArg : typeArgs) {
                            args.add(TypeTree.fromJCTree(typeArg));
                        }
                        return new ParT(TypeTree.fromJCTree(((JCTree.JCTypeApply)jt).getType()), args);
                    }
                }
            }
            return null;
        }

        static TypeTree fromType(Type type) {
            switch (type.getKind()) {
                case ARRAY: {
                    ArrayType atype = (ArrayType)type;
                    TypeTree componentType = TypeTree.fromType(atype.getComponentType());
                    return new ArrT(componentType);
                }
                case BOUNDED: {
                    BoundedType btype = (BoundedType)type;
                    BoundedType.BoundKind bk = btype.getBoundKind();
                    String bname = btype.getType().getName();
                    TypeTree bound = TypeTree.fromType(btype.getBound());
                    return new Param(bname, bk, bound);
                }
                case DECLARED: {
                    DeclaredType dtype = (DeclaredType)type;
                    if (dtype.isWildcard()) {
                        return new WildT();
                    }
                    String dname = dtype.getName();
                    TypeTag typeTag = primTags.get(dname);
                    if (typeTag == null) {
                        IdenT base;
                        TypeTree ret = base = new IdenT(dname);
                        java.util.List<Type> params = dtype.getTypeParameters();
                        DeclaredType inner = dtype.getInnerType();
                        if (!params.isEmpty()) {
                            ArrayList<TypeTree> typeArgs = new ArrayList<TypeTree>(params.size());
                            for (Type t : params) {
                                typeArgs.add(TypeTree.fromType(t));
                            }
                            ret = new ParT(base, typeArgs);
                        }
                        return inner == null ? ret : TypeTree.meld(TypeTree.fromType(inner), ret);
                    }
                    TypeKind typeKind = typeTag.getPrimitiveTypeKind();
                    return new PrimT(typeKind);
                }
            }
            throw new RuntimeException("unknown type kind " + (Object)((Object)type.getKind()));
        }

        static TypeTree fromType(com.sun.tools.javac.code.Type type) {
            return TypeTree.fromType(TypeTree.conv(type));
        }

        static Type conv(com.sun.tools.javac.code.Type jtype) {
            Type type = null;
            switch (jtype.getKind()) {
                case ARRAY: {
                    com.sun.tools.javac.code.Type t = ((Type.ArrayType)jtype).elemtype;
                    type = new ArrayType(TypeTree.conv(t));
                    break;
                }
                case DECLARED: {
                    Type.ClassType ct;
                    com.sun.tools.javac.code.Type t = jtype;
                    DeclaredType d = null;
                    do {
                        DeclaredType d0 = d;
                        ct = (Type.ClassType)t;
                        d = new DeclaredType(ct.tsym.name.toString());
                        d.setInnerType(d0);
                        d0 = d;
                        for (com.sun.tools.javac.code.Type a : ct.getTypeArguments()) {
                            d.addTypeParameter(TypeTree.conv(a));
                        }
                    } while ((t = ct.getEnclosingType()).getKind() == TypeKind.DECLARED);
                    type = d;
                    break;
                }
                case WILDCARD: {
                    BoundedType.BoundKind k;
                    Type.TypeVar t = ((Type.WildcardType)jtype).bound;
                    switch (((Type.WildcardType)jtype).kind) {
                        case EXTENDS: {
                            k = BoundedType.BoundKind.EXTENDS;
                            break;
                        }
                        case SUPER: {
                            k = BoundedType.BoundKind.SUPER;
                            break;
                        }
                        case UNBOUND: {
                            k = null;
                            type = new DeclaredType("?");
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    if (k == null) break;
                    DeclaredType d = new DeclaredType(jtype.tsym.name.toString());
                    type = new BoundedType(d, k, (DeclaredType)TypeTree.conv(t));
                    break;
                }
                case TYPEVAR: {
                    com.sun.tools.javac.code.Type t = ((Type.TypeVar)jtype).getUpperBound();
                    type = TypeTree.conv(t);
                    if (type.getKind() != Type.Kind.DECLARED) break;
                    type = new BoundedType(new DeclaredType(jtype.tsym.name.toString()), BoundedType.BoundKind.EXTENDS, (DeclaredType)type);
                    break;
                }
                case INTERSECTION: {
                    com.sun.tools.javac.code.Type t = jtype.tsym.erasure_field;
                    type = new DeclaredType(t.tsym.name.toString());
                    break;
                }
                case UNION: {
                    break;
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case LONG: 
                case SHORT: 
                case FLOAT: 
                case INT: {
                    type = new DeclaredType(jtype.tsym.name.toString());
                    break;
                }
            }
            return type;
        }

        private static TypeTree meld(TypeTree t0, TypeTree t1) {
            switch (t0.getKind()) {
                case IDENTIFIER: {
                    IdenT it = (IdenT)t0;
                    return new LocT(t1, it.getName());
                }
                case MEMBER_SELECT: {
                    LocT lt = (LocT)t0;
                    return new LocT(TypeTree.meld(lt.getExpression(), t1), lt.getIdentifier());
                }
                case PARAMETERIZED_TYPE: {
                    ParT pt = (ParT)t0;
                    return new ParT(TypeTree.meld(pt.getType(), t1), pt.getTypeArguments());
                }
            }
            throw new IllegalArgumentException("unexpected type " + t0);
        }

        static final class TypeName
        implements Name {
            private final String str;

            TypeName(String str) {
                this.str = str;
            }

            @Override
            public int length() {
                return this.str.length();
            }

            @Override
            public char charAt(int index) {
                return this.str.charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return this.str.subSequence(start, end);
            }

            @Override
            public boolean contentEquals(CharSequence cs) {
                if (cs != null) {
                    int n = this.length();
                    if (cs.length() == n) {
                        for (int i = 0; i < n; ++i) {
                            if (this.charAt(i) == cs.charAt(i)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String toString() {
                return this.str;
            }
        }

        static final class Param
        extends TypeTree
        implements TypeParameterTree {
            private final String bname;
            private final BoundedType.BoundKind bk;
            private final Tree bound;

            Param(String bname, BoundedType.BoundKind bk, TypeTree bound) {
                this.bname = bname;
                this.bk = bk;
                this.bound = bound;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.TYPE_PARAMETER;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitTypeParameter(this, data);
            }

            @Override
            public Name getName() {
                return new TypeName(this.bname);
            }

            @Override
            public java.util.List<? extends Tree> getBounds() {
                return Collections.singletonList(this.bound);
            }

            @Override
            public java.util.List<? extends AnnotationTree> getAnnotations() {
                return Collections.emptyList();
            }

            public String toString() {
                return this.bname + " " + this.bk.toString() + " " + this.bound.toString();
            }
        }

        static final class WildT
        extends TypeTree
        implements WildcardTree {
            private final TypeTree bound;
            private final Tree.Kind kind;

            WildT() {
                this(Tree.Kind.UNBOUNDED_WILDCARD, null);
            }

            WildT(TypeTree bound, BoundedType.BoundKind bk) {
                this(bk == BoundedType.BoundKind.SUPER ? Tree.Kind.SUPER_WILDCARD : Tree.Kind.EXTENDS_WILDCARD, bound);
            }

            WildT(Tree.Kind kind, TypeTree bound) {
                this.kind = kind;
                this.bound = bound;
            }

            @Override
            public Tree.Kind getKind() {
                return this.kind;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitWildcard(this, data);
            }

            @Override
            public Tree getBound() {
                return this.bound;
            }

            public String toString() {
                return "?";
            }
        }

        static final class IdenT
        extends TypeTree
        implements IdentifierTree {
            private final String name;

            IdenT(String dname) {
                this.name = dname;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.IDENTIFIER;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitIdentifier(this, data);
            }

            @Override
            public Name getName() {
                return new TypeName(this.name);
            }

            public String toString() {
                return this.name;
            }
        }

        static final class PrimT
        extends TypeTree
        implements PrimitiveTypeTree {
            private final TypeKind typeKind;

            PrimT(TypeKind typeKind) {
                this.typeKind = typeKind;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.PRIMITIVE_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitPrimitiveType(this, data);
            }

            @Override
            public TypeKind getPrimitiveTypeKind() {
                return this.typeKind;
            }

            public String toString() {
                switch (this.typeKind) {
                    case BOOLEAN: {
                        return "boolean";
                    }
                    case BYTE: {
                        return "byte";
                    }
                    case CHAR: {
                        return "char";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                    case FLOAT: {
                        return "float";
                    }
                    case INT: {
                        return "int";
                    }
                    case LONG: {
                        return "long";
                    }
                    case SHORT: {
                        return "short";
                    }
                }
                throw new IllegalArgumentException("unexpected type kind " + (Object)((Object)this.typeKind));
            }
        }

        static final class ParT
        extends TypeTree
        implements ParameterizedTypeTree {
            private final TypeTree base;
            private final java.util.List<? extends Tree> typeArgs;

            ParT(TypeTree base, java.util.List<? extends Tree> typeArgs) {
                this.base = base;
                this.typeArgs = typeArgs;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.PARAMETERIZED_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitParameterizedType(this, data);
            }

            @Override
            public TypeTree getType() {
                return this.base;
            }

            @Override
            public java.util.List<? extends Tree> getTypeArguments() {
                return this.typeArgs;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder(this.base.toString());
                String s2 = "<";
                for (Tree tree : this.typeArgs) {
                    sb.append(s2);
                    sb.append(tree.toString());
                    s2 = ", ";
                }
                sb.append('>');
                return sb.toString();
            }
        }

        static final class LocT
        extends TypeTree
        implements MemberSelectTree {
            private final TypeTree expr;
            private final Name name;

            LocT(TypeTree expr, Name name) {
                this.expr = expr;
                this.name = name;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.MEMBER_SELECT;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitMemberSelect(this, data);
            }

            @Override
            public TypeTree getExpression() {
                return this.expr;
            }

            @Override
            public Name getIdentifier() {
                return this.name;
            }

            public String toString() {
                return this.expr + "." + this.name;
            }
        }

        static final class ArrT
        extends TypeTree
        implements ArrayTypeTree {
            private final TypeTree componentType;

            ArrT(TypeTree componentType) {
                this.componentType = componentType;
            }

            @Override
            public Tree.Kind getKind() {
                return Tree.Kind.ARRAY_TYPE;
            }

            @Override
            public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
                return visitor.visitArrayType(this, data);
            }

            @Override
            public TypeTree getType() {
                return this.componentType;
            }

            public String toString() {
                return this.componentType + "[]";
            }
        }
    }

    class ASTRecordMap<E>
    implements Map<ASTRecord, E> {
        Map<ASTRecord, SortedMap<ASTPath, E>> back = new HashMap<ASTRecord, SortedMap<ASTPath, E>>();

        ASTRecordMap() {
        }

        private SortedMap<ASTPath, E> getMap(ASTRecord rec) {
            ASTRecord key = rec.replacePath(ASTPath.empty());
            SortedMap<ASTPath, E> map = this.back.get(key);
            if (map == null) {
                map = new TreeMap<ASTPath, E>();
                this.back.put(key, map);
            }
            return map;
        }

        @Override
        public int size() {
            int n = 0;
            for (SortedMap<ASTPath, E> map : this.back.values()) {
                n += map.size();
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            ASTRecord rec = (ASTRecord)key;
            SortedMap<ASTPath, E> m3 = this.getMap(rec);
            return m3 != null && m3.containsKey(rec.astPath);
        }

        @Override
        public boolean containsValue(Object value) {
            Object e = value;
            for (SortedMap<ASTPath, E> map : this.back.values()) {
                if (!map.containsValue(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        public E get(Object key) {
            ASTRecord rec = (ASTRecord)key;
            SortedMap<ASTPath, E> map = this.getMap(rec);
            return map == null ? null : (E)map.get(rec.astPath);
        }

        @Override
        public E put(ASTRecord key, E value) {
            ASTRecord rec = key;
            SortedMap<ASTPath, E> map = this.getMap(rec);
            return map == null ? null : (E)map.put(rec.astPath, value);
        }

        @Override
        public E remove(Object key) {
            ASTRecord rec = (ASTRecord)key;
            SortedMap<ASTPath, E> map = this.getMap(rec);
            return map == null ? null : (E)map.remove(rec.astPath);
        }

        @Override
        public void putAll(Map<? extends ASTRecord, ? extends E> m3) {
            for (Map.Entry<ASTRecord, E> entry : m3.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.back.clear();
        }

        @Override
        public Set<ASTRecord> keySet() {
            return this.back.keySet();
        }

        @Override
        public Collection<E> values() {
            LinkedHashSet<E> ret = new LinkedHashSet<E>();
            for (SortedMap<ASTPath, E> m3 : this.back.values()) {
                ret.addAll(m3.values());
            }
            return ret;
        }

        @Override
        public Set<Map.Entry<ASTRecord, E>> entrySet() {
            final int size = this.size();
            return new AbstractSet<Map.Entry<ASTRecord, E>>(){

                @Override
                public Iterator<Map.Entry<ASTRecord, E>> iterator() {
                    return new Iterator<Map.Entry<ASTRecord, E>>(){
                        Iterator<Map.Entry<ASTRecord, SortedMap<ASTPath, E>>> iter0;
                        Iterator<Map.Entry<ASTPath, E>> iter1;
                        ASTRecord rec;
                        {
                            this.iter0 = ASTRecordMap.this.back.entrySet().iterator();
                            this.iter1 = Collections.emptyIterator();
                            this.rec = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.iter1.hasNext()) {
                                return true;
                            }
                            while (this.iter0.hasNext()) {
                                Map.Entry entry = this.iter0.next();
                                this.rec = entry.getKey();
                                this.iter1 = entry.getValue().entrySet().iterator();
                                if (!this.iter1.hasNext()) continue;
                                return true;
                            }
                            this.iter1 = Collections.emptyIterator();
                            return false;
                        }

                        @Override
                        public Map.Entry<ASTRecord, E> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            final Map.Entry e0 = this.iter1.next();
                            return new Map.Entry<ASTRecord, E>(){
                                final ASTRecord key;
                                final E val;
                                {
                                    this.key = rec.replacePath((ASTPath)e0.getKey());
                                    this.val = e0.getValue();
                                }

                                @Override
                                public ASTRecord getKey() {
                                    return this.key;
                                }

                                @Override
                                public E getValue() {
                                    return this.val;
                                }

                                @Override
                                public E setValue(E value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }
    }
}

