/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.constraint;

import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.framework.util.typeinference.constraint.A2F;
import org.checkerframework.framework.util.typeinference.constraint.AFConstraint;

abstract class AFReducingVisitor
extends AbstractAtmComboVisitor<Void, Set<AFConstraint>> {
    public final Class<? extends AFConstraint> reducerType;
    public final AnnotatedTypeFactory typeFactory;

    public AFReducingVisitor(Class<? extends AFConstraint> reducerType, AnnotatedTypeFactory typeFactory) {
        this.reducerType = reducerType;
        this.typeFactory = typeFactory;
    }

    public abstract AFConstraint makeConstraint(AnnotatedTypeMirror var1, AnnotatedTypeMirror var2);

    public abstract AFConstraint makeInverseConstraint(AnnotatedTypeMirror var1, AnnotatedTypeMirror var2);

    public abstract AFConstraint makeEqualityConstraint(AnnotatedTypeMirror var1, AnnotatedTypeMirror var2);

    public void addConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, Set<AFConstraint> constraints) {
        constraints.add(this.makeConstraint(subtype, supertype));
    }

    public void addInverseConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, Set<AFConstraint> constraints) {
        constraints.add(this.makeInverseConstraint(subtype, supertype));
    }

    public void addEqualityConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, Set<AFConstraint> constraints) {
        constraints.add(this.makeEqualityConstraint(subtype, supertype));
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, Set<AFConstraint> constraints) {
        return "Unexpected " + this.reducerType.getSimpleName() + " + Combination:\bsubtype=" + subtype + "\nsupertype=" + supertype + "\nconstraints=[\n" + PluginUtil.join(", ", constraints) + "\n]";
    }

    @Override
    public Void visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype.getComponentType(), supertype.getComponentType(), constraints);
        return null;
    }

    @Override
    public Void visitArray_Declared(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitArray_Null(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitArray_Wildcard(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Set<AFConstraint> constraints) {
        this.visitWildcardAsSuperType(subtype, supertype, constraints);
        return null;
    }

    @Override
    public Void visitDeclared_Array(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Set<AFConstraint> constraints) {
        if (subtype.wasRaw() || supertype.wasRaw()) {
            return null;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType subAsSuper = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (subAsSuper == null) {
            return null;
        }
        List<AnnotatedTypeMirror> subTypeArgs = subAsSuper.getTypeArguments();
        List<AnnotatedTypeMirror> superTypeArgs = supertype.getTypeArguments();
        for (int i = 0; i < subTypeArgs.size(); ++i) {
            AnnotatedTypeMirror subTypeArg = subTypeArgs.get(i);
            AnnotatedTypeMirror superTypeArg = superTypeArgs.get(i);
            if (superTypeArg.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType superWc = (AnnotatedTypeMirror.AnnotatedWildcardType)superTypeArg;
                if (subTypeArg.getKind() == TypeKind.WILDCARD) {
                    AnnotatedTypeMirror.AnnotatedWildcardType subWc = (AnnotatedTypeMirror.AnnotatedWildcardType)subTypeArg;
                    this.addConstraint(subWc.getExtendsBound(), superWc.getExtendsBound(), constraints);
                    this.addInverseConstraint(superWc.getSuperBound(), subWc.getSuperBound(), constraints);
                    continue;
                }
                this.addConstraint(subTypeArg, superWc.getExtendsBound(), constraints);
                this.addInverseConstraint(superWc.getSuperBound(), subTypeArg, constraints);
                continue;
            }
            this.addEqualityConstraint(subTypeArg, superTypeArg, constraints);
        }
        return null;
    }

    @Override
    public Void visitDeclared_Intersection(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Set<AFConstraint> constraints) {
        for (AnnotatedTypeMirror annotatedTypeMirror : supertype.directSuperTypes()) {
            if (!(annotatedTypeMirror instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) || ((AnnotatedTypeMirror.AnnotatedDeclaredType)annotatedTypeMirror).getTypeArguments().size() <= 0) continue;
            this.addConstraint(subtype, supertype, constraints);
        }
        return null;
    }

    @Override
    public Void visitDeclared_Null(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitDeclared_Primitive(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitDeclared_Typevar(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype, supertype, constraints);
        return null;
    }

    @Override
    public Void visitDeclared_Union(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitDeclared_Wildcard(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Set<AFConstraint> constraints) {
        this.visitWildcardAsSuperType(subtype, supertype, constraints);
        return null;
    }

    @Override
    public Void visitIntersection_Declared(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Set<AFConstraint> constraints) {
        AnnotatedTypeMirror.AnnotatedDeclaredType subtypeAsParam = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (subtypeAsParam != null && !subtypeAsParam.equals(subtype)) {
            this.addConstraint(subtypeAsParam, supertype, constraints);
        }
        return null;
    }

    @Override
    public Void visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType argument, AnnotatedTypeMirror.AnnotatedIntersectionType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitIntersection_Null(AnnotatedTypeMirror.AnnotatedIntersectionType argument, AnnotatedTypeMirror.AnnotatedNullType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitNull_Array(AnnotatedTypeMirror.AnnotatedNullType argument, AnnotatedTypeMirror.AnnotatedArrayType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitNull_Declared(AnnotatedTypeMirror.AnnotatedNullType argument, AnnotatedTypeMirror.AnnotatedDeclaredType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitNull_Typevar(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype, supertype.getLowerBound(), constraints);
        return null;
    }

    @Override
    public Void visitNull_Wildcard(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Set<AFConstraint> constraints) {
        constraints.add(new A2F(subtype, supertype.getSuperBound()));
        return null;
    }

    @Override
    public Void visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType argument, AnnotatedTypeMirror.AnnotatedNullType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitNull_Union(AnnotatedTypeMirror.AnnotatedNullType argument, AnnotatedTypeMirror.AnnotatedUnionType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitNull_Intersection(AnnotatedTypeMirror.AnnotatedNullType argument, AnnotatedTypeMirror.AnnotatedIntersectionType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitNull_Primitive(AnnotatedTypeMirror.AnnotatedNullType argument, AnnotatedTypeMirror.AnnotatedPrimitiveType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitPrimitive_Declared(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(this.typeFactory.getBoxedType(subtype), supertype, constraints);
        return null;
    }

    @Override
    public Void visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitPrimitive_Intersection(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(this.typeFactory.getBoxedType(subtype), supertype, constraints);
        return null;
    }

    @Override
    public Void visitUnion_Declared(AnnotatedTypeMirror.AnnotatedUnionType argument, AnnotatedTypeMirror.AnnotatedDeclaredType parameter, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitTypevar_Declared(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype.getUpperBound(), supertype, constraints);
        return null;
    }

    @Override
    public Void visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Set<AFConstraint> constraints) {
        if (!AnnotatedTypes.areCorrespondingTypeVariables(this.typeFactory.getElementUtils(), subtype, supertype)) {
            this.addConstraint(subtype.getUpperBound(), supertype.getLowerBound(), constraints);
        }
        return null;
    }

    @Override
    public Void visitTypevar_Null(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype.getUpperBound(), supertype, constraints);
        return null;
    }

    @Override
    public Void visitTypevar_Wildcard(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Set<AFConstraint> constraints) {
        this.visitWildcardAsSuperType(subtype, supertype, constraints);
        return null;
    }

    @Override
    public Void visitWildcard_Array(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype.getExtendsBound(), supertype, constraints);
        return null;
    }

    @Override
    public Void visitWildcard_Declared(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype.getExtendsBound(), supertype, constraints);
        return null;
    }

    @Override
    public Void visitWildcard_Intersection(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype.getExtendsBound(), supertype, constraints);
        return null;
    }

    @Override
    public Void visitWildcard_Primitive(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, Set<AFConstraint> constraints) {
        return null;
    }

    @Override
    public Void visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype.getExtendsBound(), supertype, constraints);
        return null;
    }

    @Override
    public Void visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Set<AFConstraint> constraints) {
        this.visitWildcardAsSuperType(subtype.getExtendsBound(), supertype, constraints);
        return null;
    }

    public void visitWildcardAsSuperType(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, Set<AFConstraint> constraints) {
        this.addConstraint(subtype, supertype.getSuperBound(), constraints);
        this.addInverseConstraint(subtype, supertype.getExtendsBound(), constraints);
    }
}

