/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import annotations.Annotation;
import annotations.el.AClass;
import annotations.el.ADeclaration;
import annotations.el.AElement;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.AnnotationDef;
import annotations.el.BoundLocation;
import annotations.el.InnerTypeLocation;
import annotations.el.LocalLocation;
import annotations.io.IndexFileWriter;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.stubparser.JavaParser;
import org.checkerframework.stubparser.ast.CompilationUnit;
import org.checkerframework.stubparser.ast.ImportDeclaration;
import org.checkerframework.stubparser.ast.IndexUnit;
import org.checkerframework.stubparser.ast.PackageDeclaration;
import org.checkerframework.stubparser.ast.TypeParameter;
import org.checkerframework.stubparser.ast.body.AnnotationDeclaration;
import org.checkerframework.stubparser.ast.body.BodyDeclaration;
import org.checkerframework.stubparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.stubparser.ast.body.ConstructorDeclaration;
import org.checkerframework.stubparser.ast.body.EnumConstantDeclaration;
import org.checkerframework.stubparser.ast.body.EnumDeclaration;
import org.checkerframework.stubparser.ast.body.FieldDeclaration;
import org.checkerframework.stubparser.ast.body.InitializerDeclaration;
import org.checkerframework.stubparser.ast.body.MethodDeclaration;
import org.checkerframework.stubparser.ast.body.Parameter;
import org.checkerframework.stubparser.ast.body.TypeDeclaration;
import org.checkerframework.stubparser.ast.body.VariableDeclarator;
import org.checkerframework.stubparser.ast.expr.AnnotationExpr;
import org.checkerframework.stubparser.ast.expr.Expression;
import org.checkerframework.stubparser.ast.expr.ObjectCreationExpr;
import org.checkerframework.stubparser.ast.expr.VariableDeclarationExpr;
import org.checkerframework.stubparser.ast.stmt.BlockStmt;
import org.checkerframework.stubparser.ast.type.ClassOrInterfaceType;
import org.checkerframework.stubparser.ast.type.PrimitiveType;
import org.checkerframework.stubparser.ast.type.ReferenceType;
import org.checkerframework.stubparser.ast.type.Type;
import org.checkerframework.stubparser.ast.type.VoidType;
import org.checkerframework.stubparser.ast.type.WildcardType;
import org.checkerframework.stubparser.ast.visitor.GenericVisitorAdapter;

public class ToIndexFileConverter
extends GenericVisitorAdapter<Void, AElement> {
    private static Pattern packagePattern = Pattern.compile("\\bpackage *+((?:[^.]*+[.] *+)*+[^ ]*) *+;", 32);
    private static Pattern importPattern = Pattern.compile("\\bimport *+((?:[^.]*+[.] *+)*+[^ ]*) *+;", 32);
    private final String pkgName;
    private final List<String> imports;
    private final AScene scene;

    public ToIndexFileConverter(PackageDeclaration pkgDecl, List<ImportDeclaration> importDecls, AScene scene) {
        this.scene = scene;
        if (pkgDecl == null) {
            this.pkgName = "";
        } else {
            Matcher m3 = packagePattern.matcher(pkgDecl.toString());
            String s2 = m3.find() ? m3.group(1) : null;
            String string = this.pkgName = s2 == null ? "" : s2;
        }
        if (importDecls == null) {
            this.imports = Collections.emptyList();
        } else {
            ArrayList<String> imps = new ArrayList<String>(importDecls.size());
            for (ImportDeclaration decl : importDecls) {
                String s3;
                Matcher m4;
                if (decl.isStatic() || !(m4 = importPattern.matcher(decl.toString())).find() || (s3 = m4.group(1)) == null) continue;
                imps.add(s3);
            }
            imps.trimToSize();
            this.imports = Collections.unmodifiableList(imps);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String f0 = args[i];
                String f1 = (f0.endsWith(".astub") ? f0.substring(0, f0.length() - 5) : f0) + "jaif";
                try (FileInputStream in = new FileInputStream(f0);){
                    try (FileOutputStream out = new FileOutputStream(f1);){
                        IndexUnit iu = JavaParser.parse(in);
                        AScene scene = ToIndexFileConverter.extractScene(iu);
                        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));){
                            IndexFileWriter.write(scene, w);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                IndexUnit iu = JavaParser.parse(System.in);
                AScene scene = ToIndexFileConverter.extractScene(iu);
                try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(System.out));){
                    IndexFileWriter.write(scene, w);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static AScene extractScene(IndexUnit iu) {
        AScene scene = new AScene();
        for (CompilationUnit cu : iu.getCompilationUnits()) {
            List<TypeDeclaration> typeDecls = cu.getTypes();
            if (typeDecls == null) continue;
            List<ImportDeclaration> impDecls = cu.getImports();
            PackageDeclaration pkgDecl = cu.getPackage();
            for (TypeDeclaration typeDecl : typeDecls) {
                ToIndexFileConverter converter = new ToIndexFileConverter(pkgDecl, impDecls, scene);
                String pkgName = converter.pkgName;
                String name = typeDecl.getName();
                if (!pkgName.isEmpty()) {
                    name = pkgName + "." + name;
                }
                typeDecl.accept(converter, scene.classes.vivify(name));
            }
        }
        scene.prune();
        return scene;
    }

    private static Annotation extractAnnotation(AnnotationExpr expr) {
        String exprName = expr.toString().substring(1);
        AnnotationDef def = new AnnotationDef(exprName);
        def.setFieldTypes(Collections.emptyMap());
        return new Annotation(def, Collections.emptyMap());
    }

    @Override
    public Void visit(AnnotationDeclaration decl, AElement elem) {
        return null;
    }

    @Override
    public Void visit(ClassOrInterfaceDeclaration decl, AElement elem) {
        this.visitDecl(decl, (ADeclaration)elem);
        return (Void)super.visit(decl, elem);
    }

    @Override
    public Void visit(ConstructorDeclaration decl, AElement elem) {
        int i = 0;
        List<Parameter> params = decl.getParameters();
        List<AnnotationExpr> rcvrAnnos = decl.getReceiverAnnotations();
        BlockStmt body = decl.getBlock();
        StringBuilder sb = new StringBuilder("<init>(");
        AClass clazz = (AClass)elem;
        if (params != null) {
            for (Parameter param : params) {
                Type ptype = param.getType();
                sb.append(this.getJVML(ptype));
            }
        }
        sb.append(")V");
        AMethod method = clazz.methods.vivify(sb.toString());
        this.visitDecl(decl, method);
        if (params != null) {
            for (Parameter param : params) {
                AField field = method.parameters.vivify(i++);
                this.visitType(param.getType(), field.type);
            }
        }
        if (rcvrAnnos != null) {
            for (AnnotationExpr expr : rcvrAnnos) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                method.receiver.tlAnnotationsHere.add(anno);
            }
        }
        return body == null ? null : body.accept(this, method);
    }

    @Override
    public Void visit(EnumConstantDeclaration decl, AElement elem) {
        AField field = ((AClass)elem).fields.vivify(decl.getName());
        this.visitDecl(decl, field);
        return (Void)super.visit(decl, field);
    }

    @Override
    public Void visit(EnumDeclaration decl, AElement elem) {
        this.visitDecl(decl, (ADeclaration)elem);
        return (Void)super.visit(decl, elem);
    }

    @Override
    public Void visit(FieldDeclaration decl, AElement elem) {
        for (VariableDeclarator v : decl.getVariables()) {
            AClass clazz = (AClass)elem;
            AField field = clazz.fields.vivify(v.getId().getName());
            this.visitDecl(decl, field);
            this.visitType(decl.getType(), field.type);
        }
        return null;
    }

    @Override
    public Void visit(InitializerDeclaration decl, AElement elem) {
        BlockStmt block = decl.getBlock();
        AClass clazz = (AClass)elem;
        block.accept(this, clazz.methods.vivify(decl.isStatic() ? "<clinit>" : "<init>"));
        return null;
    }

    @Override
    public Void visit(MethodDeclaration decl, AElement elem) {
        Type type = decl.getType();
        List<Parameter> params = decl.getParameters();
        List<TypeParameter> typeParams = decl.getTypeParameters();
        List<AnnotationExpr> rcvrAnnos = decl.getReceiverAnnotations();
        BlockStmt body = decl.getBody();
        StringBuilder sb = new StringBuilder(decl.getName()).append('(');
        AClass clazz = (AClass)elem;
        if (params != null) {
            for (Parameter parameter : params) {
                Type ptype = parameter.getType();
                sb.append(this.getJVML(ptype));
            }
        }
        sb.append(')').append(this.getJVML(type));
        AMethod method = clazz.methods.vivify(sb.toString());
        this.visitDecl(decl, method);
        this.visitType(type, method.returnType);
        if (params != null) {
            int i = 0;
            for (Parameter param : params) {
                AField field = method.parameters.vivify(i++);
                this.visitType(param.getType(), field.type);
            }
        }
        if (rcvrAnnos != null) {
            for (AnnotationExpr annotationExpr : rcvrAnnos) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(annotationExpr);
                method.receiver.type.tlAnnotationsHere.add(anno);
            }
        }
        if (typeParams != null) {
            int i = 0;
            for (TypeParameter typeParam : typeParams) {
                List<ClassOrInterfaceType> bounds = typeParam.getTypeBound();
                if (bounds != null) {
                    int j = 0;
                    for (ClassOrInterfaceType bound : bounds) {
                        BoundLocation loc = new BoundLocation(i, j);
                        bound.accept(this, method.bounds.vivify(loc));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return body == null ? null : body.accept(this, method);
    }

    @Override
    public Void visit(ObjectCreationExpr expr, AElement elem) {
        ClassOrInterfaceType type = expr.getType();
        AClass clazz = this.scene.classes.vivify(type.getName());
        Expression scope = expr.getScope();
        List<Type> typeArgs = expr.getTypeArgs();
        List<Expression> args = expr.getArgs();
        List<BodyDeclaration> decls = expr.getAnonymousClassBody();
        if (scope != null) {
            scope.accept(this, elem);
        }
        if (args != null) {
            for (Expression arg : args) {
                arg.accept(this, elem);
            }
        }
        if (typeArgs != null) {
            for (Type typeArg : typeArgs) {
                typeArg.accept(this, elem);
            }
        }
        type.accept(this, clazz);
        if (decls != null) {
            for (BodyDeclaration decl : decls) {
                decl.accept(this, clazz);
            }
        }
        return null;
    }

    @Override
    public Void visit(VariableDeclarationExpr expr, AElement elem) {
        List<AnnotationExpr> annos = expr.getAnnotations();
        AMethod method = (AMethod)elem;
        int i = 0;
        for (VariableDeclarator decl : expr.getVars()) {
            LocalLocation loc = new LocalLocation(decl.getId().getName(), i);
            AField field = method.body.locals.vivify(loc);
            this.visitType(expr.getType(), field.type);
            if (annos != null) {
                for (AnnotationExpr annoExpr : annos) {
                    Annotation anno = ToIndexFileConverter.extractAnnotation(annoExpr);
                    field.tlAnnotationsHere.add(anno);
                }
            }
            ++i;
        }
        return null;
    }

    private Void visitDecl(BodyDeclaration decl, ADeclaration elem) {
        List<AnnotationExpr> annoExprs = decl.getAnnotations();
        if (annoExprs != null) {
            for (AnnotationExpr annoExpr : annoExprs) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(annoExpr);
                elem.tlAnnotationsHere.add(anno);
            }
        }
        return null;
    }

    private Void visitType(Type type, ATypeElement elem) {
        List<AnnotationExpr> exprs = type.getAnnotations();
        if (exprs != null) {
            for (AnnotationExpr expr : exprs) {
                Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                elem.tlAnnotationsHere.add(anno);
            }
        }
        ToIndexFileConverter.visitInnerTypes(type, elem);
        return null;
    }

    private static Void visitInnerTypes(Type type, ATypeElement elem) {
        return ToIndexFileConverter.visitInnerTypes(type, elem, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
    }

    private static Void visitInnerTypes(Type type, final ATypeElement elem, InnerTypeLocation loc) {
        return type.accept(new GenericVisitorAdapter<Void, InnerTypeLocation>(){

            @Override
            public Void visit(ClassOrInterfaceType type, InnerTypeLocation loc) {
                int i = 0;
                for (Type inner : type.getTypeArgs()) {
                    InnerTypeLocation ext = this.extendedTypePath(loc, 3, i++);
                    this.visitInnerType(inner, ext);
                }
                return null;
            }

            @Override
            public Void visit(ReferenceType type, InnerTypeLocation loc) {
                InnerTypeLocation ext = loc;
                int n = type.getArrayCount();
                for (int i = 0; i < n; ++i) {
                    ext = this.extendedTypePath(ext, 1, 0);
                    for (AnnotationExpr expr : type.getAnnotationsAtLevel(i)) {
                        ATypeElement typeElem = elem.innerTypes.vivify(ext);
                        Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                        typeElem.tlAnnotationsHere.add(anno);
                    }
                }
                return null;
            }

            @Override
            public Void visit(WildcardType type, InnerTypeLocation loc) {
                InnerTypeLocation ext;
                ReferenceType lower = type.getExtends();
                ReferenceType upper = type.getSuper();
                if (lower != null) {
                    ext = this.extendedTypePath(loc, 2, 0);
                    this.visitInnerType(lower, ext);
                }
                if (upper != null) {
                    ext = this.extendedTypePath(loc, 2, 0);
                    this.visitInnerType(upper, ext);
                }
                return null;
            }

            private void visitInnerType(Type type, InnerTypeLocation loc) {
                this.visitInnerType(type, loc, type.getAnnotations());
            }

            private void visitInnerType(Type type, InnerTypeLocation loc, Collection<AnnotationExpr> annos) {
                ATypeElement typeElem = elem.innerTypes.vivify(loc);
                for (AnnotationExpr expr : annos) {
                    Annotation anno = ToIndexFileConverter.extractAnnotation(expr);
                    typeElem.tlAnnotationsHere.add(anno);
                    type.accept(this, loc);
                }
            }

            private InnerTypeLocation extendedTypePath(InnerTypeLocation loc, int tag, int arg) {
                ArrayList<TypeAnnotationPosition.TypePathEntry> path = new ArrayList<TypeAnnotationPosition.TypePathEntry>(loc.location.size() + 1);
                path.addAll(loc.location);
                path.add(TypeAnnotationPosition.TypePathEntry.fromBinary(tag, arg));
                return new InnerTypeLocation(path);
            }
        }, loc);
    }

    private String getJVML(Type type) {
        return type.accept(new GenericVisitorAdapter<String, Void>(){

            @Override
            public String visit(ClassOrInterfaceType type, Void v) {
                String typeName = type.getName();
                String name = ToIndexFileConverter.this.resolve(typeName);
                if (name != null) {
                    String[] parts = name.split("\\.");
                    StringBuilder sb = new StringBuilder("L").append(parts[0]);
                    for (int i = 1; i < parts.length; ++i) {
                        sb.append('/').append(parts[i]);
                    }
                    sb.append(";");
                    return sb.toString();
                }
                return "L" + typeName + ";";
            }

            @Override
            public String visit(PrimitiveType type, Void v) {
                switch (type.getType()) {
                    case Boolean: {
                        return "Z";
                    }
                    case Byte: {
                        return "B";
                    }
                    case Char: {
                        return "C";
                    }
                    case Double: {
                        return "D";
                    }
                    case Float: {
                        return "F";
                    }
                    case Int: {
                        return "I";
                    }
                    case Long: {
                        return "J";
                    }
                    case Short: {
                        return "S";
                    }
                }
                throw new IllegalArgumentException("baseTypeName(): unknown primitive type " + type);
            }

            @Override
            public String visit(ReferenceType type, Void v) {
                String typeName = type.getType().accept(this, null);
                StringBuilder sb = new StringBuilder();
                int n = type.getArrayCount();
                while (--n >= 0) {
                    sb.append("[");
                }
                sb.append(typeName);
                return sb.toString();
            }

            @Override
            public String visit(VoidType type, Void v) {
                return "V";
            }

            @Override
            public String visit(WildcardType type, Void v) {
                return "Ljava/lang/Object;";
            }
        }, null);
    }

    private String resolve(String className) {
        String qualifiedName;
        Class<?> resolved = null;
        if (this.pkgName.isEmpty()) {
            qualifiedName = className;
            resolved = ToIndexFileConverter.loadClass(qualifiedName);
            if (resolved == null) {
                qualifiedName = "java.lang." + className;
                resolved = ToIndexFileConverter.loadClass(qualifiedName);
            }
        } else {
            qualifiedName = this.pkgName + "." + className;
            resolved = ToIndexFileConverter.loadClass(qualifiedName);
            if (resolved == null && (resolved = ToIndexFileConverter.loadClass(qualifiedName = "java.lang." + className)) == null) {
                qualifiedName = className;
                resolved = ToIndexFileConverter.loadClass(qualifiedName);
            }
        }
        if (resolved == null) {
            for (String declName : this.imports) {
                qualifiedName = ToIndexFileConverter.mergePrefix(declName, className);
                if (qualifiedName == null) continue;
                return qualifiedName;
            }
            return className;
        }
        return qualifiedName;
    }

    private static String mergePrefix(String prefix, String base) {
        if (prefix.isEmpty() || prefix.equals(base)) {
            return base;
        }
        String[] a0 = prefix.split("\\.");
        String[] a1 = base.split("\\.");
        String prefixEnd = a0[a0.length - 1];
        if ("*".equals(prefixEnd)) {
            int n = a0.length - 1;
            String[] a = Arrays.copyOf(a0, n + a1.length);
            for (int i = 0; i < a1.length; ++i) {
                a[n + i] = a1[i];
            }
            return PluginUtil.join(".", a);
        }
        int i = a0.length;
        int n = i - a1.length;
        while (--i >= n) {
            if (a1[i - n].equals(a0[i])) continue;
            return null;
        }
        return prefix;
    }

    private static Class<?> loadClass(String className) {
        if (className != null) {
            try {
                return Class.forName(className, false, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

