/*
 * Decompiled with CFR 0.152.
 */
package annotations.util;

import annotations.Annotation;
import annotations.Annotations;
import annotations.el.ABlock;
import annotations.el.AClass;
import annotations.el.ADeclaration;
import annotations.el.AElement;
import annotations.el.AExpression;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.ATypeElementWithType;
import annotations.el.AnnotationDef;
import annotations.el.DefException;
import annotations.el.ElementVisitor;
import annotations.io.IndexFileParser;
import annotations.io.IndexFileWriter;
import annotations.io.ParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class AddAnnotatedFor {
    private static AnnotationDef adAnnotatedFor;
    private static ElementVisitor<Void, Set<String>> annotatedForVisitor;

    public static void main(String[] args) throws IOException, DefException, ParseException {
        AScene scene = new AScene();
        IndexFileParser.parse(new LineNumberReader(new InputStreamReader(System.in)), scene);
        AddAnnotatedFor.addAnnotatedFor(scene);
        IndexFileWriter.write(scene, new PrintWriter(System.out));
    }

    public static void addAnnotatedFor(AScene scene) {
        for (AClass clazz : new HashSet(scene.classes.values())) {
            HashSet annotatedFor = new HashSet();
            clazz.accept(annotatedForVisitor, annotatedFor);
            clazz.tlAnnotationsHere.add(new Annotation(adAnnotatedFor, Annotations.valueFieldOnly(annotatedFor)));
        }
    }

    static {
        annotatedForVisitor = new ElementVisitor<Void, Set<String>>(){

            @Override
            public Void visitAnnotationDef(AnnotationDef el, Set<String> annotatedFor) {
                return null;
            }

            @Override
            public Void visitBlock(ABlock el, Set<String> annotatedFor) {
                for (AField e : el.locals.values()) {
                    e.accept(this, annotatedFor);
                }
                return this.visitExpression((AExpression)el, annotatedFor);
            }

            @Override
            public Void visitClass(AClass el, Set<String> annotatedFor) {
                for (AElement e : el.bounds.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.extendsImplements.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.fieldInits.values()) {
                    ((AExpression)e).accept(this, annotatedFor);
                }
                for (AElement e : el.fields.values()) {
                    ((AField)e).accept(this, annotatedFor);
                }
                for (AElement e : el.instanceInits.values()) {
                    ((ABlock)e).accept(this, annotatedFor);
                }
                for (AElement e : el.methods.values()) {
                    ((AMethod)e).accept(this, annotatedFor);
                }
                for (AElement e : el.staticInits.values()) {
                    ((ABlock)e).accept(this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            @Override
            public Void visitDeclaration(ADeclaration el, Set<String> annotatedFor) {
                for (ATypeElement e : el.insertAnnotations.values()) {
                    e.accept(this, annotatedFor);
                }
                for (ATypeElement e : el.insertTypecasts.values()) {
                    ((ATypeElementWithType)e).accept(this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            @Override
            public Void visitExpression(AExpression el, Set<String> annotatedFor) {
                for (AElement e : el.calls.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.funs.values()) {
                    ((AMethod)e).accept(this, annotatedFor);
                }
                for (AElement e : el.instanceofs.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.news.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.refs.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.typecasts.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            @Override
            public Void visitField(AField el, Set<String> annotatedFor) {
                el.init.accept(this, annotatedFor);
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            @Override
            public Void visitMethod(AMethod el, Set<String> annotatedFor) {
                el.body.accept(this, annotatedFor);
                el.receiver.accept(this, annotatedFor);
                el.returnType.accept(this, annotatedFor);
                for (AElement e : el.bounds.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                for (AElement e : el.parameters.values()) {
                    ((AField)e).accept(this, annotatedFor);
                }
                for (AElement e : el.throwsException.values()) {
                    ((ATypeElement)e).accept(this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            @Override
            public Void visitTypeElement(ATypeElement el, Set<String> annotatedFor) {
                for (ATypeElement e : el.innerTypes.values()) {
                    e.accept(this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            @Override
            public Void visitTypeElementWithType(ATypeElementWithType el, Set<String> annotatedFor) {
                return this.visitTypeElement((ATypeElement)el, annotatedFor);
            }

            @Override
            public Void visitElement(AElement el, Set<String> annotatedFor) {
                for (Annotation a : el.tlAnnotationsHere) {
                    int i;
                    String s2 = a.def().name;
                    int j = s2.indexOf(".qual.");
                    if (j <= 0 || (i = s2.lastIndexOf(46, j - 1)) <= 0 || j - i <= 1) continue;
                    annotatedFor.add(s2.substring(i + 1, j));
                }
                if (el.type != null) {
                    el.type.accept(this, annotatedFor);
                }
                return null;
            }
        };
    }
}

