/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import java.lang.ref.WeakReference;

public class WeakIdentityPair<T1, T2> {
    private final WeakReference<T1> a;
    private final WeakReference<T2> b;
    private final int hashCode;

    public WeakIdentityPair(T1 a, T2 b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException(String.format("WeakIdentityPair cannot hold null: %s %s", a, b));
        }
        this.a = new WeakReference<T1>(a);
        this.b = new WeakReference<T2>(b);
        int localHashCode = 0;
        try {
            localHashCode = a.hashCode() + b.hashCode();
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        this.hashCode = localHashCode;
    }

    public static <A, B> WeakIdentityPair<A, B> of(A a, B b) {
        return new WeakIdentityPair<A, B>(a, b);
    }

    public T1 getA() {
        return (T1)this.a.get();
    }

    public T2 getB() {
        return (T2)this.b.get();
    }

    public String toString() {
        return "<" + String.valueOf(this.a) + "," + String.valueOf(this.b) + ">";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WeakIdentityPair)) {
            return false;
        }
        WeakIdentityPair other = (WeakIdentityPair)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        T1 a = this.getA();
        T2 b = this.getB();
        T1 oa = other.getA();
        T2 ob = other.getB();
        if (a == null || b == null || oa == null || ob == null) {
            return false;
        }
        return a == oa && b == ob;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

