/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.org.apache.commons.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;

public class TimeLimitProcess
extends Process {
    private Process p;
    private long timeLimit;
    private boolean timed_out = false;
    private StringWriter cached_stdout;
    private StringWriter cached_stderr;
    private Timer timer;
    private static boolean debug = false;

    public TimeLimitProcess(Process p, long timeLimit) {
        this(p, timeLimit, false);
    }

    public TimeLimitProcess(Process p, long timeLimit, boolean cacheStdout) {
        this.p = p;
        this.timer = new Timer(true);
        this.timeLimit = timeLimit;
        if (debug) {
            System.out.printf("new timelimit process, timeLimit=%s, cacheStdout=%s%n", timeLimit, cacheStdout);
        }
        TPTimerTask tptt = new TPTimerTask(this, timeLimit);
        this.timer.schedule((TimerTask)tptt, timeLimit);
        if (cacheStdout) {
            this.cached_stdout = new StringWriter();
            this.cached_stderr = new StringWriter();
            new StdoutStreamReaderThread().start();
            new StderrStreamReaderThread().start();
        }
    }

    public boolean timed_out() {
        return this.timed_out;
    }

    public long timeout_msecs() {
        return this.timeLimit;
    }

    @Override
    public void destroy() {
        this.p.destroy();
    }

    @Override
    public int exitValue() {
        if (this.p.exitValue() == 0 && this.timed_out) {
            return 255;
        }
        return this.p.exitValue();
    }

    @Override
    public InputStream getErrorStream() {
        if (this.cached_stderr == null) {
            InputStream errorStream = this.p.getErrorStream();
            return errorStream;
        }
        String text = this.cached_stderr.toString();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes("UTF-8"));
            return is;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        if (this.cached_stdout == null) {
            InputStream inputStream = this.p.getInputStream();
            return inputStream;
        }
        return this.stringToInputStream(this.cached_stdout.toString());
    }

    private InputStream stringToInputStream(String text) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes("UTF-8"));
            return is;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.p.getOutputStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.p.waitFor();
    }

    public boolean finished() {
        try {
            this.p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException ie) {
            return false;
        }
    }

    private class StderrStreamReaderThread
    extends Thread {
        private StderrStreamReaderThread() {
        }

        @Override
        public void run() {
            try {
                IOUtils.copy(TimeLimitProcess.this.p.getErrorStream(), (Writer)TimeLimitProcess.this.cached_stderr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class StdoutStreamReaderThread
    extends Thread {
        private StdoutStreamReaderThread() {
        }

        @Override
        public void run() {
            try {
                IOUtils.copy(TimeLimitProcess.this.p.getInputStream(), (Writer)TimeLimitProcess.this.cached_stdout);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class TPTimerTask
    extends TimerTask {
        TimeLimitProcess tp;
        long timeLimit;

        public TPTimerTask(TimeLimitProcess tp, long timeLimit) {
            this.tp = tp;
            this.timeLimit = timeLimit;
        }

        @Override
        public void run() {
            block3: {
                try {
                    int exit = this.tp.p.exitValue();
                    if (debug) {
                        System.out.println();
                        System.out.println("Process exited with status " + exit);
                        System.out.println();
                    }
                }
                catch (IllegalThreadStateException ie) {
                    this.tp.p.destroy();
                    this.tp.timed_out = true;
                    if (!debug) break block3;
                    System.out.println("Terminated process after timelimit of " + this.timeLimit + " msecs expired");
                    System.out.println();
                }
            }
            this.cancel();
        }
    }
}

