/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.com.sun.javadoc.ClassDoc;
import afu.com.sun.javadoc.Doc;
import afu.com.sun.javadoc.DocErrorReporter;
import afu.com.sun.javadoc.FieldDoc;
import afu.com.sun.javadoc.RootDoc;
import afu.com.sun.javadoc.SeeTag;
import afu.com.sun.javadoc.Tag;
import afu.org.apache.commons.lang3.StringEscapeUtils;
import afu.org.apache.commons.lang3.StringUtils;
import afu.plume.Option;
import afu.plume.Options;
import afu.plume.StringBuilderDelimited;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class OptionsDoclet {
    private static String eol = System.getProperty("line.separator");
    private static final String USAGE = "Provided by Options doclet:%n-docfile <file>        Specify file into which options documentation is inserted%n-outfile <file>        Specify destination for resulting output%n-d <directory>         Destination directory for -outfile%n-i                     Edit the docfile in-place%n-format javadoc        Format output as a Javadoc comment%n-classdoc              Include 'main' class documentation in output%n-singledash            Use single dashes for long options (see plume.Options)%nSee the OptionsDoclet documentation for more details.%n";
    private static final String LIST_HELP = "<code>[+]</code> marked option can be specified multiple times";
    private String startDelim = "<!-- start options doc (DO NOT EDIT BY HAND) -->";
    private String endDelim = "<!-- end options doc -->";
    private File docFile = null;
    private File outFile = null;
    private boolean inPlace = false;
    private boolean formatJavadoc = false;
    private boolean includeClassDoc = false;
    private RootDoc root;
    private Options options;

    public OptionsDoclet(RootDoc root, Options options) {
        this.root = root;
        this.options = options;
    }

    public static boolean start(RootDoc root) {
        ArrayList<Object> objs = new ArrayList<Object>();
        for (ClassDoc doc : root.specifiedClasses()) {
            Class<?> clazz;
            if (doc.containingClass() != null) continue;
            try {
                String className = doc.qualifiedName();
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            if (OptionsDoclet.needsInstantiation(clazz)) {
                try {
                    Constructor<?> c = clazz.getDeclaredConstructor(new Class[0]);
                    c.setAccessible(true);
                    objs.add(c.newInstance(new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            objs.add(clazz);
        }
        if (objs.isEmpty()) {
            System.out.println("Error: no classes found");
            return false;
        }
        Object[] objarray = objs.toArray();
        Options options = new Options(objarray);
        if (options.getOptions().size() < 1) {
            System.out.println("Error: no @Option-annotated fields found");
            return false;
        }
        OptionsDoclet o = new OptionsDoclet(root, options);
        o.setOptions(root.options());
        o.processJavadoc();
        try {
            o.write();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-help")) {
            System.out.printf(USAGE, new Object[0]);
            return 1;
        }
        if (option.equals("-i") || option.equals("-classdoc") || option.equals("-singledash")) {
            return 1;
        }
        if (option.equals("-docfile") || option.equals("-outfile") || option.equals("-format") || option.equals("-d")) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean hasDocFile = false;
        boolean hasOutFile = false;
        boolean hasDestDir = false;
        boolean hasFormat = false;
        boolean inPlace = false;
        String docFile = null;
        String outFile = null;
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-docfile")) {
                if (hasDocFile) {
                    reporter.printError("-docfile option specified twice");
                    return false;
                }
                File f = new File(os[1]);
                if (!f.exists()) {
                    reporter.printError("-docfile file not found: " + os[1]);
                    return false;
                }
                docFile = os[1];
                hasDocFile = true;
            }
            if (opt.equals("-outfile")) {
                if (hasOutFile) {
                    reporter.printError("-outfile option specified twice");
                    return false;
                }
                if (inPlace) {
                    reporter.printError("-i and -outfile can not be used at the same time");
                    return false;
                }
                outFile = os[1];
                hasOutFile = true;
            }
            if (opt.equals("-i")) {
                if (hasOutFile) {
                    reporter.printError("-i and -outfile can not be used at the same time");
                    return false;
                }
                inPlace = true;
            }
            if (opt.equals("-format")) {
                if (hasFormat) {
                    reporter.printError("-format option specified twice");
                    return false;
                }
                if (!os[1].equals("javadoc") && !os[1].equals("html")) {
                    reporter.printError("unrecognized output format: " + os[1]);
                    return false;
                }
                hasFormat = true;
            }
            if (!opt.equals("-d")) continue;
            if (hasDestDir) {
                reporter.printError("-d specified twice");
                return false;
            }
            hasDestDir = true;
        }
        if (docFile != null && outFile != null && outFile.equals(docFile)) {
            reporter.printError("docfile must be different from outfile");
            return false;
        }
        if (inPlace && docFile == null) {
            reporter.printError("-i supplied but -docfile was not");
            return false;
        }
        return true;
    }

    public void setOptions(String[][] options) {
        String outFilename = null;
        File destDir = null;
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-docfile")) {
                this.docFile = new File(os[1]);
                continue;
            }
            if (opt.equals("-d")) {
                destDir = new File(os[1]);
                continue;
            }
            if (opt.equals("-outfile")) {
                outFilename = os[1];
                continue;
            }
            if (opt.equals("-i")) {
                this.inPlace = true;
                continue;
            }
            if (opt.equals("-format")) {
                if (!os[1].equals("javadoc")) continue;
                this.setFormatJavadoc(true);
                continue;
            }
            if (opt.equals("-classdoc")) {
                this.includeClassDoc = true;
                continue;
            }
            if (!opt.equals("-singledash")) continue;
            this.setUseSingleDash(true);
        }
        if (outFilename != null) {
            this.outFile = destDir != null ? new File(destDir, outFilename) : new File(outFilename);
        }
    }

    private static boolean needsInstantiation(Class<?> clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Option.class) || Modifier.isStatic(f.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public void write() throws Exception {
        PrintWriter out;
        String output = this.output();
        if (this.outFile != null) {
            out = new PrintWriter(new BufferedWriter(new FileWriter(this.outFile)));
        } else if (this.inPlace) {
            assert (this.docFile != null) : "@AssumeAssertion(nullness): dependent: docFile is non-null if inPlace is true";
            out = new PrintWriter(new BufferedWriter(new FileWriter(this.docFile)));
        } else {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        }
        out.println(output);
        out.flush();
        out.close();
    }

    public String output() throws Exception {
        if (this.docFile == null) {
            if (this.formatJavadoc) {
                return this.optionsToJavadoc(0);
            }
            return this.optionsToHtml();
        }
        return this.newDocFileText();
    }

    private String newDocFileText() throws Exception {
        String docline;
        StringBuilderDelimited b = new StringBuilderDelimited(eol);
        BufferedReader doc = new BufferedReader(new FileReader(this.docFile));
        boolean replacing = false;
        boolean replaced_once = false;
        while ((docline = doc.readLine()) != null) {
            if (replacing) {
                if (!docline.trim().equals(this.endDelim)) continue;
                replacing = false;
            }
            b.append(docline);
            if (replaced_once || !docline.trim().equals(this.startDelim)) continue;
            if (this.formatJavadoc) {
                b.append(this.optionsToJavadoc(docline.indexOf(42)));
            } else {
                b.append(this.optionsToHtml());
            }
            replaced_once = true;
            replacing = true;
        }
        doc.close();
        return b.toString();
    }

    public void processJavadoc() {
        for (Options.OptionInfo oi : this.options.getOptions()) {
            ClassDoc opt_doc = this.root.classNamed(oi.get_declaring_class().getName());
            if (opt_doc != null) {
                String nameWithUnderscores = oi.long_name.replace('-', '_');
                for (FieldDoc fd : opt_doc.fields()) {
                    if (!fd.name().equals(nameWithUnderscores)) continue;
                    if (fd.getRawCommentText().length() == 0) {
                        oi.jdoc = StringEscapeUtils.escapeHtml4(oi.description);
                        break;
                    }
                    if (this.formatJavadoc) {
                        oi.jdoc = fd.commentText();
                        break;
                    }
                    oi.jdoc = OptionsDoclet.javadocToHtml(fd);
                    break;
                }
            }
            if (!oi.base_type.isEnum()) continue;
            this.processEnumJavadoc(oi);
        }
    }

    private void processEnumJavadoc(Options.OptionInfo oi) {
        Enum[] constants = (Enum[])oi.base_type.getEnumConstants();
        if (constants == null) {
            return;
        }
        oi.enum_jdoc = new LinkedHashMap<String, String>();
        for (Enum constant : constants) {
            assert (oi.enum_jdoc != null) : "@AssumeAssertion(nullness): bug in flow?";
            oi.enum_jdoc.put(constant.name(), "");
        }
        ClassDoc enum_doc = this.root.classNamed(oi.base_type.getName());
        if (enum_doc == null) {
            return;
        }
        assert (oi.enum_jdoc != null) : "@AssumeAssertion(nullness): bug in flow?";
        block1: for (String name : oi.enum_jdoc.keySet()) {
            for (FieldDoc fd : enum_doc.fields()) {
                if (!fd.name().equals(name)) continue;
                if (this.formatJavadoc) {
                    oi.enum_jdoc.put(name, fd.commentText());
                    continue block1;
                }
                oi.enum_jdoc.put(name, OptionsDoclet.javadocToHtml(fd));
                continue block1;
            }
        }
    }

    public String optionsToHtml() {
        StringBuilderDelimited b = new StringBuilderDelimited(eol);
        if (this.includeClassDoc) {
            b.append(OptionsDoclet.javadocToHtml(this.root.classes()[0]));
            b.append("<p>Command line options:</p>");
        }
        b.append("<ul>");
        if (!this.options.isUsingGroups()) {
            b.append(this.optionListToHtml(this.options.getOptions(), 2));
        } else {
            for (Options.OptionGroupInfo gi : this.options.getOptionGroups()) {
                if (!gi.any_publicized()) continue;
                b.append("  <li id=\"optiongroup:" + gi.name.replace(" ", "-").replace("/", "-") + "\">" + gi.name);
                b.append("    <ul>");
                b.append(this.optionListToHtml(gi.optionList, 6));
                b.append("    </ul>");
                b.append("  </li>");
            }
        }
        b.append("</ul>");
        for (Options.OptionInfo oi : this.options.getOptions()) {
            if (oi.list == null || oi.unpublicized) continue;
            b.append(LIST_HELP);
            break;
        }
        return b.toString();
    }

    public String optionsToJavadoc(int padding) {
        StringBuilderDelimited b = new StringBuilderDelimited(eol);
        Scanner s2 = new Scanner(this.optionsToHtml());
        while (s2.hasNextLine()) {
            StringBuilder bb = new StringBuilder();
            bb.append(StringUtils.repeat(" ", padding)).append("* ").append(s2.nextLine());
            b.append(bb);
        }
        return b.toString();
    }

    private String optionListToHtml(List<Options.OptionInfo> opt_list, int padding) {
        StringBuilderDelimited b = new StringBuilderDelimited(eol);
        for (Options.OptionInfo oi : opt_list) {
            if (oi.unpublicized) continue;
            StringBuilder bb = new StringBuilder();
            String optHtml = this.optionToHtml(oi);
            bb.append(StringUtils.repeat(" ", padding));
            bb.append("<li id=\"option:" + oi.long_name + "\">").append(optHtml).append("</li>");
            b.append(bb);
        }
        return b.toString();
    }

    public String optionToHtml(Options.OptionInfo oi) {
        String jdoc;
        StringBuilder b = new StringBuilder();
        Formatter f = new Formatter(b);
        if (oi.short_name != null) {
            f.format("<b>-%s</b> ", oi.short_name);
        }
        for (String a : oi.aliases) {
            f.format("<b>%s</b> ", a);
        }
        String prefix = this.getUseSingleDash() ? "-" : "--";
        f.format("<b>%s%s=</b><i>%s</i>", prefix, oi.long_name, oi.type_name);
        if (oi.list != null) {
            b.append(" <code>[+]</code>");
        }
        f.format(".%n ", new Object[0]);
        String string = jdoc = oi.jdoc == null ? "" : oi.jdoc;
        if (oi.no_doc_default || oi.default_str == null) {
            f.format("%s", jdoc);
        } else {
            String default_str = "default " + oi.default_str;
            String suffix = "";
            if (jdoc.endsWith("</p>")) {
                suffix = "</p>";
                jdoc = jdoc.substring(0, jdoc.length() - suffix.length());
            }
            f.format("%s [%s]%s", jdoc, StringEscapeUtils.escapeHtml4(default_str), suffix);
        }
        if (oi.base_type.isEnum()) {
            b.append("<ul>");
            assert (oi.enum_jdoc != null) : "@AssumeAssertion(nullness): dependent: non-null if oi.base_type is an enum";
            for (Map.Entry<String, String> entry : oi.enum_jdoc.entrySet()) {
                b.append("<li><b>").append(entry.getKey()).append("</b>");
                if (entry.getValue().length() != 0) {
                    b.append(" ").append(entry.getValue());
                }
                b.append("</li>");
            }
            b.append("</ul>");
        }
        return b.toString();
    }

    public static String javadocToHtml(Doc doc) {
        Tag[] tags;
        StringBuilder b = new StringBuilder();
        for (Tag tag : tags = doc.inlineTags()) {
            if (tag instanceof SeeTag) {
                b.append("<code>" + tag.text() + "</code>");
                continue;
            }
            b.append(tag.text());
        }
        SeeTag[] seetags = doc.seeTags();
        if (seetags.length > 0) {
            b.append(" See: ");
            StringBuilderDelimited bb = new StringBuilderDelimited(", ");
            for (SeeTag tag : seetags) {
                bb.append("<code>" + tag.text() + "</code>");
            }
            b.append(bb);
            b.append(".");
        }
        return b.toString();
    }

    public boolean getFormatJavadoc() {
        return this.formatJavadoc;
    }

    public void setFormatJavadoc(boolean val) {
        if (val && !this.formatJavadoc) {
            this.startDelim = "* " + this.startDelim;
            this.endDelim = "* " + this.endDelim;
        } else if (!val && this.formatJavadoc) {
            this.startDelim = StringUtils.removeStart("* ", this.startDelim);
            this.endDelim = StringUtils.removeStart("* ", this.endDelim);
        }
        this.formatJavadoc = val;
    }

    public boolean getUseSingleDash() {
        return this.options.isUsingSingleDash();
    }

    public void setUseSingleDash(boolean val) {
        this.options.use_single_dash(true);
    }
}

