/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;

public final class JWhich {
    private static String CLASSPATH;

    private JWhich() {
        JWhich.getClasspath();
    }

    public static void which(String className) {
        URL classUrl = JWhich.findClass(className);
        if (classUrl == null) {
            System.out.println("\nClass '" + className + "' not found.");
        } else {
            System.out.println("\nClass '" + className + "' found in \n'" + classUrl.getFile() + "'");
        }
        JWhich.validate();
        JWhich.printClasspath();
    }

    public static URL findClass(String className) {
        return JWhich.class.getResource(JWhich.asResourceName(className));
    }

    protected static String asResourceName(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        resource = resource.replace('.', '/');
        resource = resource + ".class";
        return resource;
    }

    public static void validate() {
        StringTokenizer tokenizer = new StringTokenizer(JWhich.getClasspath(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            File f = new File(element);
            if (!f.exists()) {
                System.out.println("\nClasspath element '" + element + "' does not exist.");
                continue;
            }
            if (f.isDirectory() || element.toLowerCase().endsWith(".jar") || element.toLowerCase().endsWith(".zip")) continue;
            System.out.println("\nClasspath element '" + element + "' " + "is not a directory, .jar file, or .zip file.");
        }
    }

    public static void printClasspath() {
        System.out.println("\nClasspath:");
        StringTokenizer tokenizer = new StringTokenizer(JWhich.getClasspath(), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            System.out.println(tokenizer.nextToken());
        }
    }

    public static void setClasspath(String classpath) {
        CLASSPATH = classpath;
    }

    protected static String getClasspath() {
        if (CLASSPATH == null) {
            String classpath = System.getProperty("java.class.path");
            JWhich.setClasspath(classpath);
        }
        return CLASSPATH;
    }

    private static void instanceMain(String[] args) {
        if (args.length == 0) {
            JWhich.printUsage();
        }
        for (int cmdIndex = 0; cmdIndex < args.length; ++cmdIndex) {
            String cmd = args[cmdIndex];
            if ("-help".equals(cmd)) {
                JWhich.printUsage();
                continue;
            }
            JWhich.which(cmd);
        }
    }

    private static void printUsage() {
        System.out.println("\nSyntax: java JWhich [options] className");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-help     Prints usage information.");
        System.out.println("");
        System.out.println("Examples:");
        System.out.println("\tjava JWhich MyClass");
        System.out.println("\tjava JWhich my.package.MyClass");
        System.exit(0);
    }

    public static void main(String[] args) {
        JWhich.instanceMain(args);
    }
}

