/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.plume.ArraysMDE;
import afu.plume.Hasher;
import afu.plume.WeakHasherMap;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;

public final class Intern {
    private static final int FACTOR = 23;
    private static final double DOUBLE_FACTOR = 263.0;
    private static WeakHasherMap<Integer, WeakReference<Integer>> internedIntegers = new WeakHasherMap(new IntegerHasher());
    private static WeakHasherMap<Long, WeakReference<Long>> internedLongs = new WeakHasherMap(new LongHasher());
    private static WeakHasherMap<int[], WeakReference<int[]>> internedIntArrays = new WeakHasherMap(new IntArrayHasher());
    private static WeakHasherMap<long[], WeakReference<long[]>> internedLongArrays = new WeakHasherMap(new LongArrayHasher());
    private static WeakHasherMap<Double, WeakReference<Double>> internedDoubles = new WeakHasherMap(new DoubleHasher());
    private static Double internedDoubleNaN = new Double(Double.NaN);
    private static Double internedDoubleZero = new Double(0.0);
    private static WeakHasherMap<double[], WeakReference<double[]>> internedDoubleArrays = new WeakHasherMap(new DoubleArrayHasher());
    private static WeakHasherMap<String[], WeakReference<String[]>> internedStringArrays = new WeakHasherMap(new StringArrayHasher());
    private static WeakHasherMap<Object[], WeakReference<Object[]>> internedObjectArrays = new WeakHasherMap(new ObjectArrayHasher());
    private static WeakHasherMap<SequenceAndIndices<int[]>, WeakReference<int[]>> internedIntSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<long[]>, WeakReference<long[]>> internedLongSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<double[]>, WeakReference<double[]>> internedDoubleSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<Object[]>, WeakReference<Object[]>> internedObjectSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<String[]>, WeakReference<String[]>> internedStringSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());

    private Intern() {
        throw new Error("do not instantiate");
    }

    public static String[] internStrings(String[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            a[i] = a[i].intern();
        }
        return a;
    }

    public static boolean isInterned(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return value == ((String)value).intern();
        }
        if (value instanceof String[]) {
            return value == Intern.intern((String[])value);
        }
        if (value instanceof Integer) {
            return value == Intern.intern((Integer)value);
        }
        if (value instanceof Long) {
            return value == Intern.intern((Long)value);
        }
        if (value instanceof int[]) {
            return value == Intern.intern((int[])value);
        }
        if (value instanceof long[]) {
            return value == Intern.intern((long[])value);
        }
        if (value instanceof Double) {
            return value == Intern.intern((Double)value);
        }
        if (value instanceof double[]) {
            return value == Intern.intern((double[])value);
        }
        if (value instanceof Object[]) {
            return value == Intern.intern((Object[])value);
        }
        return true;
    }

    public static int numIntegers() {
        return internedIntegers.size();
    }

    public static int numLongs() {
        return internedLongs.size();
    }

    public static int numIntArrays() {
        return internedIntArrays.size();
    }

    public static int numLongArrays() {
        return internedLongArrays.size();
    }

    public static int numDoubles() {
        return internedDoubles.size();
    }

    public static int numDoubleArrays() {
        return internedDoubleArrays.size();
    }

    public static int numStringArrays() {
        return internedStringArrays.size();
    }

    public static int numObjectArrays() {
        return internedObjectArrays.size();
    }

    public static Iterator<Integer> integers() {
        return internedIntegers.keySet().iterator();
    }

    public static Iterator<Long> longs() {
        return internedLongs.keySet().iterator();
    }

    public static Iterator<int[]> intArrays() {
        return internedIntArrays.keySet().iterator();
    }

    public static Iterator<long[]> longArrays() {
        return internedLongArrays.keySet().iterator();
    }

    public static Iterator<Double> doubles() {
        return internedDoubles.keySet().iterator();
    }

    public static Iterator<double[]> doubleArrays() {
        return internedDoubleArrays.keySet().iterator();
    }

    public static Iterator<String[]> stringArrays() {
        return internedStringArrays.keySet().iterator();
    }

    public static Iterator<Object[]> objectArrays() {
        return internedObjectArrays.keySet().iterator();
    }

    public static String intern(String a) {
        if (a == null) {
            return null;
        }
        return a.intern();
    }

    public static long intern(long l) {
        return l;
    }

    public static double intern(double d) {
        return d;
    }

    public static Integer intern(Integer a) {
        WeakReference<Integer> lookup = internedIntegers.get(a);
        if (lookup != null) {
            return (Integer)lookup.get();
        }
        Integer result = a;
        internedIntegers.put(result, new WeakReference<Integer>(result));
        return result;
    }

    public static Integer internedInteger(int i) {
        return Intern.intern((Integer)i);
    }

    public static Integer internedInteger(String s2) {
        return Intern.intern(Integer.decode(s2));
    }

    public static Long intern(Long a) {
        WeakReference<Long> lookup = internedLongs.get(a);
        if (lookup != null) {
            return (Long)lookup.get();
        }
        Long result = a;
        internedLongs.put(result, new WeakReference<Long>(result));
        return result;
    }

    public static Long internedLong(long i) {
        return Intern.intern((Long)i);
    }

    public static Long internedLong(String s2) {
        return Intern.intern(Long.decode(s2));
    }

    public static int[] intern(int[] a) {
        WeakReference<int[]> lookup = internedIntArrays.get(a);
        if (lookup != null) {
            return (int[])lookup.get();
        }
        int[] result = a;
        internedIntArrays.put(result, new WeakReference<int[]>(result));
        return result;
    }

    public static long[] intern(long[] a) {
        WeakReference<long[]> lookup = internedLongArrays.get(a);
        if (lookup != null) {
            return (long[])lookup.get();
        }
        long[] result = a;
        internedLongArrays.put(result, new WeakReference<long[]>(result));
        return result;
    }

    public static Double intern(Double a) {
        if (a.isNaN()) {
            return internedDoubleNaN;
        }
        if (a == 0.0) {
            return internedDoubleZero;
        }
        WeakReference<Double> lookup = internedDoubles.get(a);
        if (lookup != null) {
            return (Double)lookup.get();
        }
        Double result = a;
        internedDoubles.put(result, new WeakReference<Double>(result));
        return result;
    }

    public static Double internedDouble(double d) {
        return Intern.intern((Double)d);
    }

    public static Double internedDouble(String s2) {
        return Intern.internedDouble(Double.parseDouble(s2));
    }

    public static double[] intern(double[] a) {
        WeakReference<double[]> lookup = internedDoubleArrays.get(a);
        if (lookup != null) {
            return (double[])lookup.get();
        }
        double[] result = a;
        internedDoubleArrays.put(result, new WeakReference<double[]>(result));
        return result;
    }

    public static String[] intern(String[] a) {
        String[] result;
        for (int k = 0; k < a.length; ++k) {
            assert (a[k] == Intern.intern(a[k]));
        }
        WeakReference<String[]> lookup = internedStringArrays.get(a);
        if (lookup != null) {
            result = (String[])lookup.get();
        } else {
            result = a;
            internedStringArrays.put(result, new WeakReference<String[]>(result));
        }
        String[] polyresult = result;
        return polyresult;
    }

    public static Object[] intern(Object[] a) {
        Object[] result;
        WeakReference<Object[]> lookup = internedObjectArrays.get(a);
        if (lookup != null) {
            result = (Object[])lookup.get();
        } else {
            result = a;
            internedObjectArrays.put(result, new WeakReference<Object[]>(result));
        }
        Object[] polyresult = result;
        return polyresult;
    }

    public static Object intern(Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof String) {
            return Intern.intern((String)a);
        }
        if (a instanceof String[]) {
            String[] asArray = (String[])a;
            return Intern.intern(asArray);
        }
        if (a instanceof Integer) {
            return Intern.intern((Integer)a);
        }
        if (a instanceof Long) {
            return Intern.intern((Long)a);
        }
        if (a instanceof int[]) {
            return Intern.intern((int[])a);
        }
        if (a instanceof long[]) {
            return Intern.intern((long[])a);
        }
        if (a instanceof Double) {
            return Intern.intern((Double)a);
        }
        if (a instanceof double[]) {
            return Intern.intern((double[])a);
        }
        if (a instanceof Object[]) {
            Object[] asArray = (Object[])a;
            return Intern.intern(asArray);
        }
        throw new IllegalArgumentException("Arguments of type " + a.getClass() + " cannot be interned");
    }

    public static int[] internSubsequence(int[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<int[]> sai = new SequenceAndIndices<int[]>(seq, start, end);
        WeakReference<int[]> lookup = internedIntSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (int[])lookup.get();
        }
        int[] subseqUninterned = ArraysMDE.subarray(seq, start, end - start);
        int[] subseq = Intern.intern(subseqUninterned);
        internedIntSequenceAndIndices.put(sai, new WeakReference<int[]>(subseq));
        return subseq;
    }

    public static long[] internSubsequence(long[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<long[]> sai = new SequenceAndIndices<long[]>(seq, start, end);
        WeakReference<long[]> lookup = internedLongSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (long[])lookup.get();
        }
        long[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        long[] subseq = Intern.intern(subseq_uninterned);
        internedLongSequenceAndIndices.put(sai, new WeakReference<long[]>(subseq));
        return subseq;
    }

    public static double[] internSubsequence(double[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<double[]> sai = new SequenceAndIndices<double[]>(seq, start, end);
        WeakReference<double[]> lookup = internedDoubleSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (double[])lookup.get();
        }
        double[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        double[] subseq = Intern.intern(subseq_uninterned);
        internedDoubleSequenceAndIndices.put(sai, new WeakReference<double[]>(subseq));
        return subseq;
    }

    public static Object[] internSubsequence(Object[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<Object[]> sai = new SequenceAndIndices<Object[]>(seq, start, end);
        WeakReference<Object[]> lookup = internedObjectSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (Object[])lookup.get();
        }
        Object[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        Object[] subseq = Intern.intern(subseq_uninterned);
        WeakReference<Object[]> ignore = internedObjectSequenceAndIndices.put(sai, new WeakReference<Object[]>(subseq));
        return subseq;
    }

    public static String[] internSubsequence(String[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<String[]> sai = new SequenceAndIndices<String[]>(seq, start, end);
        WeakReference<String[]> lookup = internedStringSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (String[])lookup.get();
        }
        String[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        String[] subseq = Intern.intern(subseq_uninterned);
        WeakReference<String[]> ignore = internedStringSequenceAndIndices.put(sai, new WeakReference<String[]>(subseq));
        return subseq;
    }

    private static final class SequenceAndIndicesHasher<T>
    implements Hasher {
        private SequenceAndIndicesHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            SequenceAndIndices sai1 = (SequenceAndIndices)a1;
            SequenceAndIndices sai2 = (SequenceAndIndices)a2;
            return sai1.equals(sai2);
        }

        @Override
        public int hashCode(Object o) {
            return o.hashCode();
        }
    }

    private static final class SequenceAndIndices<T> {
        public T seq;
        public int start;
        public int end;

        public SequenceAndIndices(T seq, int start, int end) {
            this.seq = seq;
            this.start = start;
            this.end = end;
            assert (Intern.isInterned(seq));
        }

        public boolean equals(Object other) {
            if (other instanceof SequenceAndIndices) {
                SequenceAndIndices other_sai = (SequenceAndIndices)other;
                return this.equals(other_sai);
            }
            return false;
        }

        public boolean equals(SequenceAndIndices<T> other) {
            return this.seq == other.seq && this.start == other.start && this.end == other.end;
        }

        public int hashCode() {
            return this.seq.hashCode() + this.start * 30 - this.end * 2;
        }

        public String toString() {
            return "SAI(" + this.start + "," + this.end + ") from: " + ArraysMDE.toString(this.seq);
        }
    }

    private static final class ObjectArrayHasher
    implements Hasher {
        private ObjectArrayHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((Object[])a1, (Object[])a2);
        }

        @Override
        public int hashCode(Object o) {
            return Arrays.hashCode((Object[])o);
        }
    }

    private static final class StringArrayHasher
    implements Hasher {
        private StringArrayHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((String[])a1, (String[])a2);
        }

        @Override
        public int hashCode(Object o) {
            return Arrays.hashCode((String[])o);
        }
    }

    private static final class DoubleArrayHasher
    implements Hasher {
        private DoubleArrayHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            double[] da1 = (double[])a1;
            double[] da2 = (double[])a2;
            if (da1.length != da2.length) {
                return false;
            }
            for (int i = 0; i < da1.length; ++i) {
                if (da1[i] == da2[i] || Double.isNaN(da1[i]) && Double.isNaN(da2[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode(Object o) {
            double[] a = (double[])o;
            double running = 0.0;
            for (int i = 0; i < a.length; ++i) {
                double elt = Double.isNaN(a[i]) ? 0.0 : a[i];
                running = running * 23.0 + elt * 263.0;
            }
            long result = Math.round(running);
            return (int)(result % Integer.MAX_VALUE);
        }
    }

    private static final class DoubleHasher
    implements Hasher {
        private DoubleHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            return a1.equals(a2);
        }

        @Override
        public int hashCode(Object o) {
            Double d = (Double)o;
            return d.hashCode();
        }
    }

    private static final class LongArrayHasher
    implements Hasher {
        private LongArrayHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((long[])a1, (long[])a2);
        }

        @Override
        public int hashCode(Object o) {
            return Arrays.hashCode((long[])o);
        }
    }

    private static final class IntArrayHasher
    implements Hasher {
        private IntArrayHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((int[])a1, (int[])a2);
        }

        @Override
        public int hashCode(Object o) {
            return Arrays.hashCode((int[])o);
        }
    }

    private static final class LongHasher
    implements Hasher {
        private LongHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            return a1.equals(a2);
        }

        @Override
        public int hashCode(Object o) {
            Long i = (Long)o;
            return i.intValue();
        }
    }

    private static final class IntegerHasher
    implements Hasher {
        private IntegerHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            return a1.equals(a2);
        }

        @Override
        public int hashCode(Object o) {
            Integer i = (Integer)o;
            return i;
        }
    }
}

