/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.net.fortuna.ical4j.data.CalendarBuilder;
import afu.net.fortuna.ical4j.data.ParserException;
import afu.net.fortuna.ical4j.model.Calendar;
import afu.net.fortuna.ical4j.model.Component;
import afu.net.fortuna.ical4j.model.ComponentList;
import afu.net.fortuna.ical4j.model.Date;
import afu.net.fortuna.ical4j.model.DateTime;
import afu.net.fortuna.ical4j.model.Dur;
import afu.net.fortuna.ical4j.model.Parameter;
import afu.net.fortuna.ical4j.model.Period;
import afu.net.fortuna.ical4j.model.PeriodList;
import afu.net.fortuna.ical4j.model.TimeZone;
import afu.net.fortuna.ical4j.model.TimeZoneRegistry;
import afu.net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import afu.net.fortuna.ical4j.model.component.VEvent;
import afu.net.fortuna.ical4j.model.component.VFreeBusy;
import afu.net.fortuna.ical4j.model.parameter.FbType;
import afu.net.fortuna.ical4j.model.property.DtStart;
import afu.net.fortuna.ical4j.model.property.FreeBusy;
import afu.plume.Option;
import afu.plume.Options;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ICalAvailable {
    @Option(value="first date to summarize")
    public static String date = "today";
    public static DateTime start_date = new DateTime();
    @Option(value="number of calendar days to summarize")
    public static int days = 8;
    @Option(value="<url> schedule in iCal format")
    public static List<String> iCal_URL = new ArrayList<String>();
    @Option(value="time ranges during which appointments are permitted")
    public static String business_hours = "9am-5pm";
    static List<Period> businessHours = new ArrayList<Period>();
    static List<Integer> businessDays = new ArrayList<Integer>();
    static TimeZoneRegistry tzRegistry;
    @Option(value="<timezone> time zone, e.g.: America/New_York", noDocDefault=true)
    public static String timezone1;
    static TimeZone tz1;
    @Option(value="<timezone> optional second time zone, e.g.: America/New_York")
    public static String timezone2;
    static TimeZone tz2;
    @Option(value="enable debugging output")
    public static boolean debug;
    static List<Calendar> calendars;
    static DateFormat tf;
    static DateFormat df;
    static DateFormat dffull;
    static Map<String, String> canonicalTimezones;
    static Map<String, String> printedTimezones;
    static Pattern timeRegexp;
    static SimpleDateFormat[] dateFormats;

    private ICalAvailable() {
        throw new Error("do not instantiate");
    }

    static void processOptions(String[] args) {
        Options options = new Options("ICalAvailable [options]", ICalAvailable.class);
        Object[] remaining_args = options.parse_or_usage(args);
        if (remaining_args.length != 0) {
            System.err.println("Unrecognized arguments: " + Arrays.toString(remaining_args));
            System.exit(1);
        }
        if (iCal_URL.isEmpty()) {
            System.err.println("Option iCal_URL must be specified.");
            System.exit(1);
        }
        tz1 = tzRegistry.getTimeZone(ICalAvailable.canonicalizeTimezone(timezone1));
        assert (tz1 != null);
        if (tz1 == null) {
            throw new Error("didn't find timezone " + timezone1);
        }
        if (timezone2 != null && (tz2 = tzRegistry.getTimeZone(ICalAvailable.canonicalizeTimezone(timezone2))) == null) {
            System.err.println("Unrecognized time zone (see http://php.net/manual/en/timezones.php ): " + timezone2);
            System.exit(1);
        }
        try {
            if (!date.equals("today")) {
                start_date = new DateTime(ICalAvailable.parseDate(date));
            }
        }
        catch (Exception e) {
            if (Pattern.matches(".*/.*", date) && !Pattern.matches(".*/.*/", date)) {
                System.err.println("Could not parse date (missing year?): " + date);
                System.exit(1);
            }
            System.err.println("Could not parse date: " + date);
            System.exit(1);
        }
        if (start_date == null) {
            System.err.println("Could not parse date: " + date);
            System.exit(1);
        }
        start_date.setTimeZone(tz1);
        start_date.setMinutes(start_date.getMinutes() / 15 * 15);
        for (String URL2 : iCal_URL) {
            try {
                Calendar c;
                URL url = new URL(URL2);
                CalendarBuilder builder = new CalendarBuilder();
                try {
                    c = builder.build(url.openStream());
                }
                catch (ParserException pe) {
                    if ("Error at line 1: Expected [BEGIN], read [<HTML>]".equals(pe.getMessage())) {
                        System.out.println();
                        System.out.println("It is possible that the calendar has moved.");
                        URL url2 = new URL(URL2);
                        InputStream url_is = url2.openStream();
                        System.out.printf("URL: %s%n", url2);
                        System.out.println("Contents:");
                        byte[] buffer = new byte[1024];
                        int len = url_is.read(buffer);
                        while (len != -1) {
                            System.out.write(buffer, 0, len);
                            len = url_is.read(buffer);
                        }
                        System.out.println();
                    }
                    throw pe;
                }
                calendars.add(c);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.println("Could not read calendar from " + URL2);
                System.exit(1);
            }
        }
        for (String range : business_hours.split(",")) {
            String[] startEnd = range.split("-");
            if (startEnd.length != 2) {
                System.err.println("Bad time range: " + range);
                System.exit(1);
            }
            DateTime busStart = ICalAvailable.parseTime(startEnd[0]);
            DateTime busEnd = ICalAvailable.parseTime(startEnd[1]);
            businessHours.add(new Period(busStart, busEnd));
        }
    }

    static String canonicalizeTimezone(String timezone) {
        String result = canonicalTimezones.get(timezone.toLowerCase());
        return result == null ? timezone : result;
    }

    static String printedTimezone(TimeZone tz) {
        String tzString = tz.getDisplayName();
        String result = printedTimezones.get(tzString);
        return result == null ? tzString : result;
    }

    static DateTime parseTime(String time) {
        Matcher m3 = timeRegexp.matcher(time);
        if (!m3.matches()) {
            System.err.println("Bad time: " + time);
            System.exit(1);
        }
        String hourString = m3.group(1);
        String minuteString = m3.group(3);
        String ampmString = m3.group(4);
        int hour = Integer.parseInt(hourString);
        if (ampmString != null && ampmString.toLowerCase().equals("pm")) {
            hour += 12;
        }
        int minute = 0;
        if (minuteString != null) {
            minute = Integer.parseInt(minuteString);
        }
        DateTime result = new DateTime();
        result.setTimeZone(tz1);
        result.setHours(hour);
        result.setMinutes(minute);
        result.setSeconds(0);
        return result;
    }

    static void printOptions() {
        System.out.println("business_hours: " + business_hours);
        System.out.println("businessHours: " + businessHours);
        System.out.println("businessDays: " + businessDays);
        System.out.println("timezone1: " + timezone1);
        System.out.println("timezone2: " + timezone2);
        System.out.println("start_date: " + start_date);
        System.out.println("days: " + days);
        System.out.println("iCal_URL: " + iCal_URL);
    }

    public static void main(String[] args) {
        ICalAvailable.processOptions(args);
        ArrayList<Period> available = new ArrayList<Period>();
        if (debug) {
            System.err.printf("Testing %d days%n", days);
        }
        for (int i = 0; i < days; ++i) {
            available.addAll(ICalAvailable.oneDayAvailable(start_date, calendars));
            start_date = new DateTime(start_date.getTime() + 86400000L);
            start_date.setTimeZone(tz1);
        }
        if (tz2 != null) {
            System.out.printf("Timezone: %s  [Timezone: %s]%n", ICalAvailable.printedTimezone(tz1), ICalAvailable.printedTimezone(tz2));
        }
        String lastDateString = null;
        for (Period p : available) {
            String dateString = ICalAvailable.formatDate(p.getStart(), tz1);
            if (!dateString.equals(lastDateString)) {
                lastDateString = dateString;
                System.out.println();
                System.out.println(dateString + ":");
            }
            String rangeString = ICalAvailable.rangeString(p, tz1);
            if (tz2 == null) {
                System.out.println(rangeString);
                continue;
            }
            String rangeString2 = ICalAvailable.rangeString(p, tz2);
            System.out.printf("%-20s[%s]%n", rangeString, rangeString2);
        }
    }

    static String rangeString(Period p, TimeZone tz) {
        tf.setTimeZone(tz);
        DateTime pstart = p.getStart();
        DateTime pend = p.getEnd();
        String rangeString = tf.format(pstart) + " to " + tf.format(pend);
        rangeString = rangeString.replace(" AM", "am");
        rangeString = rangeString.replace(" PM", "pm");
        return rangeString;
    }

    static String periodListString(PeriodList pl, TimeZone tz) {
        tf.setTimeZone(tz);
        StringBuilder result = new StringBuilder();
        for (Object p : pl) {
            assert (p != null) : "@AssumeAssertion(nullness): non-generic container class; elements are non-null";
            result.append(ICalAvailable.rangeString((Period)p, tz) + "\n");
        }
        return result.toString();
    }

    static DateTime mergeDateAndTime(DateTime date, DateTime time) {
        if (!date.getTimeZone().equals(time.getTimeZone())) {
            throw new Error(String.format("non-matching timezones: %s %s", date.getTimeZone(), time.getTimeZone()));
        }
        DateTime result = new DateTime(date);
        result.setHours(time.getHours());
        result.setMinutes(time.getMinutes());
        result.setSeconds(time.getSeconds());
        return result;
    }

    static List<Period> oneDayAvailable(DateTime day, List<Calendar> calendars) {
        if (debug) {
            System.err.printf("oneDayAvailable(%s, ...)%n", day);
        }
        ArrayList<Period> result = new ArrayList<Period>();
        int dayOfWeek = day.getDay();
        if (!businessDays.contains(dayOfWeek)) {
            return result;
        }
        for (Period bh : businessHours) {
            boolean isFree;
            FreeBusy freefb;
            DateTime start = ICalAvailable.mergeDateAndTime(day, bh.getStart());
            DateTime end = ICalAvailable.mergeDateAndTime(day, bh.getEnd());
            VFreeBusy request = new VFreeBusy(start, end, new Dur(0, 0, 0, 1));
            if (debug) {
                System.out.println("Request = " + request);
            }
            ComponentList busyTimes = new ComponentList();
            for (Calendar calendar : calendars) {
                ComponentList clist = calendar.getComponents();
                for (Component c : clist) {
                    if (c instanceof VEvent) {
                        VEvent v = (VEvent)c;
                        DtStart dts = v.getStartDate();
                        Parameter dtsValue = dts.getParameter("VALUE");
                        boolean bl = dtsValue != null && dtsValue.getValue().equals("DATE");
                    }
                    busyTimes.add(c);
                }
            }
            VFreeBusy response = new VFreeBusy(request, busyTimes);
            if (debug) {
                System.out.println("Response = " + response);
            }
            if ((freefb = (FreeBusy)response.getProperty("FREEBUSY")) == null) {
                if (!debug) continue;
                System.out.println("FREEBUSY property is null");
                continue;
            }
            boolean bl = isFree = freefb.getParameter("FBTYPE") == FbType.FREE;
            assert (isFree);
            PeriodList freePeriods = freefb.getPeriods();
            if (debug) {
                System.out.printf("Free periods: %n%s%n", ICalAvailable.periodListString(freePeriods, tz1));
            }
            result.addAll(freePeriods);
        }
        if (debug) {
            System.err.printf("oneDayAvailable(%s, ...) => %s elements%n", day, result.size());
        }
        return result;
    }

    static java.util.Date parseDate(String strDate) throws ParseException {
        if (Pattern.matches("^[0-9][0-9]?/[0-9][0-9]?$", date)) {
            int year = new Date().getYear() + 1900;
            strDate = strDate + "/" + year;
        }
        for (SimpleDateFormat this_df : dateFormats) {
            this_df.setLenient(false);
            try {
                java.util.Date result = this_df.parse(strDate);
                return result;
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("bad date " + strDate, 0);
    }

    static String formatDate(DateTime d, TimeZone tz) {
        df.setTimeZone(tz);
        String result = df.format(d);
        result = dffull.format(d).substring(0, 3) + " " + result;
        return result;
    }

    static {
        businessDays.add(1);
        businessDays.add(2);
        businessDays.add(3);
        businessDays.add(4);
        businessDays.add(5);
        tzRegistry = TimeZoneRegistryFactory.getInstance().createRegistry();
        timezone1 = TimeZone.getDefault().getID();
        debug = false;
        calendars = new ArrayList<Calendar>();
        tf = DateFormat.getTimeInstance(3, Locale.US);
        df = DateFormat.getDateInstance(2, Locale.US);
        dffull = DateFormat.getDateInstance(0, Locale.US);
        canonicalTimezones = new HashMap<String, String>();
        printedTimezones = new HashMap<String, String>();
        canonicalTimezones.put("eastern", "America/New_York");
        canonicalTimezones.put("est", "America/New_York");
        canonicalTimezones.put("edt", "America/New_York");
        canonicalTimezones.put("boston", "America/New_York");
        canonicalTimezones.put("america/boston", "America/New_York");
        canonicalTimezones.put("central", "America/Chicago");
        canonicalTimezones.put("mountain", "America/Denver");
        canonicalTimezones.put("arizona", "America/Phoenix");
        canonicalTimezones.put("pacific", "America/Los_Angeles");
        canonicalTimezones.put("pst", "America/Los_Angeles");
        canonicalTimezones.put("pacific standard time", "America/Los_Angeles");
        canonicalTimezones.put("pdt", "America/Los_Angeles");
        canonicalTimezones.put("india", "Asia/Calcutta");
        canonicalTimezones.put("china", "Asia/Shanghai");
        canonicalTimezones.put("berlin", "Europe/Berlin");
        canonicalTimezones.put("israel", "Asia/Tel_Aviv");
        canonicalTimezones.put("art", "America/Buenos_Aires");
        printedTimezones.put("Eastern Standard Time", "Eastern");
        printedTimezones.put("Central Standard Time", "Central");
        printedTimezones.put("Pacific Standard Time", "Pacific");
        timeRegexp = Pattern.compile("([0-2]?[0-9])(:([0-5][0-9]))?([aApP][mM])?");
        dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM/dd/yy")};
    }
}

