/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.plume.TimeLimitProcess;
import afu.plume.UtilMDE;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class FileCompiler {
    public static Runtime runtime = Runtime.getRuntime();
    static Pattern java_filename_pattern;
    private String compiler;
    private long timeLimit;

    public FileCompiler() {
        this("javac", 6000L);
    }

    public FileCompiler(String compiler2, long timeLimit) {
        this.compiler = compiler2;
        this.timeLimit = timeLimit;
    }

    public String compileFiles(List<String> fileNames) throws IOException {
        TimeLimitProcess p = this.compile_source(fileNames);
        String compile_errors = "";
        String compile_output = "";
        try {
            int n = p.waitFor();
        }
        catch (Throwable e) {
            compile_errors = UtilMDE.streamString(p.getErrorStream());
            compile_output = UtilMDE.streamString(p.getInputStream());
            System.out.println("Unexpected exception while compiling " + e);
            if (p.timed_out()) {
                System.out.println("Compile timed out after " + p.timeout_msecs() + " msecs");
            }
            e.printStackTrace();
            runtime.exit(1);
        }
        compile_errors = UtilMDE.streamString(p.getErrorStream());
        compile_output = UtilMDE.streamString(p.getInputStream());
        if (this.compiler.indexOf("javac") != -1) {
            this.recompile_without_errors(fileNames, compile_errors);
        }
        return compile_errors;
    }

    private TimeLimitProcess compile_source(List<String> filenames) throws IOException {
        int num_files = filenames.size();
        if (num_files == 0) {
            throw new Error("no files to compile were provided");
        }
        String to_compile = filenames.get(0);
        for (int i = 1; i < num_files; ++i) {
            to_compile = to_compile + " " + filenames.get(i);
        }
        String command = this.compiler + " " + to_compile;
        return new TimeLimitProcess(runtime.exec(command), this.timeLimit, true);
    }

    private void recompile_without_errors(List<String> fileNames, String errorString) throws IOException {
        if (errorString != null) {
            HashSet<String> errorClasses = new HashSet<String>();
            Matcher m3 = java_filename_pattern.matcher(errorString);
            while (m3.find()) {
                String sansExtension = m3.group(1);
                errorClasses.add(sansExtension);
            }
            ArrayList<String> retry = new ArrayList<String>();
            String filenames = "";
            for (String sourceFileName : fileNames) {
                String classFilePath = FileCompiler.getClassFilePath(sourceFileName = sourceFileName.trim());
                if (FileCompiler.fileExists(classFilePath) || errorClasses.contains(sourceFileName)) continue;
                retry.add(sourceFileName);
                filenames = filenames + " " + sourceFileName;
            }
            if (retry.size() > 0) {
                TimeLimitProcess tp = this.compile_source(retry);
                try {
                    tp.waitFor();
                }
                catch (InterruptedException e) {
                    System.out.println("Compile of " + filenames + " interrupted: " + e);
                }
            }
        }
    }

    private static String getClassFilePath(String sourceFilePath) {
        int index = sourceFilePath.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("sourceFilePath: " + sourceFilePath + " must end with an extention.");
        }
        return sourceFilePath.substring(0, index) + ".class";
    }

    private static boolean fileExists(String pathName) {
        return new File(pathName).exists();
    }

    static {
        try {
            String java_filename_re = "(?m)^([^ ]+?\\.java)";
            java_filename_pattern = Pattern.compile(java_filename_re);
        }
        catch (PatternSyntaxException me) {
            me.printStackTrace();
            throw new Error("Error in regexp", me);
        }
    }
}

